/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioRouting;
import android.media.DeniedByServerException;
import android.media.MediaDataSource;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.MediaFormat;
import android.media.MediaTimestamp;
import android.media.PlaybackParams;
import android.media.ResourceBusyException;
import android.media.SubtitleData;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.media.VolumeAutomation;
import android.media.VolumeShaper;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MediaPlayer
implements VolumeAutomation,
AudioRouting {
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_INFO_AUDIO_NOT_PLAYING = 804;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_VIDEO_NOT_PLAYING = 805;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    @Deprecated
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final int PREPARE_DRM_STATUS_PREPARATION_ERROR = 3;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_NETWORK_ERROR = 1;
    public static final int PREPARE_DRM_STATUS_PROVISIONING_SERVER_ERROR = 2;
    public static final int PREPARE_DRM_STATUS_SUCCESS = 0;
    public static final int SEEK_CLOSEST = 3;
    public static final int SEEK_CLOSEST_SYNC = 2;
    public static final int SEEK_NEXT_SYNC = 1;
    public static final int SEEK_PREVIOUS_SYNC = 0;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;

    public MediaPlayer() {
        throw new RuntimeException("Stub!");
    }

    public void setDisplay(SurfaceHolder sh) {
        throw new RuntimeException("Stub!");
    }

    public void setSurface(Surface surface) {
        throw new RuntimeException("Stub!");
    }

    public void setVideoScalingMode(int mode) {
        throw new RuntimeException("Stub!");
    }

    public static MediaPlayer create(Context context, Uri uri) {
        throw new RuntimeException("Stub!");
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        throw new RuntimeException("Stub!");
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder, AudioAttributes audioAttributes, int audioSessionId) {
        throw new RuntimeException("Stub!");
    }

    public static MediaPlayer create(Context context, int resid) {
        throw new RuntimeException("Stub!");
    }

    public static MediaPlayer create(Context context, int resid, AudioAttributes audioAttributes, int audioSessionId) {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri) throws IOException, IllegalArgumentException, IllegalStateException, SecurityException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers, @Nullable List<HttpCookie> cookies) throws IOException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(@NonNull Context context, @NonNull Uri uri, @Nullable Map<String, String> headers) throws IOException, IllegalArgumentException, IllegalStateException, SecurityException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(String path) throws IOException, IllegalArgumentException, IllegalStateException, SecurityException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(@NonNull AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void prepare() throws IOException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public native void prepareAsync() throws IllegalStateException;

    public void start() throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void stop() throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void pause() throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    @Override
    @NonNull
    public VolumeShaper createVolumeShaper(@NonNull VolumeShaper.Configuration configuration) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        throw new RuntimeException("Stub!");
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setWakeMode(Context context, int mode) {
        throw new RuntimeException("Stub!");
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        throw new RuntimeException("Stub!");
    }

    public native int getVideoWidth();

    public native int getVideoHeight();

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Stub!");
    }

    public native boolean isPlaying();

    public native void setPlaybackParams(@NonNull PlaybackParams var1);

    @NonNull
    public native PlaybackParams getPlaybackParams();

    public native void setSyncParams(@NonNull SyncParams var1);

    @NonNull
    public native SyncParams getSyncParams();

    public void seekTo(long msec, int mode) {
        throw new RuntimeException("Stub!");
    }

    public void seekTo(int msec) throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    @Nullable
    public MediaTimestamp getTimestamp() {
        throw new RuntimeException("Stub!");
    }

    public native int getCurrentPosition();

    public native int getDuration();

    public native void setNextMediaPlayer(MediaPlayer var1);

    public void release() {
        throw new RuntimeException("Stub!");
    }

    public void reset() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public void setAudioStreamType(int streamtype) {
        throw new RuntimeException("Stub!");
    }

    public void setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        throw new RuntimeException("Stub!");
    }

    public native void setLooping(boolean var1);

    public native boolean isLooping();

    public void setVolume(float leftVolume, float rightVolume) {
        throw new RuntimeException("Stub!");
    }

    public native void setAudioSessionId(int var1) throws IllegalArgumentException, IllegalStateException;

    public native int getAudioSessionId();

    public native void attachAuxEffect(int var1);

    public void setAuxEffectSendLevel(float level) {
        throw new RuntimeException("Stub!");
    }

    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void addTimedTextSource(String path, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void addTimedTextSource(FileDescriptor fd, String mimeType) throws IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) throws IllegalArgumentException, IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public int getSelectedTrack(int trackType) throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void selectTrack(int index) throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    public void deselectTrack(int index) throws IllegalStateException {
        throw new RuntimeException("Stub!");
    }

    protected void finalize() {
        throw new RuntimeException("Stub!");
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnSubtitleDataListener(@NonNull OnSubtitleDataListener listener, @NonNull Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnSubtitleDataListener(@NonNull OnSubtitleDataListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnSubtitleDataListener() {
        throw new RuntimeException("Stub!");
    }

    public void setOnMediaTimeDiscontinuityListener(@NonNull OnMediaTimeDiscontinuityListener listener, @NonNull Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnMediaTimeDiscontinuityListener(@NonNull OnMediaTimeDiscontinuityListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void clearOnMediaTimeDiscontinuityListener() {
        throw new RuntimeException("Stub!");
    }

    public void setOnTimedMetaDataAvailableListener(OnTimedMetaDataAvailableListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnErrorListener(OnErrorListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnInfoListener(OnInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnDrmConfigHelper(OnDrmConfigHelper listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnDrmInfoListener(OnDrmInfoListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnDrmInfoListener(OnDrmInfoListener listener, Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public void setOnDrmPreparedListener(OnDrmPreparedListener listener) {
        throw new RuntimeException("Stub!");
    }

    public void setOnDrmPreparedListener(OnDrmPreparedListener listener, Handler handler) {
        throw new RuntimeException("Stub!");
    }

    public DrmInfo getDrmInfo() {
        throw new RuntimeException("Stub!");
    }

    public void prepareDrm(@NonNull UUID uuid) throws ProvisioningNetworkErrorException, ProvisioningServerErrorException, ResourceBusyException, UnsupportedSchemeException {
        throw new RuntimeException("Stub!");
    }

    public void releaseDrm() throws NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public MediaDrm.KeyRequest getKeyRequest(@Nullable byte[] keySetId, @Nullable byte[] initData, @Nullable String mimeType, int keyType, @Nullable Map<String, String> optionalParameters) throws NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    public byte[] provideKeyResponse(@Nullable byte[] keySetId, @NonNull byte[] response) throws DeniedByServerException, NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    public void restoreKeys(@NonNull byte[] keySetId) throws NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    @NonNull
    public String getDrmPropertyString(@NonNull String propertyName) throws NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    public void setDrmPropertyString(@NonNull String propertyName, @NonNull String value) throws NoDrmSchemeException {
        throw new RuntimeException("Stub!");
    }

    public static class TrackInfo
    implements Parcelable {
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_METADATA = 5;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;

        TrackInfo() {
            throw new RuntimeException("Stub!");
        }

        public int getTrackType() {
            throw new RuntimeException("Stub!");
        }

        public String getLanguage() {
            throw new RuntimeException("Stub!");
        }

        public MediaFormat getFormat() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public int describeContents() {
            throw new RuntimeException("Stub!");
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            throw new RuntimeException("Stub!");
        }

        public String toString() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class ProvisioningServerErrorException
    extends MediaDrmException {
        public ProvisioningServerErrorException(String detailMessage) {
            super((String)null);
            throw new RuntimeException("Stub!");
        }
    }

    public static final class ProvisioningNetworkErrorException
    extends MediaDrmException {
        public ProvisioningNetworkErrorException(String detailMessage) {
            super((String)null);
            throw new RuntimeException("Stub!");
        }
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnTimedMetaDataAvailableListener {
        public void onTimedMetaDataAvailable(MediaPlayer var1, TimedMetaData var2);
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(@NonNull MediaPlayer var1, @NonNull SubtitleData var2);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    public static interface OnMediaTimeDiscontinuityListener {
        public void onMediaTimeDiscontinuity(@NonNull MediaPlayer var1, @NonNull MediaTimestamp var2);
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnDrmPreparedListener {
        public void onDrmPrepared(MediaPlayer var1, int var2);
    }

    public static interface OnDrmInfoListener {
        public void onDrmInfo(MediaPlayer var1, DrmInfo var2);
    }

    public static interface OnDrmConfigHelper {
        public void onDrmConfig(MediaPlayer var1);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static final class NoDrmSchemeException
    extends MediaDrmException {
        public NoDrmSchemeException(String detailMessage) {
            super((String)null);
            throw new RuntimeException("Stub!");
        }
    }

    public static final class MetricsConstants {
        public static final String CODEC_AUDIO = "android.media.mediaplayer.audio.codec";
        public static final String CODEC_VIDEO = "android.media.mediaplayer.video.codec";
        public static final String DURATION = "android.media.mediaplayer.durationMs";
        public static final String ERRORS = "android.media.mediaplayer.err";
        public static final String ERROR_CODE = "android.media.mediaplayer.errcode";
        public static final String FRAMES = "android.media.mediaplayer.frames";
        public static final String FRAMES_DROPPED = "android.media.mediaplayer.dropped";
        public static final String HEIGHT = "android.media.mediaplayer.height";
        public static final String MIME_TYPE_AUDIO = "android.media.mediaplayer.audio.mime";
        public static final String MIME_TYPE_VIDEO = "android.media.mediaplayer.video.mime";
        public static final String PLAYING = "android.media.mediaplayer.playingMs";
        public static final String WIDTH = "android.media.mediaplayer.width";

        private MetricsConstants() {
            throw new RuntimeException("Stub!");
        }
    }

    public static final class DrmInfo {
        private DrmInfo() {
            throw new RuntimeException("Stub!");
        }

        public Map<UUID, byte[]> getPssh() {
            throw new RuntimeException("Stub!");
        }

        public UUID[] getSupportedSchemes() {
            throw new RuntimeException("Stub!");
        }
    }
}

