/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.NotificationBuilderWithActions;
import android.support.v4.app.NotificationBuilderWithBuilderAccessor;
import android.widget.RemoteViews;
import java.lang.reflect.Field;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotificationCompatJellybean {
    static final String EXTRA_LOCAL_ONLY = "android.support.localOnly";
    private static volatile Field sExtrasField;

    NotificationCompatJellybean() {
    }

    public static void addBigTextStyle(NotificationBuilderWithBuilderAccessor b, CharSequence bigContentTitle, boolean useSummary, CharSequence summaryText, CharSequence bigText) {
        Notification.BigTextStyle style = new Notification.BigTextStyle(b.getBuilder()).setBigContentTitle(bigContentTitle).bigText(bigText);
        if (useSummary) {
            style.setSummaryText(summaryText);
        }
    }

    public static void addBigPictureStyle(NotificationBuilderWithBuilderAccessor b, CharSequence bigContentTitle, boolean useSummary, CharSequence summaryText, Bitmap bigPicture, Bitmap bigLargeIcon, boolean bigLargeIconSet) {
        Notification.BigPictureStyle style = new Notification.BigPictureStyle(b.getBuilder()).setBigContentTitle(bigContentTitle).bigPicture(bigPicture);
        if (bigLargeIconSet) {
            style.bigLargeIcon(bigLargeIcon);
        }
        if (useSummary) {
            style.setSummaryText(summaryText);
        }
    }

    public static void addInboxStyle(NotificationBuilderWithBuilderAccessor b, CharSequence bigContentTitle, boolean useSummary, CharSequence summaryText, ArrayList<CharSequence> texts) {
        Notification.InboxStyle style = new Notification.InboxStyle(b.getBuilder()).setBigContentTitle(bigContentTitle);
        if (useSummary) {
            style.setSummaryText(summaryText);
        }
        for (CharSequence text : texts) {
            style.addLine(text);
        }
    }

    public static Bundle getExtras(Notification notif) {
        try {
            Bundle extras;
            if (sExtrasField == null) {
                Field extrasField = Notification.class.getDeclaredField("extras");
                extrasField.setAccessible(true);
                sExtrasField = extrasField;
            }
            if ((extras = (Bundle)sExtrasField.get(notif)) == null) {
                extras = new Bundle();
                sExtrasField.set(notif, extras);
            }
            return extras;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access notification extras", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to access notification extras", e);
        }
    }

    public static boolean getLocalOnly(Notification notif) {
        return NotificationCompatJellybean.getExtras(notif).getBoolean(EXTRA_LOCAL_ONLY);
    }

    public static class Builder
    implements NotificationBuilderWithBuilderAccessor,
    NotificationBuilderWithActions {
        private Notification.Builder b;
        private final boolean mLocalOnly;

        public Builder(Context context, Notification n, CharSequence contentTitle, CharSequence contentText, CharSequence contentInfo, RemoteViews tickerView, int number, PendingIntent contentIntent, PendingIntent fullScreenIntent, Bitmap largeIcon, int mProgressMax, int mProgress, boolean mProgressIndeterminate, boolean useChronometer, int priority, CharSequence subText, boolean localOnly) {
            this.b = new Notification.Builder(context).setWhen(n.when).setSmallIcon(n.icon, n.iconLevel).setContent(n.contentView).setTicker(n.tickerText, tickerView).setSound(n.sound, n.audioStreamType).setVibrate(n.vibrate).setLights(n.ledARGB, n.ledOnMS, n.ledOffMS).setOngoing((n.flags & 2) != 0).setOnlyAlertOnce((n.flags & 8) != 0).setAutoCancel((n.flags & 0x10) != 0).setDefaults(n.defaults).setContentTitle(contentTitle).setContentText(contentText).setSubText(subText).setContentInfo(contentInfo).setContentIntent(contentIntent).setDeleteIntent(n.deleteIntent).setFullScreenIntent(fullScreenIntent, (n.flags & 0x80) != 0).setLargeIcon(largeIcon).setNumber(number).setUsesChronometer(useChronometer).setPriority(priority).setProgress(mProgressMax, mProgress, mProgressIndeterminate);
            this.mLocalOnly = localOnly;
        }

        public void addAction(int icon, CharSequence title, PendingIntent intent) {
            this.b.addAction(icon, title, intent);
        }

        public Notification.Builder getBuilder() {
            return this.b;
        }

        public Notification build() {
            Notification notif = this.b.build();
            if (this.mLocalOnly) {
                NotificationCompatJellybean.getExtras(notif).putBoolean(NotificationCompatJellybean.EXTRA_LOCAL_ONLY, this.mLocalOnly);
            }
            return notif;
        }
    }
}

