/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import android.net.Uri;
import android.os.SystemClock;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.Mp4MediaChunk;
import com.google.android.exoplayer.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.parser.Extractor;
import com.google.android.exoplayer.parser.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.parser.webm.WebmExtractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DashChunkSource
implements ChunkSource {
    public static final int USE_ALL_TRACKS = -1;
    private final TrackInfo trackInfo;
    private final DataSource dataSource;
    private final FormatEvaluator evaluator;
    private final FormatEvaluator.Evaluation evaluation;
    private final StringBuilder headerBuilder;
    private final long liveEdgeLatencyUs;
    private final int maxWidth;
    private final int maxHeight;
    private final Format[] formats;
    private final HashMap<String, RepresentationHolder> representationHolders;
    private final ManifestFetcher<MediaPresentationDescription> manifestFetcher;
    private final int adaptationSetIndex;
    private final int[] representationIndices;
    private final Map<UUID, byte[]> psshInfo;
    private MediaPresentationDescription currentManifest;
    private boolean finishedCurrentManifest;
    private boolean lastChunkWasInitialization;
    private IOException fatalError;

    public DashChunkSource(DataSource dataSource, FormatEvaluator formatEvaluator, Representation ... representations) {
        this(DashChunkSource.buildManifest(Arrays.asList(representations)), 0, null, dataSource, formatEvaluator);
    }

    public DashChunkSource(DataSource dataSource, FormatEvaluator formatEvaluator, List<Representation> representations) {
        this(DashChunkSource.buildManifest(representations), 0, null, dataSource, formatEvaluator);
    }

    public DashChunkSource(MediaPresentationDescription manifest, int adaptationSetIndex, int[] representationIndices, DataSource dataSource, FormatEvaluator formatEvaluator) {
        this(null, manifest, adaptationSetIndex, representationIndices, dataSource, formatEvaluator, 0L);
    }

    public DashChunkSource(ManifestFetcher<MediaPresentationDescription> manifestFetcher, int adaptationSetIndex, int[] representationIndices, DataSource dataSource, FormatEvaluator formatEvaluator, long liveEdgeLatencyMs) {
        this(manifestFetcher, manifestFetcher.getManifest(), adaptationSetIndex, representationIndices, dataSource, formatEvaluator, liveEdgeLatencyMs * 1000L);
    }

    private DashChunkSource(ManifestFetcher<MediaPresentationDescription> manifestFetcher, MediaPresentationDescription initialManifest, int adaptationSetIndex, int[] representationIndices, DataSource dataSource, FormatEvaluator formatEvaluator, long liveEdgeLatencyUs) {
        this.manifestFetcher = manifestFetcher;
        this.currentManifest = initialManifest;
        this.adaptationSetIndex = adaptationSetIndex;
        this.representationIndices = representationIndices;
        this.dataSource = dataSource;
        this.evaluator = formatEvaluator;
        this.liveEdgeLatencyUs = liveEdgeLatencyUs;
        this.evaluation = new FormatEvaluator.Evaluation();
        this.headerBuilder = new StringBuilder();
        this.psshInfo = DashChunkSource.getPsshInfo(this.currentManifest, adaptationSetIndex);
        Representation[] representations = DashChunkSource.getFilteredRepresentations(this.currentManifest, adaptationSetIndex, representationIndices);
        long periodDurationUs = representations[0].periodDurationMs == -1L ? -1L : representations[0].periodDurationMs * 1000L;
        this.trackInfo = new TrackInfo(representations[0].format.mimeType, periodDurationUs);
        this.formats = new Format[representations.length];
        this.representationHolders = new HashMap();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < representations.length; ++i) {
            this.formats[i] = representations[i].format;
            maxWidth = Math.max(this.formats[i].width, maxWidth);
            maxHeight = Math.max(this.formats[i].height, maxHeight);
            Extractor extractor = this.mimeTypeIsWebm(this.formats[i].mimeType) ? new WebmExtractor() : new FragmentedMp4Extractor();
            this.representationHolders.put(this.formats[i].id, new RepresentationHolder(representations[i], extractor));
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        Arrays.sort(this.formats, new Format.DecreasingBandwidthComparator());
    }

    @Override
    public final void getMaxVideoDimensions(MediaFormat out) {
        if (this.trackInfo.mimeType.startsWith("video")) {
            out.setMaxVideoDimensions(this.maxWidth, this.maxHeight);
        }
    }

    @Override
    public final TrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    @Override
    public void enable() {
        this.evaluator.enable();
        if (this.manifestFetcher != null) {
            this.manifestFetcher.enable();
        }
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
        this.evaluator.disable();
        if (this.manifestFetcher != null) {
            this.manifestFetcher.disable();
        }
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
        long minUpdatePeriod;
        if (this.manifestFetcher == null || !this.currentManifest.dynamic || this.fatalError != null) {
            return;
        }
        MediaPresentationDescription newManifest = this.manifestFetcher.getManifest();
        if (this.currentManifest != newManifest && newManifest != null) {
            Representation[] newRepresentations;
            for (Representation representation : newRepresentations = DashChunkSource.getFilteredRepresentations(newManifest, this.adaptationSetIndex, this.representationIndices)) {
                RepresentationHolder representationHolder = this.representationHolders.get(representation.format.id);
                DashSegmentIndex oldIndex = representationHolder.segmentIndex;
                DashSegmentIndex newIndex = representation.getIndex();
                int newFirstSegmentNum = newIndex.getFirstSegmentNum();
                int segmentNumShift = oldIndex.getSegmentNum(newIndex.getTimeUs(newFirstSegmentNum)) - newFirstSegmentNum;
                representationHolder.segmentNumShift += segmentNumShift;
                representationHolder.segmentIndex = newIndex;
            }
            this.currentManifest = newManifest;
            this.finishedCurrentManifest = false;
        }
        if ((minUpdatePeriod = this.currentManifest.minUpdatePeriod) == 0L) {
            minUpdatePeriod = 5000L;
        }
        if (this.finishedCurrentManifest && SystemClock.elapsedRealtime() > this.manifestFetcher.getManifestLoadTimestamp() + minUpdatePeriod) {
            this.manifestFetcher.requestRefresh();
        }
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> queue, long seekPositionUs, long playbackPositionUs, ChunkOperationHolder out) {
        int segmentNum;
        boolean indexUnbounded;
        if (this.fatalError != null) {
            out.chunk = null;
            return;
        }
        this.evaluation.queueSize = queue.size();
        if (this.evaluation.format == null || !this.lastChunkWasInitialization) {
            this.evaluator.evaluate(queue, playbackPositionUs, this.formats, this.evaluation);
        }
        Format selectedFormat = this.evaluation.format;
        out.queueSize = this.evaluation.queueSize;
        if (selectedFormat == null) {
            out.chunk = null;
            return;
        }
        if (out.queueSize == queue.size() && out.chunk != null && out.chunk.format.id.equals(selectedFormat.id)) {
            return;
        }
        RepresentationHolder representationHolder = this.representationHolders.get(selectedFormat.id);
        Representation selectedRepresentation = representationHolder.representation;
        DashSegmentIndex segmentIndex = representationHolder.segmentIndex;
        Extractor extractor = representationHolder.extractor;
        RangedUri pendingInitializationUri = null;
        RangedUri pendingIndexUri = null;
        if (extractor.getFormat() == null) {
            pendingInitializationUri = selectedRepresentation.getInitializationUri();
        }
        if (segmentIndex == null) {
            pendingIndexUri = selectedRepresentation.getIndexUri();
        }
        if (pendingInitializationUri != null || pendingIndexUri != null) {
            Chunk initializationChunk = this.newInitializationChunk(pendingInitializationUri, pendingIndexUri, selectedRepresentation, extractor, this.dataSource, this.evaluation.trigger);
            this.lastChunkWasInitialization = true;
            out.chunk = initializationChunk;
            return;
        }
        long nowUs = System.currentTimeMillis() * 1000L;
        int firstAvailableSegmentNum = segmentIndex.getFirstSegmentNum();
        int lastAvailableSegmentNum = segmentIndex.getLastSegmentNum();
        boolean bl = indexUnbounded = lastAvailableSegmentNum == -1;
        if (indexUnbounded) {
            long liveEdgeTimestampUs = nowUs - this.currentManifest.availabilityStartTime * 1000L;
            if (this.currentManifest.timeShiftBufferDepth != -1L) {
                long bufferDepthUs = this.currentManifest.timeShiftBufferDepth * 1000L;
                firstAvailableSegmentNum = Math.max(firstAvailableSegmentNum, segmentIndex.getSegmentNum(liveEdgeTimestampUs - bufferDepthUs));
            }
            lastAvailableSegmentNum = segmentIndex.getSegmentNum(liveEdgeTimestampUs) - 1;
        }
        if (queue.isEmpty()) {
            if (this.currentManifest.dynamic) {
                seekPositionUs = this.getLiveSeekPosition(nowUs, indexUnbounded);
            }
            segmentNum = segmentIndex.getSegmentNum(seekPositionUs);
        } else {
            segmentNum = queue.get((int)(out.queueSize - 1)).nextChunkIndex - representationHolder.segmentNumShift;
        }
        if (this.currentManifest.dynamic) {
            if (segmentNum < firstAvailableSegmentNum) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
            if (segmentNum > lastAvailableSegmentNum) {
                this.finishedCurrentManifest = !indexUnbounded;
                return;
            }
            if (!indexUnbounded && segmentNum == lastAvailableSegmentNum) {
                this.finishedCurrentManifest = true;
            }
        }
        if (segmentNum == -1) {
            out.chunk = null;
            return;
        }
        Chunk nextMediaChunk = this.newMediaChunk(representationHolder, this.dataSource, segmentNum, this.evaluation.trigger);
        this.lastChunkWasInitialization = false;
        out.chunk = nextMediaChunk;
    }

    @Override
    public IOException getError() {
        return this.fatalError != null ? this.fatalError : (this.manifestFetcher != null ? this.manifestFetcher.getError() : null);
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    private boolean mimeTypeIsWebm(String mimeType) {
        return mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm");
    }

    private Chunk newInitializationChunk(RangedUri initializationUri, RangedUri indexUri, Representation representation, Extractor extractor, DataSource dataSource, int trigger) {
        RangedUri requestUri;
        int expectedExtractorResult = 2;
        long indexAnchor = 0L;
        if (initializationUri != null) {
            expectedExtractorResult |= 8;
            requestUri = initializationUri.attemptMerge(indexUri);
            if (requestUri != null) {
                expectedExtractorResult |= 0x10;
                if (extractor.hasRelativeIndexOffsets()) {
                    indexAnchor = indexUri.start + indexUri.length;
                }
            } else {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
            if (extractor.hasRelativeIndexOffsets()) {
                indexAnchor = indexUri.start + indexUri.length;
            }
            expectedExtractorResult |= 0x10;
        }
        DataSpec dataSpec = new DataSpec(requestUri.getUri(), requestUri.start, requestUri.length, representation.getCacheKey());
        return new InitializationLoadable(dataSource, dataSpec, trigger, representation.format, extractor, expectedExtractorResult, indexAnchor);
    }

    private Chunk newMediaChunk(RepresentationHolder representationHolder, DataSource dataSource, int segmentNum, int trigger) {
        Representation representation = representationHolder.representation;
        DashSegmentIndex segmentIndex = representationHolder.segmentIndex;
        long startTimeUs = segmentIndex.getTimeUs(segmentNum);
        long endTimeUs = startTimeUs + segmentIndex.getDurationUs(segmentNum);
        boolean isLastSegment = !this.currentManifest.dynamic && segmentNum == segmentIndex.getLastSegmentNum();
        int nextAbsoluteSegmentNum = isLastSegment ? -1 : representationHolder.segmentNumShift + segmentNum + 1;
        RangedUri segmentUri = segmentIndex.getSegmentUrl(segmentNum);
        DataSpec dataSpec = new DataSpec(segmentUri.getUri(), segmentUri.start, segmentUri.length, representation.getCacheKey());
        long presentationTimeOffsetUs = representation.presentationTimeOffsetMs * 1000L;
        if (representation.format.mimeType.equals("text/vtt")) {
            if (representationHolder.vttHeaderOffsetUs != presentationTimeOffsetUs) {
                this.headerBuilder.setLength(0);
                this.headerBuilder.append("EXO-HEADER").append("=").append("OFFSET:").append(presentationTimeOffsetUs).append("\n");
                representationHolder.vttHeader = this.headerBuilder.toString().getBytes();
                representationHolder.vttHeaderOffsetUs = presentationTimeOffsetUs;
            }
            return new SingleSampleMediaChunk(dataSource, dataSpec, representation.format, 0, startTimeUs, endTimeUs, nextAbsoluteSegmentNum, null, representationHolder.vttHeader);
        }
        return new Mp4MediaChunk(dataSource, dataSpec, representation.format, trigger, startTimeUs, endTimeUs, nextAbsoluteSegmentNum, representationHolder.extractor, this.psshInfo, false, presentationTimeOffsetUs);
    }

    private long getLiveSeekPosition(long nowUs, boolean indexUnbounded) {
        long liveEdgeTimestampUs;
        if (indexUnbounded) {
            liveEdgeTimestampUs = nowUs - this.currentManifest.availabilityStartTime * 1000L;
        } else {
            liveEdgeTimestampUs = Long.MIN_VALUE;
            for (RepresentationHolder representationHolder : this.representationHolders.values()) {
                DashSegmentIndex segmentIndex = representationHolder.segmentIndex;
                int lastSegmentNum = segmentIndex.getLastSegmentNum();
                long indexLiveEdgeTimestampUs = segmentIndex.getTimeUs(lastSegmentNum) + segmentIndex.getDurationUs(lastSegmentNum);
                liveEdgeTimestampUs = Math.max(liveEdgeTimestampUs, indexLiveEdgeTimestampUs);
            }
        }
        return liveEdgeTimestampUs - this.liveEdgeLatencyUs;
    }

    private static Representation[] getFilteredRepresentations(MediaPresentationDescription manifest, int adaptationSetIndex, int[] representationIndices) {
        AdaptationSet adaptationSet = manifest.periods.get((int)0).adaptationSets.get(adaptationSetIndex);
        List<Representation> representations = adaptationSet.representations;
        if (representationIndices == null) {
            Representation[] filteredRepresentations = new Representation[representations.size()];
            representations.toArray(filteredRepresentations);
            return filteredRepresentations;
        }
        Representation[] filteredRepresentations = new Representation[representationIndices.length];
        for (int i = 0; i < representationIndices.length; ++i) {
            filteredRepresentations[i] = representations.get(representationIndices[i]);
        }
        return filteredRepresentations;
    }

    private static Map<UUID, byte[]> getPsshInfo(MediaPresentationDescription manifest, int adaptationSetIndex) {
        AdaptationSet adaptationSet = manifest.periods.get((int)0).adaptationSets.get(adaptationSetIndex);
        if (adaptationSet.contentProtections.isEmpty()) {
            return null;
        }
        HashMap<UUID, byte[]> psshInfo = new HashMap<UUID, byte[]>();
        for (ContentProtection contentProtection : adaptationSet.contentProtections) {
            if (contentProtection.uuid == null || contentProtection.data == null) continue;
            psshInfo.put(contentProtection.uuid, contentProtection.data);
        }
        return psshInfo.isEmpty() ? null : psshInfo;
    }

    private static MediaPresentationDescription buildManifest(List<Representation> representations) {
        Representation firstRepresentation = representations.get(0);
        AdaptationSet adaptationSet = new AdaptationSet(0, -1, representations);
        Period period = new Period(null, firstRepresentation.periodStartMs, firstRepresentation.periodDurationMs, Collections.singletonList(adaptationSet));
        long duration = firstRepresentation.periodDurationMs - firstRepresentation.periodStartMs;
        return new MediaPresentationDescription(-1L, duration, -1L, false, -1L, -1L, null, Collections.singletonList(period));
    }

    private static class RepresentationHolder {
        public final Representation representation;
        public final Extractor extractor;
        public DashSegmentIndex segmentIndex;
        public int segmentNumShift;
        public long vttHeaderOffsetUs;
        public byte[] vttHeader;

        public RepresentationHolder(Representation representation, Extractor extractor) {
            this.representation = representation;
            this.extractor = extractor;
            this.segmentIndex = representation.getIndex();
        }
    }

    private class InitializationLoadable
    extends Chunk {
        private final Extractor extractor;
        private final int expectedExtractorResult;
        private final long indexAnchor;
        private final Uri uri;

        public InitializationLoadable(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, Extractor extractor, int expectedExtractorResult, long indexAnchor) {
            super(dataSource, dataSpec, format, trigger);
            this.extractor = extractor;
            this.expectedExtractorResult = expectedExtractorResult;
            this.indexAnchor = indexAnchor;
            this.uri = dataSpec.uri;
        }

        @Override
        protected void consumeStream(NonBlockingInputStream stream) throws IOException {
            int result = this.extractor.read(stream, null);
            if (result != this.expectedExtractorResult) {
                throw new ParserException("Invalid extractor result. Expected " + this.expectedExtractorResult + ", got " + result);
            }
            if ((result & 0x10) != 0) {
                ((RepresentationHolder)((DashChunkSource)DashChunkSource.this).representationHolders.get((Object)this.format.id)).segmentIndex = new DashWrappingSegmentIndex(this.extractor.getIndex(), this.uri, this.indexAnchor);
            }
        }
    }

    public static class NoAdaptationSetException
    extends IOException {
        public NoAdaptationSetException(String message) {
            super(message);
        }
    }
}

