/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SourceStampVerifier {
    private SourceStampVerifier() {
    }

    public static void verifyV1SourceStamp(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result, byte[] apkDigest, byte[] sourceStampCertificateDigest, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        X509Certificate sourceStampCertificate = SourceStampVerifier.verifySourceStampCertificate(sourceStampBlockData, certFactory, sourceStampCertificateDigest, result);
        if (result.containsWarnings() || result.containsErrors()) {
            return;
        }
        SourceStampVerifier.verifySourceStampSignature(apkDigest, minSdkVersion, maxSdkVersion, sourceStampCertificate, sourceStampBlockData, result);
    }

    public static void verifyV2SourceStamp(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result, Map<Integer, byte[]> signatureSchemeApkDigests, byte[] sourceStampCertificateDigest, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        X509Certificate sourceStampCertificate = SourceStampVerifier.verifySourceStampCertificate(sourceStampBlockData, certFactory, sourceStampCertificateDigest, result);
        if (result.containsWarnings() || result.containsErrors()) {
            return;
        }
        ByteBuffer signedSignatureSchemes = ApkSigningBlockUtils.getLengthPrefixedSlice(sourceStampBlockData);
        HashMap<Integer, ByteBuffer> signedSignatureSchemeData = new HashMap<Integer, ByteBuffer>();
        while (signedSignatureSchemes.hasRemaining()) {
            ByteBuffer signedSignatureScheme = ApkSigningBlockUtils.getLengthPrefixedSlice(signedSignatureSchemes);
            int signatureSchemeId = signedSignatureScheme.getInt();
            signedSignatureSchemeData.put(signatureSchemeId, signedSignatureScheme);
        }
        for (Map.Entry<Integer, byte[]> signatureSchemeApkDigest : signatureSchemeApkDigests.entrySet()) {
            if (!signedSignatureSchemeData.containsKey(signatureSchemeApkDigest.getKey())) {
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_NO_SIGNATURE, new Object[0]);
                return;
            }
            SourceStampVerifier.verifySourceStampSignature(signatureSchemeApkDigest.getValue(), minSdkVersion, maxSdkVersion, sourceStampCertificate, (ByteBuffer)signedSignatureSchemeData.get(signatureSchemeApkDigest.getKey()), result);
            if (!result.containsWarnings() && !result.containsWarnings()) continue;
            return;
        }
    }

    private static X509Certificate verifySourceStampCertificate(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, byte[] sourceStampCertificateDigest, ApkSigningBlockUtils.Result.SignerInfo result) throws NoSuchAlgorithmException, ApkFormatException {
        X509Certificate sourceStampCertificate;
        byte[] sourceStampEncodedCertificate = ApkSigningBlockUtils.readLengthPrefixedByteArray(sourceStampBlockData);
        try {
            sourceStampCertificate = X509CertificateUtils.generateCertificate(sourceStampEncodedCertificate, certFactory);
        }
        catch (CertificateException e) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_CERTIFICATE, e);
            return null;
        }
        sourceStampCertificate = new GuaranteedEncodedFormX509Certificate(sourceStampCertificate, sourceStampEncodedCertificate);
        result.certs.add(sourceStampCertificate);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(sourceStampEncodedCertificate);
        byte[] sourceStampBlockCertificateDigest = messageDigest.digest();
        if (!Arrays.equals(sourceStampCertificateDigest, sourceStampBlockCertificateDigest)) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_CERTIFICATE_MISMATCH_BETWEEN_SIGNATURE_BLOCK_AND_APK, ApkSigningBlockUtils.toHex(sourceStampBlockCertificateDigest), ApkSigningBlockUtils.toHex(sourceStampCertificateDigest));
            return null;
        }
        return sourceStampCertificate;
    }

    private static void verifySourceStampSignature(byte[] apkDigest, int minSdkVersion, int maxSdkVersion, X509Certificate sourceStampCertificate, ByteBuffer signedData, ApkSigningBlockUtils.Result.SignerInfo result) throws ApkFormatException {
        List<ApkSigningBlockUtils.SupportedSignature> signaturesToVerify;
        SignatureAlgorithm signatureAlgorithm;
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        int signatureCount = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> supportedSignatures = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (supportedSignatures.isEmpty()) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_NO_SIGNATURE, new Object[0]);
            return;
        }
        try {
            signaturesToVerify = ApkSigningBlockUtils.getSignaturesToVerify(supportedSignatures, minSdkVersion, maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException e) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_NO_SUPPORTED_SIGNATURE, new Object[0]);
            return;
        }
        for (ApkSigningBlockUtils.SupportedSignature signature : signaturesToVerify) {
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            PublicKey publicKey = sourceStampCertificate.getPublicKey();
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                sig.update(apkDigest);
                byte[] sigBytes = signature.signature;
                if (sig.verify(sigBytes)) continue;
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                return;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e});
                return;
            }
        }
    }
}

