/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.util.Pair;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class V2SourceStampSigner {
    public static final int V2_SOURCE_STAMP_BLOCK_ID = 1845461005;

    private V2SourceStampSigner() {
    }

    public static Pair<byte[], Integer> generateSourceStampBlock(ApkSigningBlockUtils.SignerConfig sourceStampSignerConfig, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeDigestInfos) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        if (sourceStampSignerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> signatureSchemeDigests = new ArrayList<Pair<Integer, byte[]>>();
        V2SourceStampSigner.getSignedDigestsFor(3, signatureSchemeDigestInfos, sourceStampSignerConfig, signatureSchemeDigests);
        V2SourceStampSigner.getSignedDigestsFor(2, signatureSchemeDigestInfos, sourceStampSignerConfig, signatureSchemeDigests);
        V2SourceStampSigner.getSignedDigestsFor(1, signatureSchemeDigestInfos, sourceStampSignerConfig, signatureSchemeDigests);
        signatureSchemeDigests.sort(Comparator.comparing(Pair::getFirst));
        SourceStampBlock sourceStampBlock = new SourceStampBlock();
        try {
            sourceStampBlock.stampCertificate = sourceStampSignerConfig.certificates.get(0).getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new SignatureException("Retrieving the encoded form of the stamp certificate failed", e);
        }
        sourceStampBlock.signedDigests = signatureSchemeDigests;
        byte[] sourceStampSignerBlock = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{sourceStampBlock.stampCertificate, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(sourceStampBlock.signedDigests)});
        return Pair.of(ApkSigningBlockUtils.encodeAsLengthPrefixedElement(sourceStampSignerBlock), 1845461005);
    }

    private static void getSignedDigestsFor(int signatureSchemeVersion, Map<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeDigestInfos, ApkSigningBlockUtils.SignerConfig sourceStampSignerConfig, List<Pair<Integer, byte[]>> signatureSchemeDigests) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!signatureSchemeDigestInfos.containsKey(signatureSchemeVersion)) {
            return;
        }
        Map<ContentDigestAlgorithm, byte[]> digestInfo = signatureSchemeDigestInfos.get(signatureSchemeVersion);
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> digest : digestInfo.entrySet()) {
            digests.add(Pair.of(digest.getKey().getId(), digest.getValue()));
        }
        digests.sort(Comparator.comparing(Pair::getFirst));
        byte[] digestBytes = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(digests);
        List<Pair<Integer, byte[]>> signedDigest = ApkSigningBlockUtils.generateSignaturesOverData(sourceStampSignerConfig, digestBytes);
        signatureSchemeDigests.add(Pair.of(signatureSchemeVersion, ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedDigest)));
    }

    private static final class SourceStampBlock {
        public byte[] stampCertificate;
        public List<Pair<Integer, byte[]>> signedDigests;

        private SourceStampBlock() {
        }
    }
}

