/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HapticFeedbackConstants {

private HapticFeedbackConstants() { throw new RuntimeException("Stub!"); }

public static final int CLOCK_TICK = 4; // 0x4

public static final int CONFIRM = 16; // 0x10

public static final int CONTEXT_CLICK = 6; // 0x6

public static final int FLAG_IGNORE_GLOBAL_SETTING = 2; // 0x2

public static final int FLAG_IGNORE_VIEW_SETTING = 1; // 0x1

public static final int GESTURE_END = 13; // 0xd

public static final int GESTURE_START = 12; // 0xc

public static final int KEYBOARD_PRESS = 3; // 0x3

public static final int KEYBOARD_RELEASE = 7; // 0x7

public static final int KEYBOARD_TAP = 3; // 0x3

public static final int LONG_PRESS = 0; // 0x0

public static final int REJECT = 17; // 0x11

public static final int TEXT_HANDLE_MOVE = 9; // 0x9

public static final int VIRTUAL_KEY = 1; // 0x1

public static final int VIRTUAL_KEY_RELEASE = 8; // 0x8
}

