/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.os.Handler;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public final class Ac3PassthroughAudioTrackRenderer
extends TrackRenderer {
    public static final int MSG_SET_VOLUME = 1;
    private static final int SOURCE_STATE_NOT_READY = 0;
    private static final int SOURCE_STATE_READY = 1;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final SampleSource source;
    private final SampleHolder sampleHolder;
    private final MediaFormatHolder formatHolder;
    private int trackIndex;
    private MediaFormat format;
    private int sourceState;
    private boolean inputStreamEnded;
    private boolean shouldReadInputBuffer;
    private long currentPositionUs;
    private AudioTrack audioTrack;
    private int audioSessionId;

    public Ac3PassthroughAudioTrackRenderer(SampleSource source, Handler eventHandler, EventListener eventListener) {
        this.source = Assertions.checkNotNull(source);
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.sampleHolder = new SampleHolder(1);
        this.sampleHolder.data = ByteBuffer.allocateDirect(32768);
        this.formatHolder = new MediaFormatHolder();
        this.audioTrack = new AudioTrack();
        this.shouldReadInputBuffer = true;
    }

    @Override
    protected boolean isTimeSource() {
        return true;
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        for (int i = 0; i < this.source.getTrackCount(); ++i) {
            if (!Ac3PassthroughAudioTrackRenderer.handlesMimeType(this.source.getTrackInfo((int)i).mimeType)) continue;
            this.trackIndex = i;
            return 1;
        }
        return -1;
    }

    private static boolean handlesMimeType(String mimeType) {
        return "audio/mp4".equals(mimeType);
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        this.source.enable(this.trackIndex, positionUs);
        this.sourceState = 0;
        this.inputStreamEnded = false;
        this.currentPositionUs = positionUs;
    }

    @Override
    protected void doSomeWork(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        block7: {
            try {
                int n = this.source.continueBuffering(positionUs) ? (this.sourceState == 0 ? 1 : this.sourceState) : (this.sourceState = 0);
                if (this.format == null) {
                    this.readFormat();
                    break block7;
                }
                if (!this.audioTrack.isInitialized()) {
                    int oldAudioSessionId = this.audioSessionId;
                    try {
                        this.audioSessionId = this.audioTrack.initialize(oldAudioSessionId);
                    }
                    catch (AudioTrack.InitializationException e) {
                        this.notifyAudioTrackInitializationError(e);
                        throw new ExoPlaybackException(e);
                    }
                    if (this.getState() == 3) {
                        this.audioTrack.play();
                    }
                }
                this.feedInputBuffer();
            }
            catch (IOException e) {
                throw new ExoPlaybackException(e);
            }
        }
    }

    private void readFormat() throws IOException {
        int result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, false);
        if (result == -4) {
            this.format = this.formatHolder.format;
            this.audioTrack.reconfigure(this.format.getFrameworkMediaFormatV16(), 5, 0);
        }
    }

    private void feedInputBuffer() throws IOException, ExoPlaybackException {
        int handleBufferResult;
        if (!this.audioTrack.isInitialized() || this.inputStreamEnded) {
            return;
        }
        if (this.shouldReadInputBuffer) {
            this.sampleHolder.data.clear();
            int result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, false);
            if (result == -4) {
                this.format = this.formatHolder.format;
                this.audioTrack.reconfigure(this.format.getFrameworkMediaFormatV16(), 5, 0);
            }
            if (result == -1) {
                this.inputStreamEnded = true;
            }
            if (result != -3) {
                return;
            }
            this.shouldReadInputBuffer = false;
        }
        try {
            handleBufferResult = this.audioTrack.handleBuffer(this.sampleHolder.data, 0, this.sampleHolder.size, this.sampleHolder.timeUs);
        }
        catch (AudioTrack.WriteException e) {
            this.notifyAudioTrackWriteError(e);
            throw new ExoPlaybackException(e);
        }
        if ((handleBufferResult & 1) != 0) {
            this.currentPositionUs = Long.MIN_VALUE;
        }
        this.shouldReadInputBuffer = (handleBufferResult & 2) != 0;
    }

    @Override
    protected void onStarted() {
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded && (!this.audioTrack.hasPendingData() || !this.audioTrack.hasEnoughDataToBeginPlayback());
    }

    @Override
    protected boolean isReady() {
        return this.audioTrack.hasPendingData() || this.format != null && this.sourceState != 0;
    }

    @Override
    protected long getCurrentPositionUs() {
        long audioTrackCurrentPositionUs = this.audioTrack.getCurrentPositionUs(this.isEnded());
        if (audioTrackCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = Math.max(this.currentPositionUs, audioTrackCurrentPositionUs);
        }
        return this.currentPositionUs;
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        long sourceBufferedPosition = this.source.getBufferedPositionUs();
        return sourceBufferedPosition == -1L || sourceBufferedPosition == -3L ? sourceBufferedPosition : Math.max(sourceBufferedPosition, this.getCurrentPositionUs());
    }

    @Override
    protected void onDisabled() {
        this.audioSessionId = 0;
        this.shouldReadInputBuffer = true;
        this.audioTrack.reset();
    }

    @Override
    protected void seekTo(long positionUs) throws ExoPlaybackException {
        this.source.seekToUs(positionUs);
        this.sourceState = 0;
        this.inputStreamEnded = false;
        this.shouldReadInputBuffer = true;
        this.audioTrack.reset();
        this.currentPositionUs = Long.MIN_VALUE;
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.audioTrack.setVolume(((Float)message).floatValue());
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void notifyAudioTrackInitializationError(final AudioTrack.InitializationException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    Ac3PassthroughAudioTrackRenderer.this.eventListener.onAudioTrackInitializationError(e);
                }
            });
        }
    }

    private void notifyAudioTrackWriteError(final AudioTrack.WriteException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    Ac3PassthroughAudioTrackRenderer.this.eventListener.onAudioTrackWriteError(e);
                }
            });
        }
    }

    public static interface EventListener {
        public void onAudioTrackInitializationError(AudioTrack.InitializationException var1);

        public void onAudioTrackWriteError(AudioTrack.WriteException var1);
    }
}

