/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.audio;

import android.annotation.TargetApi;
import com.google.android.exoplayer.util.Util;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=21)
public final class AudioCapabilities {
    private final Set<Integer> supportedEncodings = new HashSet<Integer>();
    private final int maxChannelCount;

    public AudioCapabilities(int[] supportedEncodings, int maxChannelCount) {
        if (supportedEncodings != null) {
            for (int i : supportedEncodings) {
                this.supportedEncodings.add(i);
            }
        }
        this.maxChannelCount = maxChannelCount;
    }

    public boolean supportsAc3() {
        return Util.SDK_INT >= 21 && this.supportedEncodings.contains(5);
    }

    public boolean supportsEAc3() {
        return Util.SDK_INT >= 21 && this.supportedEncodings.contains(6);
    }

    public boolean supportsPcm() {
        return this.supportedEncodings.contains(2);
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioCapabilities)) {
            return false;
        }
        AudioCapabilities audioCapabilities = (AudioCapabilities)other;
        return this.supportedEncodings.equals(audioCapabilities.supportedEncodings) && this.maxChannelCount == audioCapabilities.maxChannelCount;
    }

    public int hashCode() {
        return this.maxChannelCount + 31 * this.supportedEncodings.hashCode();
    }

    public String toString() {
        return "AudioCapabilities[maxChannelCount=" + this.maxChannelCount + ", supportedEncodings=" + this.supportedEncodings + "]";
    }
}

