/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.upstream.UnexpectedLengthException;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DataSourceStream
implements Loader.Loadable,
NonBlockingInputStream {
    private static final int CHUNKED_ALLOCATION_INCREMENT = 262144;
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private final Allocator allocator;
    private final ReadHead readHead;
    private Allocation allocation;
    private volatile boolean loadCanceled;
    private volatile long loadPosition;
    private volatile long resolvedLength;
    private int writeFragmentIndex;
    private int writeFragmentOffset;
    private int writeFragmentRemainingLength;

    public DataSourceStream(DataSource dataSource, DataSpec dataSpec, Allocator allocator) {
        Assertions.checkState(dataSpec.length <= Integer.MAX_VALUE);
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.allocator = allocator;
        this.resolvedLength = -1L;
        this.readHead = new ReadHead();
    }

    public void resetReadPosition() {
        this.readHead.reset();
    }

    public long getReadPosition() {
        return this.readHead.position;
    }

    public long getLoadPosition() {
        return this.loadPosition;
    }

    public long getLength() {
        return this.resolvedLength != -1L ? this.resolvedLength : this.dataSpec.length;
    }

    public boolean isLoadFinished() {
        return this.resolvedLength != -1L && this.loadPosition == this.resolvedLength;
    }

    @Override
    public long getAvailableByteCount() {
        return this.loadPosition - (long)this.readHead.position;
    }

    @Override
    public boolean isEndOfStream() {
        return this.resolvedLength != -1L && (long)this.readHead.position == this.resolvedLength;
    }

    @Override
    public void close() {
        if (this.allocation != null) {
            this.allocation.release();
            this.allocation = null;
        }
    }

    @Override
    public int skip(int skipLength) {
        return this.read(null, null, 0, this.readHead, skipLength);
    }

    @Override
    public int read(ByteBuffer target1, int readLength) {
        return this.read(target1, null, 0, this.readHead, readLength);
    }

    @Override
    public int read(byte[] target, int offset, int readLength) {
        return this.read(null, target, offset, this.readHead, readLength);
    }

    private int read(ByteBuffer target, byte[] targetArray, int targetArrayOffset, ReadHead readHead, int readLength) {
        int bytesRead;
        int bufferReadLength;
        if (this.isEndOfStream()) {
            return -1;
        }
        int bytesToRead = (int)Math.min(this.loadPosition - (long)readHead.position, (long)readLength);
        if (bytesToRead == 0) {
            return 0;
        }
        if (readHead.position == 0) {
            readHead.fragmentIndex = 0;
            readHead.fragmentOffset = this.allocation.getFragmentOffset(0);
            readHead.fragmentRemaining = this.allocation.getFragmentLength(0);
        }
        byte[][] buffers = this.allocation.getBuffers();
        for (bytesRead = 0; bytesRead < bytesToRead; bytesRead += bufferReadLength) {
            if (readHead.fragmentRemaining == 0) {
                readHead.fragmentIndex++;
                readHead.fragmentOffset = this.allocation.getFragmentOffset(readHead.fragmentIndex);
                readHead.fragmentRemaining = this.allocation.getFragmentLength(readHead.fragmentIndex);
            }
            bufferReadLength = Math.min(readHead.fragmentRemaining, bytesToRead - bytesRead);
            if (target != null) {
                target.put(buffers[readHead.fragmentIndex], readHead.fragmentOffset, bufferReadLength);
            } else if (targetArray != null) {
                System.arraycopy(buffers[readHead.fragmentIndex], readHead.fragmentOffset, targetArray, targetArrayOffset, bufferReadLength);
                targetArrayOffset += bufferReadLength;
            }
            readHead.position += bufferReadLength;
            readHead.fragmentOffset += bufferReadLength;
            readHead.fragmentRemaining -= bufferReadLength;
        }
        return bytesRead;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        if (this.loadCanceled || this.isLoadFinished()) {
            return;
        }
        try {
            DataSpec loadDataSpec;
            if (this.loadPosition == 0L && this.resolvedLength == -1L) {
                loadDataSpec = this.dataSpec;
                long resolvedLength = this.dataSource.open(loadDataSpec);
                if (resolvedLength > Integer.MAX_VALUE) {
                    throw new DataSourceStreamLoadException(new UnexpectedLengthException(this.dataSpec.length, resolvedLength));
                }
                this.resolvedLength = resolvedLength;
            } else {
                long remainingLength = this.resolvedLength != -1L ? this.resolvedLength - this.loadPosition : -1L;
                loadDataSpec = new DataSpec(this.dataSpec.uri, this.dataSpec.position + this.loadPosition, remainingLength, this.dataSpec.key);
                this.dataSource.open(loadDataSpec);
            }
            if (this.allocation == null) {
                int initialAllocationSize = this.resolvedLength != -1L ? (int)this.resolvedLength : 262144;
                this.allocation = this.allocator.allocate(initialAllocationSize);
            }
            int allocationCapacity = this.allocation.capacity();
            if (this.loadPosition == 0L) {
                this.writeFragmentIndex = 0;
                this.writeFragmentOffset = this.allocation.getFragmentOffset(0);
                this.writeFragmentRemainingLength = this.allocation.getFragmentLength(0);
            }
            int read = Integer.MAX_VALUE;
            byte[][] buffers = this.allocation.getBuffers();
            while (!this.loadCanceled && read > 0 && this.maybeMoreToLoad()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                read = this.dataSource.read(buffers[this.writeFragmentIndex], this.writeFragmentOffset, this.writeFragmentRemainingLength);
                if (read > 0) {
                    this.loadPosition += (long)read;
                    this.writeFragmentOffset += read;
                    this.writeFragmentRemainingLength -= read;
                    if (this.writeFragmentRemainingLength != 0 || !this.maybeMoreToLoad()) continue;
                    ++this.writeFragmentIndex;
                    if (this.loadPosition == (long)allocationCapacity) {
                        this.allocation.ensureCapacity(allocationCapacity + 262144);
                        allocationCapacity = this.allocation.capacity();
                        buffers = this.allocation.getBuffers();
                    }
                    this.writeFragmentOffset = this.allocation.getFragmentOffset(this.writeFragmentIndex);
                    this.writeFragmentRemainingLength = this.allocation.getFragmentLength(this.writeFragmentIndex);
                    continue;
                }
                if (this.resolvedLength == -1L) {
                    this.resolvedLength = this.loadPosition;
                    continue;
                }
                if (this.resolvedLength == this.loadPosition) continue;
                throw new DataSourceStreamLoadException(new UnexpectedLengthException(this.resolvedLength, this.loadPosition));
            }
        }
        finally {
            Util.closeQuietly(this.dataSource);
        }
    }

    private boolean maybeMoreToLoad() {
        return this.resolvedLength == -1L || this.loadPosition < this.resolvedLength;
    }

    private static class ReadHead {
        private int position;
        private int fragmentIndex;
        private int fragmentOffset;
        private int fragmentRemaining;

        private ReadHead() {
        }

        public void reset() {
            this.position = 0;
            this.fragmentIndex = 0;
            this.fragmentOffset = 0;
            this.fragmentRemaining = 0;
        }
    }

    public static class DataSourceStreamLoadException
    extends IOException {
        public DataSourceStreamLoadException(IOException cause) {
            super(cause);
        }
    }
}

