/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NetworkLock;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public class PriorityDataSource
implements DataSource {
    private final DataSource upstream;
    private final int priority;

    public PriorityDataSource(int priority, DataSource upstream) {
        this.priority = priority;
        this.upstream = Assertions.checkNotNull(upstream);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        NetworkLock.instance.proceedOrThrow(this.priority);
        return this.upstream.open(dataSpec);
    }

    @Override
    public int read(byte[] buffer, int offset, int max) throws IOException {
        NetworkLock.instance.proceedOrThrow(this.priority);
        return this.upstream.read(buffer, offset, max);
    }

    @Override
    public void close() throws IOException {
        this.upstream.close();
    }
}

