/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class BitArray {
    private byte[] data;
    private int limit;
    private int byteOffset;
    private int bitOffset;

    public BitArray() {
    }

    public BitArray(byte[] data, int limit) {
        this.data = data;
        this.limit = limit;
    }

    public void reset() {
        this.byteOffset = 0;
        this.bitOffset = 0;
        this.limit = 0;
    }

    public void reset(byte[] data, int limit) {
        this.data = data;
        this.limit = limit;
        this.byteOffset = 0;
        this.bitOffset = 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public int append(DataSource dataSource, int length) throws IOException {
        this.expand(length);
        int bytesRead = dataSource.read(this.data, this.limit, length);
        if (bytesRead == -1) {
            return -1;
        }
        this.limit += bytesRead;
        return bytesRead;
    }

    public void append(BitArray bitsArray, int length) {
        this.expand(length);
        bitsArray.readBytes(this.data, this.limit, length);
        this.limit += length;
    }

    private void expand(int length) {
        if (this.data == null) {
            this.data = new byte[length];
            return;
        }
        if (this.data.length - this.limit < length) {
            byte[] newBuffer = new byte[this.limit + length];
            System.arraycopy(this.data, 0, newBuffer, 0, this.limit);
            this.data = newBuffer;
        }
    }

    public void clearReadData() {
        System.arraycopy(this.data, this.byteOffset, this.data, 0, this.limit - this.byteOffset);
        this.limit -= this.byteOffset;
        this.byteOffset = 0;
    }

    public int readUnsignedByte() {
        byte b = this.bitOffset != 0 ? (byte)(this.data[this.byteOffset] << this.bitOffset | this.data[this.byteOffset + 1] >> 8 - this.bitOffset) : this.data[this.byteOffset];
        ++this.byteOffset;
        return b & 0xFF;
    }

    public boolean readBit() {
        return this.readBits(1) == 1;
    }

    public int readBits(int n) {
        return (int)this.readBitsLong(n);
    }

    public long readBitsLong(int n) {
        if (n == 0) {
            return 0L;
        }
        long retval = 0L;
        while (n >= 8) {
            retval |= (long)(this.readUnsignedByte() << (n -= 8));
        }
        if (n > 0) {
            int nextBit = this.bitOffset + n;
            byte writeMask = (byte)(255 >> 8 - n);
            if (nextBit > 8) {
                retval |= (long)((this.getUnsignedByte(this.byteOffset) << nextBit - 8 | this.getUnsignedByte(this.byteOffset + 1) >> 16 - nextBit) & writeMask);
                ++this.byteOffset;
            } else {
                retval |= (long)(this.getUnsignedByte(this.byteOffset) >> 8 - nextBit & writeMask);
                if (nextBit == 8) {
                    ++this.byteOffset;
                }
            }
            this.bitOffset = nextBit % 8;
        }
        return retval;
    }

    private int getUnsignedByte(int offset) {
        return this.data[offset] & 0xFF;
    }

    public void skipBits(int n) {
        this.byteOffset += n / 8;
        this.bitOffset += n % 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
    }

    public void skipBytes(int n) {
        this.byteOffset += n;
    }

    public void readBytes(byte[] out, int offset, int length) {
        Assertions.checkState(this.bitOffset == 0);
        System.arraycopy(this.data, this.byteOffset, out, offset, length);
        this.byteOffset += length;
    }

    public int bytesLeft() {
        return this.limit - this.byteOffset;
    }

    public boolean isEmpty() {
        return this.limit == 0;
    }

    public int readUnsignedExpGolombCodedInt() {
        return this.readExpGolombCodeNum();
    }

    public int readSignedExpGolombCodedInt() {
        int codeNum = this.readExpGolombCodeNum();
        return (codeNum % 2 == 0 ? -1 : 1) * ((codeNum + 1) / 2);
    }

    private int readExpGolombCodeNum() {
        int leadingZeros = 0;
        while (!this.readBit()) {
            ++leadingZeros;
        }
        return (1 << leadingZeros) - 1 + (leadingZeros > 0 ? this.readBits(leadingZeros) : 0);
    }

    public int readSynchSafeInt() {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return b1 << 21 | b2 << 14 | b3 << 7 | b4;
    }

    public int findNextAdtsSyncWord() {
        for (int i = this.byteOffset; i < this.limit - 1; ++i) {
            int syncBits = this.getUnsignedByte(i) << 8 | this.getUnsignedByte(i + 1);
            if ((syncBits & 0xFFF0) != 65520 || syncBits == 65535) continue;
            return i - this.byteOffset;
        }
        return this.limit - this.byteOffset;
    }

    public int findNextNalUnit(int nalUnitType, int offset) {
        for (int i = this.byteOffset + offset; i < this.limit - 3; ++i) {
            if (this.data[i] != 0 || this.data[i + 1] != 0 || this.data[i + 2] != 1 || nalUnitType != -1 && nalUnitType != (this.data[i + 3] & 0x1F)) continue;
            return i - this.byteOffset;
        }
        return this.limit - this.byteOffset;
    }
}

