/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.autofill;

import android.annotation.NonNull;
import android.annotation.Size;
import android.app.slice.Slice;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.inline.InlinePresentationSpec;

import com.android.internal.util.DataClass;

import java.util.List;

/**
 * Wrapper class holding a {@link Slice} and an {@link InlinePresentationSpec} for rendering UI
 * for an Inline Suggestion.
 */
@DataClass(
        genToString = true,
        genHiddenConstDefs = true,
        genEqualsHashCode = true)
public final class InlinePresentation implements Parcelable {


    /**
     * Represents the UI content and the action for the inline suggestion.
     */
    private final @NonNull Slice mSlice;

    /**
     * Specifies the UI specification for the inline suggestion.
     */
    private final @NonNull InlinePresentationSpec mInlinePresentationSpec;

    /**
     * Indicates whether the UI should be pinned, hence non-scrollable and non-filterable, in the
     * host. However, it's eventually up to the host whether the UI is pinned or not.
     *
     * <p> Also a {@link Dataset} with a pinned inline presentation will not be replaced by the
     * new data set returned from authentication intent. See
     * {@link Dataset.Builder#setAuthentication(android.content.IntentSender)} for more information.
     */
    private final boolean mPinned;

    /**
     * Returns the autofill hints set in the slice.
     *
     * @hide
     */
    @NonNull
    @Size(min = 0)
    public String[] getAutofillHints() {
        List<String> hints = mSlice.getHints();
        return hints.toArray(new String[hints.size()]);
    }



    // Code below generated by codegen v1.0.15.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/autofill/InlinePresentation.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new InlinePresentation.
     *
     * @param slice
     *   Represents the UI content and the action for the inline suggestion.
     * @param inlinePresentationSpec
     *   Specifies the UI specification for the inline suggestion.
     * @param pinned
     *   Indicates whether the UI should be pinned, hence non-scrollable and non-filterable, in the
     *   host. However, it's eventually up to the host whether the UI is pinned or not.
     *
     *   <p> Also a {@link Dataset} with a pinned inline presentation will not be replaced by the
     *   new data set returned from authentication intent. See
     *   {@link Dataset.Builder#setAuthentication(android.content.IntentSender)} for more information.
     */
    @DataClass.Generated.Member
    public InlinePresentation(
            @NonNull Slice slice,
            @NonNull InlinePresentationSpec inlinePresentationSpec,
            boolean pinned) {
        this.mSlice = slice;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSlice);
        this.mInlinePresentationSpec = inlinePresentationSpec;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mInlinePresentationSpec);
        this.mPinned = pinned;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Represents the UI content and the action for the inline suggestion.
     */
    @DataClass.Generated.Member
    public @NonNull Slice getSlice() {
        return mSlice;
    }

    /**
     * Specifies the UI specification for the inline suggestion.
     */
    @DataClass.Generated.Member
    public @NonNull InlinePresentationSpec getInlinePresentationSpec() {
        return mInlinePresentationSpec;
    }

    /**
     * Indicates whether the UI should be pinned, hence non-scrollable and non-filterable, in the
     * host. However, it's eventually up to the host whether the UI is pinned or not.
     *
     * <p> Also a {@link Dataset} with a pinned inline presentation will not be replaced by the
     * new data set returned from authentication intent. See
     * {@link Dataset.Builder#setAuthentication(android.content.IntentSender)} for more information.
     */
    @DataClass.Generated.Member
    public boolean isPinned() {
        return mPinned;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "InlinePresentation { " +
                "slice = " + mSlice + ", " +
                "inlinePresentationSpec = " + mInlinePresentationSpec + ", " +
                "pinned = " + mPinned +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(InlinePresentation other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        InlinePresentation that = (InlinePresentation) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mSlice, that.mSlice)
                && java.util.Objects.equals(mInlinePresentationSpec, that.mInlinePresentationSpec)
                && mPinned == that.mPinned;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mSlice);
        _hash = 31 * _hash + java.util.Objects.hashCode(mInlinePresentationSpec);
        _hash = 31 * _hash + Boolean.hashCode(mPinned);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mPinned) flg |= 0x4;
        dest.writeByte(flg);
        dest.writeTypedObject(mSlice, flags);
        dest.writeTypedObject(mInlinePresentationSpec, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ InlinePresentation(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        boolean pinned = (flg & 0x4) != 0;
        Slice slice = (Slice) in.readTypedObject(Slice.CREATOR);
        InlinePresentationSpec inlinePresentationSpec = (InlinePresentationSpec) in.readTypedObject(InlinePresentationSpec.CREATOR);

        this.mSlice = slice;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mSlice);
        this.mInlinePresentationSpec = inlinePresentationSpec;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mInlinePresentationSpec);
        this.mPinned = pinned;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<InlinePresentation> CREATOR
            = new Parcelable.Creator<InlinePresentation>() {
        @Override
        public InlinePresentation[] newArray(int size) {
            return new InlinePresentation[size];
        }

        @Override
        public InlinePresentation createFromParcel(@NonNull Parcel in) {
            return new InlinePresentation(in);
        }
    };

    @DataClass.Generated(
            time = 1593131904745L,
            codegenVersion = "1.0.15",
            sourceFile = "frameworks/base/core/java/android/service/autofill/InlinePresentation.java",
            inputSignatures = "private final @android.annotation.NonNull android.app.slice.Slice mSlice\nprivate final @android.annotation.NonNull android.widget.inline.InlinePresentationSpec mInlinePresentationSpec\nprivate final  boolean mPinned\npublic @android.annotation.NonNull @android.annotation.Size(min=0L) java.lang.String[] getAutofillHints()\nclass InlinePresentation extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genToString=true, genHiddenConstDefs=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
