/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CameraDevice implements java.lang.AutoCloseable {

CameraDevice() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.lang.String getId();

@Deprecated
public abstract void createCaptureSession(@android.annotation.NonNull java.util.List<android.view.Surface> outputs, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.StateCallback callback, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

@Deprecated
public abstract void createCaptureSessionByOutputConfigurations(java.util.List<android.hardware.camera2.params.OutputConfiguration> outputConfigurations, android.hardware.camera2.CameraCaptureSession.StateCallback callback, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

@Deprecated
public abstract void createReprocessableCaptureSession(@android.annotation.NonNull android.hardware.camera2.params.InputConfiguration inputConfig, @android.annotation.NonNull java.util.List<android.view.Surface> outputs, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.StateCallback callback, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

@Deprecated
public abstract void createReprocessableCaptureSessionByConfigurations(@android.annotation.NonNull android.hardware.camera2.params.InputConfiguration inputConfig, @android.annotation.NonNull java.util.List<android.hardware.camera2.params.OutputConfiguration> outputs, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.StateCallback callback, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

@Deprecated
public abstract void createConstrainedHighSpeedCaptureSession(@android.annotation.NonNull java.util.List<android.view.Surface> outputs, @android.annotation.NonNull android.hardware.camera2.CameraCaptureSession.StateCallback callback, @android.annotation.Nullable android.os.Handler handler) throws android.hardware.camera2.CameraAccessException;

public void createCaptureSession(android.hardware.camera2.params.SessionConfiguration config) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.hardware.camera2.CaptureRequest.Builder createCaptureRequest(int templateType) throws android.hardware.camera2.CameraAccessException;

@android.annotation.NonNull
public android.hardware.camera2.CaptureRequest.Builder createCaptureRequest(int templateType, java.util.Set<java.lang.String> physicalCameraIdSet) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.hardware.camera2.CaptureRequest.Builder createReprocessCaptureRequest(@android.annotation.NonNull android.hardware.camera2.TotalCaptureResult inputResult) throws android.hardware.camera2.CameraAccessException;

public abstract void close();

public boolean isSessionConfigurationSupported(@android.annotation.NonNull android.hardware.camera2.params.SessionConfiguration sessionConfig) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public void setCameraAudioRestriction(int mode) throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public int getCameraAudioRestriction() throws android.hardware.camera2.CameraAccessException { throw new RuntimeException("Stub!"); }

public static final int AUDIO_RESTRICTION_NONE = 0; // 0x0

public static final int AUDIO_RESTRICTION_VIBRATION = 1; // 0x1

public static final int AUDIO_RESTRICTION_VIBRATION_SOUND = 3; // 0x3

public static final int TEMPLATE_MANUAL = 6; // 0x6

public static final int TEMPLATE_PREVIEW = 1; // 0x1

public static final int TEMPLATE_RECORD = 3; // 0x3

public static final int TEMPLATE_STILL_CAPTURE = 2; // 0x2

public static final int TEMPLATE_VIDEO_SNAPSHOT = 4; // 0x4

public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5; // 0x5
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class StateCallback {

public StateCallback() { throw new RuntimeException("Stub!"); }

public abstract void onOpened(@android.annotation.NonNull android.hardware.camera2.CameraDevice camera);

public void onClosed(@android.annotation.NonNull android.hardware.camera2.CameraDevice camera) { throw new RuntimeException("Stub!"); }

public abstract void onDisconnected(@android.annotation.NonNull android.hardware.camera2.CameraDevice camera);

public abstract void onError(@android.annotation.NonNull android.hardware.camera2.CameraDevice camera, int error);

public static final int ERROR_CAMERA_DEVICE = 4; // 0x4

public static final int ERROR_CAMERA_DISABLED = 3; // 0x3

public static final int ERROR_CAMERA_IN_USE = 1; // 0x1

public static final int ERROR_CAMERA_SERVICE = 5; // 0x5

public static final int ERROR_MAX_CAMERAS_IN_USE = 2; // 0x2
}

}

