/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TvTrackInfo implements android.os.Parcelable {

private TvTrackInfo() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public java.lang.String getId() { throw new RuntimeException("Stub!"); }

public java.lang.String getLanguage() { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getDescription() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getEncoding() { throw new RuntimeException("Stub!"); }

public boolean isEncrypted() { throw new RuntimeException("Stub!"); }

public int getAudioChannelCount() { throw new RuntimeException("Stub!"); }

public int getAudioSampleRate() { throw new RuntimeException("Stub!"); }

public boolean isAudioDescription() { throw new RuntimeException("Stub!"); }

public boolean isHardOfHearing() { throw new RuntimeException("Stub!"); }

public boolean isSpokenSubtitle() { throw new RuntimeException("Stub!"); }

public int getVideoWidth() { throw new RuntimeException("Stub!"); }

public int getVideoHeight() { throw new RuntimeException("Stub!"); }

public float getVideoFrameRate() { throw new RuntimeException("Stub!"); }

public float getVideoPixelAspectRatio() { throw new RuntimeException("Stub!"); }

public byte getVideoActiveFormatDescription() { throw new RuntimeException("Stub!"); }

public android.os.Bundle getExtra() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.tv.TvTrackInfo> CREATOR;
static { CREATOR = null; }

public static final int TYPE_AUDIO = 0; // 0x0

public static final int TYPE_SUBTITLE = 2; // 0x2

public static final int TYPE_VIDEO = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int type, @android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setLanguage(@android.annotation.NonNull java.lang.String language) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setDescription(@android.annotation.NonNull java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setEncoding(@android.annotation.Nullable java.lang.String encoding) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setEncrypted(boolean encrypted) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setAudioChannelCount(int audioChannelCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setAudioSampleRate(int audioSampleRate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setAudioDescription(boolean audioDescription) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setHardOfHearing(boolean hardOfHearing) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setSpokenSubtitle(boolean spokenSubtitle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setVideoWidth(int videoWidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setVideoHeight(int videoHeight) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setVideoFrameRate(float videoFrameRate) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setVideoPixelAspectRatio(float videoPixelAspectRatio) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setVideoActiveFormatDescription(byte videoActiveFormatDescription) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo.Builder setExtra(@android.annotation.NonNull android.os.Bundle extra) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.tv.TvTrackInfo build() { throw new RuntimeException("Stub!"); }
}

}

