/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.webkit;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WebView extends android.widget.AbsoluteLayout implements android.view.ViewTreeObserver.OnGlobalFocusChangeListener, android.view.ViewGroup.OnHierarchyChangeListener {

public WebView(@android.annotation.NonNull android.content.Context context) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public WebView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public WebView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs, int defStyleAttr) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

public WebView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs, int defStyleAttr, int defStyleRes) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

@Deprecated
public WebView(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.util.AttributeSet attrs, int defStyleAttr, boolean privateBrowsing) { super((android.content.Context)null); throw new RuntimeException("Stub!"); }

@Deprecated
public void setHorizontalScrollbarOverlay(boolean overlay) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setVerticalScrollbarOverlay(boolean overlay) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean overlayHorizontalScrollbar() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean overlayVerticalScrollbar() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.http.SslCertificate getCertificate() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setCertificate(android.net.http.SslCertificate certificate) { throw new RuntimeException("Stub!"); }

@Deprecated
public void savePassword(java.lang.String host, java.lang.String username, java.lang.String password) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setHttpAuthUsernamePassword(java.lang.String host, java.lang.String realm, java.lang.String username, java.lang.String password) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public java.lang.String[] getHttpAuthUsernamePassword(java.lang.String host, java.lang.String realm) { throw new RuntimeException("Stub!"); }

public void destroy() { throw new RuntimeException("Stub!"); }

public void setNetworkAvailable(boolean networkUp) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.webkit.WebBackForwardList saveState(@android.annotation.NonNull android.os.Bundle outState) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.webkit.WebBackForwardList restoreState(@android.annotation.NonNull android.os.Bundle inState) { throw new RuntimeException("Stub!"); }

public void loadUrl(@android.annotation.NonNull java.lang.String url, @android.annotation.NonNull java.util.Map<java.lang.String,java.lang.String> additionalHttpHeaders) { throw new RuntimeException("Stub!"); }

public void loadUrl(@android.annotation.NonNull java.lang.String url) { throw new RuntimeException("Stub!"); }

public void postUrl(@android.annotation.NonNull java.lang.String url, @android.annotation.NonNull byte[] postData) { throw new RuntimeException("Stub!"); }

public void loadData(@android.annotation.NonNull java.lang.String data, @android.annotation.Nullable java.lang.String mimeType, @android.annotation.Nullable java.lang.String encoding) { throw new RuntimeException("Stub!"); }

public void loadDataWithBaseURL(@android.annotation.Nullable java.lang.String baseUrl, @android.annotation.NonNull java.lang.String data, @android.annotation.Nullable java.lang.String mimeType, @android.annotation.Nullable java.lang.String encoding, @android.annotation.Nullable java.lang.String historyUrl) { throw new RuntimeException("Stub!"); }

public void evaluateJavascript(@android.annotation.NonNull java.lang.String script, @android.annotation.Nullable android.webkit.ValueCallback<java.lang.String> resultCallback) { throw new RuntimeException("Stub!"); }

public void saveWebArchive(@android.annotation.NonNull java.lang.String filename) { throw new RuntimeException("Stub!"); }

public void saveWebArchive(@android.annotation.NonNull java.lang.String basename, boolean autoname, @android.annotation.Nullable android.webkit.ValueCallback<java.lang.String> callback) { throw new RuntimeException("Stub!"); }

public void stopLoading() { throw new RuntimeException("Stub!"); }

public void reload() { throw new RuntimeException("Stub!"); }

public boolean canGoBack() { throw new RuntimeException("Stub!"); }

public void goBack() { throw new RuntimeException("Stub!"); }

public boolean canGoForward() { throw new RuntimeException("Stub!"); }

public void goForward() { throw new RuntimeException("Stub!"); }

public boolean canGoBackOrForward(int steps) { throw new RuntimeException("Stub!"); }

public void goBackOrForward(int steps) { throw new RuntimeException("Stub!"); }

public boolean isPrivateBrowsingEnabled() { throw new RuntimeException("Stub!"); }

public boolean pageUp(boolean top) { throw new RuntimeException("Stub!"); }

public boolean pageDown(boolean bottom) { throw new RuntimeException("Stub!"); }

public void postVisualStateCallback(long requestId, @android.annotation.NonNull android.webkit.WebView.VisualStateCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void clearView() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.graphics.Picture capturePicture() { throw new RuntimeException("Stub!"); }

@Deprecated
public android.print.PrintDocumentAdapter createPrintDocumentAdapter() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.print.PrintDocumentAdapter createPrintDocumentAdapter(@android.annotation.NonNull java.lang.String documentName) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.view.ViewDebug.ExportedProperty(category="webview")
public float getScale() { throw new RuntimeException("Stub!"); }

public void setInitialScale(int scaleInPercent) { throw new RuntimeException("Stub!"); }

public void invokeZoomPicker() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.webkit.WebView.HitTestResult getHitTestResult() { throw new RuntimeException("Stub!"); }

public void requestFocusNodeHref(@android.annotation.Nullable android.os.Message hrefMsg) { throw new RuntimeException("Stub!"); }

public void requestImageRef(@android.annotation.NonNull android.os.Message msg) { throw new RuntimeException("Stub!"); }

@android.view.ViewDebug.ExportedProperty(category="webview")
@android.annotation.Nullable
public java.lang.String getUrl() { throw new RuntimeException("Stub!"); }

@android.view.ViewDebug.ExportedProperty(category="webview")
@android.annotation.Nullable
public java.lang.String getOriginalUrl() { throw new RuntimeException("Stub!"); }

@android.view.ViewDebug.ExportedProperty(category="webview")
@android.annotation.Nullable
public java.lang.String getTitle() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Bitmap getFavicon() { throw new RuntimeException("Stub!"); }

public int getProgress() { throw new RuntimeException("Stub!"); }

@android.view.ViewDebug.ExportedProperty(category="webview")
public int getContentHeight() { throw new RuntimeException("Stub!"); }

public void pauseTimers() { throw new RuntimeException("Stub!"); }

public void resumeTimers() { throw new RuntimeException("Stub!"); }

public void onPause() { throw new RuntimeException("Stub!"); }

public void onResume() { throw new RuntimeException("Stub!"); }

@Deprecated
public void freeMemory() { throw new RuntimeException("Stub!"); }

public void clearCache(boolean includeDiskFiles) { throw new RuntimeException("Stub!"); }

public void clearFormData() { throw new RuntimeException("Stub!"); }

public void clearHistory() { throw new RuntimeException("Stub!"); }

public void clearSslPreferences() { throw new RuntimeException("Stub!"); }

public static void clearClientCertPreferences(@android.annotation.Nullable java.lang.Runnable onCleared) { throw new RuntimeException("Stub!"); }

public static void startSafeBrowsing(@android.annotation.NonNull android.content.Context context, @android.annotation.Nullable android.webkit.ValueCallback<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

public static void setSafeBrowsingWhitelist(@android.annotation.NonNull java.util.List<java.lang.String> hosts, @android.annotation.Nullable android.webkit.ValueCallback<java.lang.Boolean> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.Uri getSafeBrowsingPrivacyPolicyUrl() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.webkit.WebBackForwardList copyBackForwardList() { throw new RuntimeException("Stub!"); }

public void setFindListener(@android.annotation.Nullable android.webkit.WebView.FindListener listener) { throw new RuntimeException("Stub!"); }

public void findNext(boolean forward) { throw new RuntimeException("Stub!"); }

@Deprecated
public int findAll(java.lang.String find) { throw new RuntimeException("Stub!"); }

public void findAllAsync(@android.annotation.NonNull java.lang.String find) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean showFindDialog(@android.annotation.Nullable java.lang.String text, boolean showIme) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public static java.lang.String findAddress(java.lang.String addr) { throw new RuntimeException("Stub!"); }

public static void enableSlowWholeDocumentDraw() { throw new RuntimeException("Stub!"); }

public void clearMatches() { throw new RuntimeException("Stub!"); }

public void documentHasImages(@android.annotation.NonNull android.os.Message response) { throw new RuntimeException("Stub!"); }

public void setWebViewClient(@android.annotation.NonNull android.webkit.WebViewClient client) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.webkit.WebViewClient getWebViewClient() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.webkit.WebViewRenderProcess getWebViewRenderProcess() { throw new RuntimeException("Stub!"); }

public void setWebViewRenderProcessClient(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.webkit.WebViewRenderProcessClient webViewRenderProcessClient) { throw new RuntimeException("Stub!"); }

public void setWebViewRenderProcessClient(@android.annotation.Nullable android.webkit.WebViewRenderProcessClient webViewRenderProcessClient) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.webkit.WebViewRenderProcessClient getWebViewRenderProcessClient() { throw new RuntimeException("Stub!"); }

public void setDownloadListener(@android.annotation.Nullable android.webkit.DownloadListener listener) { throw new RuntimeException("Stub!"); }

public void setWebChromeClient(@android.annotation.Nullable android.webkit.WebChromeClient client) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.webkit.WebChromeClient getWebChromeClient() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPictureListener(android.webkit.WebView.PictureListener listener) { throw new RuntimeException("Stub!"); }

public void addJavascriptInterface(@android.annotation.NonNull java.lang.Object object, @android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

public void removeJavascriptInterface(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.webkit.WebMessagePort[] createWebMessageChannel() { throw new RuntimeException("Stub!"); }

public void postWebMessage(@android.annotation.NonNull android.webkit.WebMessage message, @android.annotation.NonNull android.net.Uri targetOrigin) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.webkit.WebSettings getSettings() { throw new RuntimeException("Stub!"); }

public static void setWebContentsDebuggingEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public static void setDataDirectorySuffix(@android.annotation.NonNull java.lang.String suffix) { throw new RuntimeException("Stub!"); }

public static void disableWebView() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onChildViewAdded(android.view.View parent, android.view.View child) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onChildViewRemoved(android.view.View p, android.view.View child) { throw new RuntimeException("Stub!"); }

@Deprecated
public void onGlobalFocusChanged(android.view.View oldFocus, android.view.View newFocus) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setMapTrackballToArrowKeys(boolean setMap) { throw new RuntimeException("Stub!"); }

public void flingScroll(int vx, int vy) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean canZoomIn() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean canZoomOut() { throw new RuntimeException("Stub!"); }

public void zoomBy(float zoomFactor) { throw new RuntimeException("Stub!"); }

public boolean zoomIn() { throw new RuntimeException("Stub!"); }

public boolean zoomOut() { throw new RuntimeException("Stub!"); }

public void setRendererPriorityPolicy(int rendererRequestedPriority, boolean waivedWhenNotVisible) { throw new RuntimeException("Stub!"); }

public int getRendererRequestedPriority() { throw new RuntimeException("Stub!"); }

public boolean getRendererPriorityWaivedWhenNotVisible() { throw new RuntimeException("Stub!"); }

public void setTextClassifier(@android.annotation.Nullable android.view.textclassifier.TextClassifier textClassifier) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifier getTextClassifier() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.ClassLoader getWebViewClassLoader() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Looper getWebViewLooper() { throw new RuntimeException("Stub!"); }

protected void onAttachedToWindow() { throw new RuntimeException("Stub!"); }

public void setLayoutParams(android.view.ViewGroup.LayoutParams params) { throw new RuntimeException("Stub!"); }

public void setOverScrollMode(int mode) { throw new RuntimeException("Stub!"); }

public void setScrollBarStyle(int style) { throw new RuntimeException("Stub!"); }

protected int computeHorizontalScrollRange() { throw new RuntimeException("Stub!"); }

protected int computeHorizontalScrollOffset() { throw new RuntimeException("Stub!"); }

protected int computeVerticalScrollRange() { throw new RuntimeException("Stub!"); }

protected int computeVerticalScrollOffset() { throw new RuntimeException("Stub!"); }

protected int computeVerticalScrollExtent() { throw new RuntimeException("Stub!"); }

public void computeScroll() { throw new RuntimeException("Stub!"); }

public boolean onHoverEvent(android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onTouchEvent(android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onGenericMotionEvent(android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onTrackballEvent(android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyDown(int keyCode, android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyUp(int keyCode, android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyMultiple(int keyCode, int repeatCount, android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public android.view.accessibility.AccessibilityNodeProvider getAccessibilityNodeProvider() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean shouldDelayChildPressedState() { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getAccessibilityClassName() { throw new RuntimeException("Stub!"); }

public void onProvideVirtualStructure(android.view.ViewStructure structure) { throw new RuntimeException("Stub!"); }

public void onProvideAutofillVirtualStructure(android.view.ViewStructure structure, int flags) { throw new RuntimeException("Stub!"); }

public void onProvideContentCaptureStructure(@android.annotation.NonNull android.view.ViewStructure structure, int flags) { throw new RuntimeException("Stub!"); }

public void autofill(android.util.SparseArray<android.view.autofill.AutofillValue> values) { throw new RuntimeException("Stub!"); }

public boolean isVisibleToUserForAutofill(int virtualId) { throw new RuntimeException("Stub!"); }

protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) { throw new RuntimeException("Stub!"); }

protected void onWindowVisibilityChanged(int visibility) { throw new RuntimeException("Stub!"); }

protected void onDraw(android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public boolean performLongClick() { throw new RuntimeException("Stub!"); }

protected void onConfigurationChanged(android.content.res.Configuration newConfig) { throw new RuntimeException("Stub!"); }

public android.view.inputmethod.InputConnection onCreateInputConnection(android.view.inputmethod.EditorInfo outAttrs) { throw new RuntimeException("Stub!"); }

public boolean onDragEvent(android.view.DragEvent event) { throw new RuntimeException("Stub!"); }

protected void onVisibilityChanged(android.view.View changedView, int visibility) { throw new RuntimeException("Stub!"); }

public void onWindowFocusChanged(boolean hasWindowFocus) { throw new RuntimeException("Stub!"); }

protected void onFocusChanged(boolean focused, int direction, android.graphics.Rect previouslyFocusedRect) { throw new RuntimeException("Stub!"); }

protected void onSizeChanged(int w, int h, int ow, int oh) { throw new RuntimeException("Stub!"); }

protected void onScrollChanged(int l, int t, int oldl, int oldt) { throw new RuntimeException("Stub!"); }

public boolean dispatchKeyEvent(android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean requestFocus(int direction, android.graphics.Rect previouslyFocusedRect) { throw new RuntimeException("Stub!"); }

protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) { throw new RuntimeException("Stub!"); }

public boolean requestChildRectangleOnScreen(android.view.View child, android.graphics.Rect rect, boolean immediate) { throw new RuntimeException("Stub!"); }

public void setBackgroundColor(int color) { throw new RuntimeException("Stub!"); }

public void setLayerType(int layerType, android.graphics.Paint paint) { throw new RuntimeException("Stub!"); }

protected void dispatchDraw(android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public void onStartTemporaryDetach() { throw new RuntimeException("Stub!"); }

public void onFinishTemporaryDetach() { throw new RuntimeException("Stub!"); }

public android.os.Handler getHandler() { throw new RuntimeException("Stub!"); }

public android.view.View findFocus() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.content.pm.PackageInfo getCurrentWebViewPackage() { throw new RuntimeException("Stub!"); }

public boolean onCheckIsTextEditor() { throw new RuntimeException("Stub!"); }

public static final int RENDERER_PRIORITY_BOUND = 1; // 0x1

public static final int RENDERER_PRIORITY_IMPORTANT = 2; // 0x2

public static final int RENDERER_PRIORITY_WAIVED = 0; // 0x0

public static final java.lang.String SCHEME_GEO = "geo:0,0?q=";

public static final java.lang.String SCHEME_MAILTO = "mailto:";

public static final java.lang.String SCHEME_TEL = "tel:";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface FindListener {

public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class HitTestResult {

HitTestResult() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getExtra() { throw new RuntimeException("Stub!"); }

@Deprecated public static final int ANCHOR_TYPE = 1; // 0x1

public static final int EDIT_TEXT_TYPE = 9; // 0x9

public static final int EMAIL_TYPE = 4; // 0x4

public static final int GEO_TYPE = 3; // 0x3

@Deprecated public static final int IMAGE_ANCHOR_TYPE = 6; // 0x6

public static final int IMAGE_TYPE = 5; // 0x5

public static final int PHONE_TYPE = 2; // 0x2

public static final int SRC_ANCHOR_TYPE = 7; // 0x7

public static final int SRC_IMAGE_ANCHOR_TYPE = 8; // 0x8

public static final int UNKNOWN_TYPE = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface PictureListener {

@Deprecated
public void onNewPicture(android.webkit.WebView view, @android.annotation.Nullable android.graphics.Picture picture);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class VisualStateCallback {

public VisualStateCallback() { throw new RuntimeException("Stub!"); }

public abstract void onComplete(long requestId);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WebViewTransport {

public WebViewTransport() { throw new RuntimeException("Stub!"); }

public synchronized void setWebView(@android.annotation.Nullable android.webkit.WebView webview) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public synchronized android.webkit.WebView getWebView() { throw new RuntimeException("Stub!"); }
}

}

