/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;


/**
 * Defines a request for a network, made through {@link android.net.NetworkRequest.Builder NetworkRequest.Builder} and used
 * to request a network via {@link android.net.ConnectivityManager#requestNetwork ConnectivityManager#requestNetwork} or listen for changes
 * via {@link android.net.ConnectivityManager#registerNetworkCallback ConnectivityManager#registerNetworkCallback}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class NetworkRequest implements android.os.Parcelable {

NetworkRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#addCapability(int)
 */

public boolean hasCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if and only if the capabilities requested in this NetworkRequest are satisfied
 * by the provided {@link android.net.NetworkCapabilities NetworkCapabilities}.
 *
 * @param nc Capabilities that should satisfy this NetworkRequest. null capabilities do not
 *           satisfy any request.
 */

public boolean canBeSatisfiedBy(@android.annotation.Nullable android.net.NetworkCapabilities nc) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#addTransportType(int)
 */

public boolean hasTransport(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#setNetworkSpecifier(NetworkSpecifier)
 */

@android.annotation.Nullable
public android.net.NetworkSpecifier getNetworkSpecifier() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Gets all the capabilities set on this {@code NetworkRequest} instance.
 *
 * @return an array of capability values for this instance.
 */

@android.annotation.NonNull
public int[] getCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Gets all the transports set on this {@code NetworkRequest} instance.
 *
 * @return an array of transport type values for this instance.
 */

@android.annotation.NonNull
public int[] getTransportTypes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.NetworkRequest> CREATOR;
static { CREATOR = null; }
/**
 * Builder used to create {@link android.net.NetworkRequest NetworkRequest} objects.  Specify the Network features
 * needed in terms of {@link android.net.NetworkCapabilities NetworkCapabilities} features
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

/**
 * Default constructor for Builder.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new Builder of NetworkRequest from an existing instance.
 */

public Builder(@android.annotation.NonNull android.net.NetworkRequest request) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.NetworkRequest NetworkRequest} give the current set of capabilities.
 */

public android.net.NetworkRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Add the given capability requirement to this builder.  These represent
 * the requested network's required capabilities.  Note that when searching
 * for a network to satisfy a request, all capabilities requested must be
 * satisfied.
 *
 * @param capability The capability to add.
 * @return The builder to facilitate chaining
 *         {@code builder.addCapability(...).addCapability();}.
 */

public android.net.NetworkRequest.Builder addCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Removes (if found) the given capability from this builder instance.
 *
 * @param capability The capability to remove.
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder removeCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Completely clears all the {@code NetworkCapabilities} from this builder instance,
 * removing even the capabilities that are set by default when the object is constructed.
 *
 * @return The builder to facilitate chaining.
 */

@android.annotation.NonNull
public android.net.NetworkRequest.Builder clearCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Adds the given transport requirement to this builder.  These represent
 * the set of allowed transports for the request.  Only networks using one
 * of these transports will satisfy the request.  If no particular transports
 * are required, none should be specified here.
 *
 * @param transportType The transport type to add.
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder addTransportType(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * Removes (if found) the given transport from this builder instance.
 *
 * @param transportType The transport type to remove.
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder removeTransportType(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional bearer specific network specifier.
 * This has no meaning if a single transport is also not specified, so calling
 * this without a single transport set will generate an exception, as will
 * subsequently adding or removing transports after this is set.
 * </p>
 * If the {@code networkSpecifier} is provided, it shall be interpreted as follows:
 * <ul>
 * <li>If the specifier can be parsed as an integer, it will be treated as a
 * {@link android.net TelephonyNetworkSpecifier}, and the provided integer will be
 * interpreted as a SubscriptionId.
 * <li>If the value is an ethernet interface name, it will be treated as such.
 * <li>For all other cases, the behavior is undefined.
 * </ul>
 *
 * @param networkSpecifier A {@code String} of either a SubscriptionId in cellular
 *                         network request or an ethernet interface name in ethernet
 *                         network request.
 *
 * @deprecated Use {@link #setNetworkSpecifier(android.net.NetworkSpecifier)} instead.
 */

@Deprecated
public android.net.NetworkRequest.Builder setNetworkSpecifier(java.lang.String networkSpecifier) { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional bearer specific network specifier.
 * This has no meaning if a single transport is also not specified, so calling
 * this without a single transport set will generate an exception, as will
 * subsequently adding or removing transports after this is set.
 * </p>
 *
 * @param networkSpecifier A concrete, parcelable framework class that extends
 *                         NetworkSpecifier.
 */

public android.net.NetworkRequest.Builder setNetworkSpecifier(android.net.NetworkSpecifier networkSpecifier) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the built request should also match networks that do not apply to the
 * calling UID.
 *
 * By default, the built request will only match networks that apply to the calling UID.
 * If this method is called with {@code true}, the built request will match any network on
 * the system that matches the other parameters of the request. In this case, any
 * information in the built request that is subject to redaction for security or privacy
 * purposes, such as a {@link android.net.NetworkSpecifier NetworkSpecifier}, will be redacted or removed to prevent the
 * application deducing sensitive information.
 *
 * @param include Whether to match networks that do not apply to the calling UID.
 * @return The builder to facilitate chaining.
 */

@android.annotation.NonNull
public android.net.NetworkRequest.Builder setIncludeOtherUidNetworks(boolean include) { throw new RuntimeException("Stub!"); }
}

}

