/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.os.Build;
import android.support.v4.widget.ScrollerCompatGingerbread;
import android.support.v4.widget.ScrollerCompatIcs;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class ScrollerCompat {
    private static final String TAG = "ScrollerCompat";
    Object mScroller;
    ScrollerCompatImpl mImpl;
    static final int CHASE_FRAME_TIME = 16;

    public static ScrollerCompat create(Context context) {
        return ScrollerCompat.create(context, null);
    }

    public static ScrollerCompat create(Context context, Interpolator interpolator) {
        return new ScrollerCompat(context, interpolator);
    }

    ScrollerCompat(Context context, Interpolator interpolator) {
        int version = Build.VERSION.SDK_INT;
        this.mImpl = version >= 14 ? new ScrollerCompatImplIcs() : (version >= 9 ? new ScrollerCompatImplGingerbread() : new ScrollerCompatImplBase());
        this.mScroller = this.mImpl.createScroller(context, interpolator);
    }

    public boolean isFinished() {
        return this.mImpl.isFinished(this.mScroller);
    }

    public int getCurrX() {
        return this.mImpl.getCurrX(this.mScroller);
    }

    public int getCurrY() {
        return this.mImpl.getCurrY(this.mScroller);
    }

    public int getFinalX() {
        return this.mImpl.getFinalX(this.mScroller);
    }

    public int getFinalY() {
        return this.mImpl.getFinalY(this.mScroller);
    }

    public float getCurrVelocity() {
        return this.mImpl.getCurrVelocity(this.mScroller);
    }

    public boolean computeScrollOffset() {
        return this.mImpl.computeScrollOffset(this.mScroller);
    }

    public void startScroll(int startX, int startY, int dx, int dy) {
        this.mImpl.startScroll(this.mScroller, startX, startY, dx, dy);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mImpl.startScroll(this.mScroller, startX, startY, dx, dy, duration);
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.mImpl.fling(this.mScroller, startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
        this.mImpl.fling(this.mScroller, startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, overX, overY);
    }

    public void abortAnimation() {
        this.mImpl.abortAnimation(this.mScroller);
    }

    public void notifyHorizontalEdgeReached(int startX, int finalX, int overX) {
        this.mImpl.notifyHorizontalEdgeReached(this.mScroller, startX, finalX, overX);
    }

    public void notifyVerticalEdgeReached(int startY, int finalY, int overY) {
        this.mImpl.notifyVerticalEdgeReached(this.mScroller, startY, finalY, overY);
    }

    public boolean isOverScrolled() {
        return this.mImpl.isOverScrolled(this.mScroller);
    }

    static class ScrollerCompatImplIcs
    extends ScrollerCompatImplGingerbread {
        ScrollerCompatImplIcs() {
        }

        public float getCurrVelocity(Object scroller) {
            return ScrollerCompatIcs.getCurrVelocity(scroller);
        }
    }

    static class ScrollerCompatImplGingerbread
    implements ScrollerCompatImpl {
        private Chaser mChaser = this.createChaser();

        public Object createScroller(Context context, Interpolator interpolator) {
            return ScrollerCompatGingerbread.createScroller(context, interpolator);
        }

        protected Chaser createChaser() {
            return new Chaser();
        }

        public boolean isFinished(Object scroller) {
            return (!this.isSmoothingEnabled() || this.mChaser.isFinished()) && ScrollerCompatGingerbread.isFinished(scroller);
        }

        public int getCurrX(Object scroller) {
            if (this.isSmoothingEnabled()) {
                return this.mChaser.getCurrX();
            }
            return ScrollerCompatGingerbread.getCurrX(scroller);
        }

        public int getCurrY(Object scroller) {
            if (this.isSmoothingEnabled()) {
                return this.mChaser.getCurrY();
            }
            return ScrollerCompatGingerbread.getCurrY(scroller);
        }

        public float getCurrVelocity(Object scroller) {
            return 0.0f;
        }

        public boolean computeScrollOffset(Object scroller) {
            boolean result = ScrollerCompatGingerbread.computeScrollOffset(scroller);
            if (this.isSmoothingEnabled()) {
                this.mChaser.setTarget(ScrollerCompatGingerbread.getCurrX(scroller), ScrollerCompatGingerbread.getCurrY(scroller));
                if (!this.mChaser.isFinished()) {
                    return this.mChaser.computeScrollOffset() || result;
                }
            }
            return result;
        }

        private boolean isSmoothingEnabled() {
            return this.mChaser != null && this.mChaser.isSmoothingEnabled();
        }

        public void startScroll(Object scroller, int startX, int startY, int dx, int dy) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ScrollerCompatGingerbread.startScroll(scroller, startX, startY, dx, dy);
        }

        public void startScroll(Object scroller, int startX, int startY, int dx, int dy, int duration) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ScrollerCompatGingerbread.startScroll(scroller, startX, startY, dx, dy, duration);
        }

        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ScrollerCompatGingerbread.fling(scroller, startX, startY, velX, velY, minX, maxX, minY, maxY);
        }

        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ScrollerCompatGingerbread.fling(scroller, startX, startY, velX, velY, minX, maxX, minY, maxY, overX, overY);
        }

        public void abortAnimation(Object scroller) {
            if (this.mChaser != null) {
                this.mChaser.abort();
            }
            ScrollerCompatGingerbread.abortAnimation(scroller);
        }

        public void notifyHorizontalEdgeReached(Object scroller, int startX, int finalX, int overX) {
            ScrollerCompatGingerbread.notifyHorizontalEdgeReached(scroller, startX, finalX, overX);
        }

        public void notifyVerticalEdgeReached(Object scroller, int startY, int finalY, int overY) {
            ScrollerCompatGingerbread.notifyVerticalEdgeReached(scroller, startY, finalY, overY);
        }

        public boolean isOverScrolled(Object scroller) {
            return ScrollerCompatGingerbread.isOverScrolled(scroller);
        }

        public int getFinalX(Object scroller) {
            return ScrollerCompatGingerbread.getFinalX(scroller);
        }

        public int getFinalY(Object scroller) {
            return ScrollerCompatGingerbread.getFinalY(scroller);
        }
    }

    static class ScrollerCompatImplBase
    implements ScrollerCompatImpl {
        private Chaser mChaser = this.createChaser();

        protected Chaser createChaser() {
            return new Chaser();
        }

        public Object createScroller(Context context, Interpolator interpolator) {
            return interpolator != null ? new Scroller(context, interpolator) : new Scroller(context);
        }

        public boolean isFinished(Object scroller) {
            return (!this.isSmoothingEnabled() || this.mChaser.isFinished()) && ((Scroller)scroller).isFinished();
        }

        public int getCurrX(Object scroller) {
            if (this.isSmoothingEnabled()) {
                return this.mChaser.getCurrX();
            }
            return ((Scroller)scroller).getCurrX();
        }

        public int getCurrY(Object scroller) {
            if (this.isSmoothingEnabled()) {
                return this.mChaser.getCurrY();
            }
            return ((Scroller)scroller).getCurrY();
        }

        public float getCurrVelocity(Object scroller) {
            return 0.0f;
        }

        public boolean computeScrollOffset(Object scroller) {
            Scroller s = (Scroller)scroller;
            boolean result = s.computeScrollOffset();
            if (this.isSmoothingEnabled()) {
                this.mChaser.setTarget(s.getCurrX(), s.getCurrY());
                if (this.isSmoothingEnabled() && !this.mChaser.isFinished()) {
                    return this.mChaser.computeScrollOffset() || result;
                }
            }
            return result;
        }

        private boolean isSmoothingEnabled() {
            return this.mChaser != null && this.mChaser.isSmoothingEnabled();
        }

        public void startScroll(Object scroller, int startX, int startY, int dx, int dy) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ((Scroller)scroller).startScroll(startX, startY, dx, dy);
        }

        public void startScroll(Object scroller, int startX, int startY, int dx, int dy, int duration) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ((Scroller)scroller).startScroll(startX, startY, dx, dy, duration);
        }

        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ((Scroller)scroller).fling(startX, startY, velX, velY, minX, maxX, minY, maxY);
        }

        public void fling(Object scroller, int startX, int startY, int velX, int velY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
            if (this.isSmoothingEnabled()) {
                this.mChaser.abort();
                this.mChaser.setCurrentPosition(startX, startY);
            }
            ((Scroller)scroller).fling(startX, startY, velX, velY, minX, maxX, minY, maxY);
        }

        public void abortAnimation(Object scroller) {
            if (this.mChaser != null) {
                this.mChaser.abort();
            }
            ((Scroller)scroller).abortAnimation();
        }

        public void notifyHorizontalEdgeReached(Object scroller, int startX, int finalX, int overX) {
        }

        public void notifyVerticalEdgeReached(Object scroller, int startY, int finalY, int overY) {
        }

        public boolean isOverScrolled(Object scroller) {
            return false;
        }

        public int getFinalX(Object scroller) {
            return ((Scroller)scroller).getFinalX();
        }

        public int getFinalY(Object scroller) {
            return ((Scroller)scroller).getFinalY();
        }
    }

    static class Chaser {
        private int mX;
        private int mY;
        private int mTargetX;
        private int mTargetY;
        private float mTranslateSmoothing = 2.0f;
        private long mLastTime;

        Chaser() {
        }

        public String toString() {
            return "{x=" + this.mX + " y=" + this.mY + " targetX=" + this.mTargetX + " targetY=" + this.mTargetY + " smoothing=" + this.mTranslateSmoothing + " lastTime=" + this.mLastTime + "}";
        }

        public int getCurrX() {
            return this.mX;
        }

        public int getCurrY() {
            return this.mY;
        }

        public int getFinalX() {
            return this.mTargetX;
        }

        public int getFinalY() {
            return this.mTargetY;
        }

        public void setCurrentPosition(int x, int y) {
            this.mX = x;
            this.mY = y;
        }

        public void setSmoothing(float smoothing) {
            if (smoothing < 0.0f) {
                throw new IllegalArgumentException("smoothing value must be positive");
            }
            this.mTranslateSmoothing = smoothing;
        }

        public boolean isSmoothingEnabled() {
            return this.mTranslateSmoothing > 0.0f;
        }

        public void setTarget(int targetX, int targetY) {
            this.mTargetX = targetX;
            this.mTargetY = targetY;
        }

        public void abort() {
            this.mX = this.mTargetX;
            this.mY = this.mTargetY;
            this.mLastTime = AnimationUtils.currentAnimationTimeMillis();
        }

        public boolean isFinished() {
            return this.mX == this.mTargetX && this.mY == this.mTargetY;
        }

        public boolean computeScrollOffset() {
            if (this.isSmoothingEnabled() && !this.isFinished()) {
                long now = AnimationUtils.currentAnimationTimeMillis();
                long dt = now - this.mLastTime;
                float framesElapsed = (float)dt / 16.0f;
                if (framesElapsed > 0.0f) {
                    int i = 0;
                    while ((float)i < framesElapsed) {
                        int totalDx = this.mTargetX - this.mX;
                        int totalDy = this.mTargetY - this.mY;
                        int dx = (int)((float)totalDx / this.mTranslateSmoothing);
                        int dy = (int)((float)totalDy / this.mTranslateSmoothing);
                        this.mX += dx;
                        this.mY += dy;
                        if (this.mX != this.mTargetX && dx == 0) {
                            this.mX = this.mTargetX;
                        }
                        if (this.mY != this.mTargetY && dy == 0) {
                            this.mY = this.mTargetY;
                        }
                        ++i;
                    }
                    this.mLastTime = now;
                }
                return true;
            }
            return false;
        }
    }

    static interface ScrollerCompatImpl {
        public Object createScroller(Context var1, Interpolator var2);

        public boolean isFinished(Object var1);

        public int getCurrX(Object var1);

        public int getCurrY(Object var1);

        public float getCurrVelocity(Object var1);

        public boolean computeScrollOffset(Object var1);

        public void startScroll(Object var1, int var2, int var3, int var4, int var5);

        public void startScroll(Object var1, int var2, int var3, int var4, int var5, int var6);

        public void fling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void fling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

        public void abortAnimation(Object var1);

        public void notifyHorizontalEdgeReached(Object var1, int var2, int var3, int var4);

        public void notifyVerticalEdgeReached(Object var1, int var2, int var3, int var4);

        public boolean isOverScrolled(Object var1);

        public int getFinalX(Object var1);

        public int getFinalY(Object var1);
    }
}

