/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;

public final class RangedUri {
    public final long start;
    public final long length;
    private final Uri baseUri;
    private final String stringUri;
    private int hashCode;

    public RangedUri(Uri baseUri, String stringUri, long start, long length) {
        Assertions.checkArgument(baseUri != null || stringUri != null);
        this.baseUri = baseUri;
        this.stringUri = stringUri;
        this.start = start;
        this.length = length;
    }

    public Uri getUri() {
        return Util.getMergedUri(this.baseUri, this.stringUri);
    }

    public RangedUri attemptMerge(RangedUri other) {
        if (other == null || !this.getUri().equals((Object)other.getUri())) {
            return null;
        }
        if (this.length != -1L && this.start + this.length == other.start) {
            return new RangedUri(this.baseUri, this.stringUri, this.start, other.length == -1L ? -1L : this.length + other.length);
        }
        if (other.length != -1L && other.start + other.length == this.start) {
            return new RangedUri(this.baseUri, this.stringUri, other.start, this.length == -1L ? -1L : other.length + this.length);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (int)this.start;
            result = 31 * result + (int)this.length;
            this.hashCode = result = 31 * result + this.getUri().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangedUri other = (RangedUri)obj;
        return this.start == other.start && this.length == other.length && this.getUri().equals((Object)other.getUri());
    }
}

