/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.util.Assertions;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class SubtitleParserHelper
implements Handler.Callback {
    private final SubtitleParser parser;
    private final Handler handler;
    private SampleHolder sampleHolder;
    private boolean parsing;
    private Subtitle result;
    private IOException error;

    public SubtitleParserHelper(Looper looper, SubtitleParser parser) {
        this.handler = new Handler(looper, (Handler.Callback)this);
        this.parser = parser;
        this.flush();
    }

    public synchronized void flush() {
        this.sampleHolder = new SampleHolder(1);
        this.parsing = false;
        this.result = null;
        this.error = null;
    }

    public synchronized boolean isParsing() {
        return this.parsing;
    }

    public synchronized SampleHolder getSampleHolder() {
        return this.sampleHolder;
    }

    public synchronized void startParseOperation() {
        Assertions.checkState(!this.parsing);
        this.parsing = true;
        this.result = null;
        this.error = null;
        this.handler.obtainMessage(0, (Object)this.sampleHolder).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Subtitle getAndClearResult() throws IOException {
        try {
            if (this.error != null) {
                throw this.error;
            }
            Subtitle subtitle = this.result;
            return subtitle;
        }
        finally {
            this.error = null;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        IOException error;
        Subtitle result;
        SampleHolder holder = (SampleHolder)msg.obj;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.data.array(), 0, holder.size);
            result = this.parser.parse(inputStream, null, this.sampleHolder.timeUs);
            error = null;
        }
        catch (IOException e) {
            result = null;
            error = e;
        }
        SubtitleParserHelper subtitleParserHelper = this;
        synchronized (subtitleParserHelper) {
            if (this.sampleHolder == holder) {
                holder.data.position(0);
                this.result = result;
                this.error = error;
                this.parsing = false;
            }
        }
        return true;
    }
}

