/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.view.Choreographer;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;

@TargetApi(value=16)
public class SmoothFrameReleaseTimeHelper
implements MediaCodecVideoTrackRenderer.FrameReleaseTimeHelper,
Choreographer.FrameCallback {
    private static final long CHOREOGRAPHER_SAMPLE_DELAY_MILLIS = 500L;
    private static final long MAX_ALLOWED_DRIFT_NS = 20000000L;
    private static final long VSYNC_OFFSET_PERCENTAGE = 80L;
    private static final int MIN_FRAMES_FOR_ADJUSTMENT = 6;
    private final boolean usePrimaryDisplayVsync;
    private final long vsyncDurationNs;
    private final long vsyncOffsetNs;
    private Choreographer choreographer;
    private long sampledVsyncTimeNs;
    private long lastUnadjustedFrameTimeUs;
    private long adjustedLastFrameTimeNs;
    private long pendingAdjustedFrameTimeNs;
    private boolean haveSync;
    private long syncReleaseTimeNs;
    private long syncFrameTimeNs;
    private int frameCount;

    public SmoothFrameReleaseTimeHelper(float primaryDisplayRefreshRate, boolean usePrimaryDisplayVsync) {
        this.usePrimaryDisplayVsync = usePrimaryDisplayVsync;
        if (usePrimaryDisplayVsync) {
            this.vsyncDurationNs = (long)(1.0E9 / (double)primaryDisplayRefreshRate);
            this.vsyncOffsetNs = this.vsyncDurationNs * 80L / 100L;
        } else {
            this.vsyncDurationNs = -1L;
            this.vsyncOffsetNs = -1L;
        }
    }

    @Override
    public void enable() {
        this.haveSync = false;
        if (this.usePrimaryDisplayVsync) {
            this.sampledVsyncTimeNs = 0L;
            this.choreographer = Choreographer.getInstance();
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    @Override
    public void disable() {
        if (this.usePrimaryDisplayVsync) {
            this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            this.choreographer = null;
        }
    }

    public void doFrame(long vsyncTimeNs) {
        this.sampledVsyncTimeNs = vsyncTimeNs;
        this.choreographer.postFrameCallbackDelayed((Choreographer.FrameCallback)this, 500L);
    }

    @Override
    public long adjustReleaseTime(long unadjustedFrameTimeUs, long unadjustedReleaseTimeNs) {
        long unadjustedFrameTimeNs;
        long adjustedFrameTimeNs = unadjustedFrameTimeNs = unadjustedFrameTimeUs * 1000L;
        long adjustedReleaseTimeNs = unadjustedReleaseTimeNs;
        if (this.haveSync) {
            if (unadjustedFrameTimeUs != this.lastUnadjustedFrameTimeUs) {
                ++this.frameCount;
                this.adjustedLastFrameTimeNs = this.pendingAdjustedFrameTimeNs;
            }
            if (this.frameCount >= 6) {
                long averageFrameTimeNs = (unadjustedFrameTimeNs - this.syncFrameTimeNs) / (long)this.frameCount;
                long candidateAdjustedFrameTimeNs = this.adjustedLastFrameTimeNs + averageFrameTimeNs;
                if (this.isDriftTooLarge(candidateAdjustedFrameTimeNs, unadjustedReleaseTimeNs)) {
                    this.haveSync = false;
                } else {
                    adjustedFrameTimeNs = candidateAdjustedFrameTimeNs;
                    adjustedReleaseTimeNs = this.syncReleaseTimeNs + adjustedFrameTimeNs - this.syncFrameTimeNs;
                }
            } else if (this.isDriftTooLarge(unadjustedFrameTimeNs, unadjustedReleaseTimeNs)) {
                this.haveSync = false;
            }
        }
        if (!this.haveSync) {
            this.syncFrameTimeNs = unadjustedFrameTimeNs;
            this.syncReleaseTimeNs = unadjustedReleaseTimeNs;
            this.frameCount = 0;
            this.haveSync = true;
            this.onSynced();
        }
        this.lastUnadjustedFrameTimeUs = unadjustedFrameTimeUs;
        this.pendingAdjustedFrameTimeNs = adjustedFrameTimeNs;
        if (this.sampledVsyncTimeNs == 0L) {
            return adjustedReleaseTimeNs;
        }
        long snappedTimeNs = SmoothFrameReleaseTimeHelper.closestVsync(adjustedReleaseTimeNs, this.sampledVsyncTimeNs, this.vsyncDurationNs);
        return snappedTimeNs - this.vsyncOffsetNs;
    }

    protected void onSynced() {
    }

    private boolean isDriftTooLarge(long frameTimeNs, long releaseTimeNs) {
        long elapsedReleaseTimeNs = releaseTimeNs - this.syncReleaseTimeNs;
        long elapsedFrameTimeNs = frameTimeNs - this.syncFrameTimeNs;
        return Math.abs(elapsedReleaseTimeNs - elapsedFrameTimeNs) > 20000000L;
    }

    private static long closestVsync(long releaseTime, long sampledVsyncTime, long vsyncDuration) {
        long snappedAfterNs;
        long snappedBeforeNs;
        long vsyncCount = (releaseTime - sampledVsyncTime) / vsyncDuration;
        long snappedTimeNs = sampledVsyncTime + vsyncDuration * vsyncCount;
        if (releaseTime <= snappedTimeNs) {
            snappedBeforeNs = snappedTimeNs - vsyncDuration;
            snappedAfterNs = snappedTimeNs;
        } else {
            snappedBeforeNs = snappedTimeNs;
            snappedAfterNs = snappedTimeNs + vsyncDuration;
        }
        long snappedAfterDiff = snappedAfterNs - releaseTime;
        long snappedBeforeDiff = releaseTime - snappedBeforeNs;
        return snappedAfterDiff < snappedBeforeDiff ? snappedAfterNs : snappedBeforeNs;
    }
}

