/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import java.io.IOException;
import java.util.List;

public class SingleSampleChunkSource
implements ChunkSource {
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private final Format format;
    private final long durationUs;
    private final MediaFormat mediaFormat;
    private final TrackInfo trackInfo;

    public SingleSampleChunkSource(DataSource dataSource, DataSpec dataSpec, Format format, long durationUs, MediaFormat mediaFormat) {
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.format = format;
        this.durationUs = durationUs;
        this.mediaFormat = mediaFormat;
        this.trackInfo = new TrackInfo(format.mimeType, durationUs);
    }

    @Override
    public TrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    @Override
    public void getMaxVideoDimensions(MediaFormat out) {
    }

    @Override
    public void enable() {
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
    }

    @Override
    public void getChunkOperation(List<? extends MediaChunk> queue, long seekPositionUs, long playbackPositionUs, ChunkOperationHolder out) {
        if (!queue.isEmpty()) {
            return;
        }
        out.chunk = this.initChunk();
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
    }

    @Override
    public IOException getError() {
        return null;
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    private SingleSampleMediaChunk initChunk() {
        return new SingleSampleMediaChunk(this.dataSource, this.dataSpec, this.format, 0, 0L, this.durationUs, -1, this.mediaFormat);
    }
}

