/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.net.Uri;
import android.os.SystemClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.hls.BitArrayChunk;
import com.google.android.exoplayer.hls.HlsChunk;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.TsExtractor;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.upstream.Aes128DataSource;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.BitArray;
import com.google.android.exoplayer.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class HlsChunkSource {
    public static final int ADAPTIVE_MODE_NONE = 0;
    public static final int ADAPTIVE_MODE_SPLICE = 1;
    public static final int ADAPTIVE_MODE_ABRUPT = 3;
    public static final long DEFAULT_TARGET_BUFFER_DURATION_MS = 40000L;
    public static final long DEFAULT_MIN_BUFFER_TO_SWITCH_UP_MS = 5000L;
    public static final long DEFAULT_MAX_BUFFER_TO_SWITCH_DOWN_MS = 20000L;
    private static final float BANDWIDTH_FRACTION = 0.8f;
    private final TsExtractor.SamplePool samplePool = new TsExtractor.SamplePool();
    private final DataSource upstreamDataSource;
    private final HlsPlaylistParser playlistParser;
    private final Variant[] enabledVariants;
    private final BandwidthMeter bandwidthMeter;
    private final BitArray bitArray;
    private final int adaptiveMode;
    private final Uri baseUri;
    private final int maxWidth;
    private final int maxHeight;
    private final long targetBufferDurationUs;
    private final long minBufferDurationToSwitchUpUs;
    private final long maxBufferDurationToSwitchDownUs;
    final HlsMediaPlaylist[] mediaPlaylists;
    final long[] lastMediaPlaylistLoadTimesMs;
    boolean live;
    long durationUs;
    private int variantIndex;
    private DataSource encryptedDataSource;
    private Uri encryptionKeyUri;
    private String encryptedDataSourceIv;
    private byte[] encryptedDataSourceSecretKey;

    public HlsChunkSource(DataSource dataSource, String playlistUrl, HlsPlaylist playlist, BandwidthMeter bandwidthMeter, int[] variantIndices, int adaptiveMode) {
        this(dataSource, playlistUrl, playlist, bandwidthMeter, variantIndices, adaptiveMode, 40000L, 5000L, 20000L);
    }

    public HlsChunkSource(DataSource dataSource, String playlistUrl, HlsPlaylist playlist, BandwidthMeter bandwidthMeter, int[] variantIndices, int adaptiveMode, long targetBufferDurationMs, long minBufferDurationToSwitchUpMs, long maxBufferDurationToSwitchDownMs) {
        this.upstreamDataSource = dataSource;
        this.bandwidthMeter = bandwidthMeter;
        this.adaptiveMode = adaptiveMode;
        this.targetBufferDurationUs = targetBufferDurationMs * 1000L;
        this.minBufferDurationToSwitchUpUs = minBufferDurationToSwitchUpMs * 1000L;
        this.maxBufferDurationToSwitchDownUs = maxBufferDurationToSwitchDownMs * 1000L;
        this.baseUri = playlist.baseUri;
        this.bitArray = new BitArray();
        this.playlistParser = new HlsPlaylistParser();
        if (playlist.type == 1) {
            this.enabledVariants = new Variant[]{new Variant(0, playlistUrl, 0, null, -1, -1)};
            this.mediaPlaylists = new HlsMediaPlaylist[1];
            this.lastMediaPlaylistLoadTimesMs = new long[1];
            this.setMediaPlaylist(0, (HlsMediaPlaylist)playlist);
        } else {
            Assertions.checkState(playlist.type == 0);
            this.enabledVariants = HlsChunkSource.filterVariants((HlsMasterPlaylist)playlist, variantIndices);
            this.mediaPlaylists = new HlsMediaPlaylist[this.enabledVariants.length];
            this.lastMediaPlaylistLoadTimesMs = new long[this.enabledVariants.length];
        }
        int maxWidth = -1;
        int maxHeight = -1;
        long minOriginalVariantIndex = Integer.MAX_VALUE;
        for (int i = 0; i < this.enabledVariants.length; ++i) {
            if ((long)this.enabledVariants[i].index < minOriginalVariantIndex) {
                minOriginalVariantIndex = this.enabledVariants[i].index;
                this.variantIndex = i;
            }
            maxWidth = Math.max(this.enabledVariants[i].width, maxWidth);
            maxHeight = Math.max(this.enabledVariants[i].width, maxHeight);
        }
        this.maxWidth = maxWidth > 0 ? maxWidth : 1920;
        this.maxHeight = maxHeight > 0 ? maxHeight : 1080;
    }

    public long getDurationUs() {
        return this.live ? -1L : this.durationUs;
    }

    public void getMaxVideoDimensions(MediaFormat out) {
        out.setMaxVideoDimensions(this.maxWidth, this.maxHeight);
    }

    public HlsChunk getChunkOperation(TsChunk previousTsChunk, long seekPositionUs, long playbackPositionUs) {
        HlsMediaPlaylist mediaPlaylist;
        if (previousTsChunk != null && (previousTsChunk.isLastChunk || previousTsChunk.endTimeUs - playbackPositionUs >= this.targetBufferDurationUs)) {
            return null;
        }
        int nextVariantIndex = this.variantIndex;
        boolean switchingVariant = false;
        boolean switchingVariantSpliced = false;
        if (this.adaptiveMode != 0) {
            nextVariantIndex = this.getNextVariantIndex(previousTsChunk, playbackPositionUs);
            switchingVariant = nextVariantIndex != this.variantIndex;
            boolean bl = switchingVariantSpliced = switchingVariant && this.adaptiveMode == 1;
        }
        if ((mediaPlaylist = this.mediaPlaylists[nextVariantIndex]) == null) {
            return this.newMediaPlaylistChunk(nextVariantIndex);
        }
        this.variantIndex = nextVariantIndex;
        int chunkMediaSequence = 0;
        boolean liveDiscontinuity = false;
        if (this.live) {
            if (previousTsChunk == null) {
                chunkMediaSequence = this.getLiveStartChunkMediaSequence(this.variantIndex);
            } else {
                int n = chunkMediaSequence = switchingVariantSpliced ? previousTsChunk.chunkIndex : previousTsChunk.chunkIndex + 1;
                if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
                    chunkMediaSequence = this.getLiveStartChunkMediaSequence(this.variantIndex);
                    liveDiscontinuity = true;
                }
            }
        } else {
            chunkMediaSequence = previousTsChunk == null ? Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(seekPositionUs), true, true) + mediaPlaylist.mediaSequence : (switchingVariantSpliced ? previousTsChunk.chunkIndex : previousTsChunk.chunkIndex + 1);
        }
        int chunkIndex = chunkMediaSequence - mediaPlaylist.mediaSequence;
        if (chunkIndex >= mediaPlaylist.segments.size()) {
            if (mediaPlaylist.live && this.shouldRerequestMediaPlaylist(this.variantIndex)) {
                return this.newMediaPlaylistChunk(this.variantIndex);
            }
            return null;
        }
        HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(chunkIndex);
        Uri chunkUri = Util.getMergedUri(mediaPlaylist.baseUri, segment.url);
        if ("AES-128".equals(segment.encryptionMethod)) {
            Uri keyUri = Util.getMergedUri(mediaPlaylist.baseUri, segment.encryptionKeyUri);
            if (!keyUri.equals((Object)this.encryptionKeyUri)) {
                EncryptionKeyChunk toReturn = this.newEncryptionKeyChunk(keyUri, segment.encryptionIV);
                return toReturn;
            }
            if (!Util.areEqual(segment.encryptionIV, this.encryptedDataSourceIv)) {
                this.initEncryptedDataSource(keyUri, segment.encryptionIV, this.encryptedDataSourceSecretKey);
            }
        } else {
            this.clearEncryptedDataSource();
        }
        DataSource dataSource = this.encryptedDataSource != null ? this.encryptedDataSource : this.upstreamDataSource;
        DataSpec dataSpec = new DataSpec(chunkUri, segment.byterangeOffset, segment.byterangeLength, null);
        long startTimeUs = this.live ? (previousTsChunk == null ? 0L : (switchingVariantSpliced ? previousTsChunk.startTimeUs : previousTsChunk.endTimeUs)) : segment.startTimeUs;
        long endTimeUs = startTimeUs + (long)(segment.durationSecs * 1000000.0);
        boolean isLastChunk = !mediaPlaylist.live && chunkIndex == mediaPlaylist.segments.size() - 1;
        TsExtractor extractor = previousTsChunk == null || segment.discontinuity || switchingVariant || liveDiscontinuity ? new TsExtractor(startTimeUs, this.samplePool, switchingVariantSpliced) : previousTsChunk.extractor;
        return new TsChunk(dataSource, dataSpec, extractor, this.enabledVariants[this.variantIndex].index, startTimeUs, endTimeUs, chunkMediaSequence, isLastChunk);
    }

    private int getNextVariantIndex(TsChunk previousTsChunk, long playbackPositionUs) {
        int idealVariantIndex = this.getVariantIndexForBandwdith((int)((float)this.bandwidthMeter.getBitrateEstimate() * 0.8f));
        if (idealVariantIndex == this.variantIndex) {
            return this.variantIndex;
        }
        long bufferedPositionUs = previousTsChunk == null ? playbackPositionUs : (this.adaptiveMode == 1 ? previousTsChunk.startTimeUs : previousTsChunk.endTimeUs);
        long bufferedUs = bufferedPositionUs - playbackPositionUs;
        if (idealVariantIndex > this.variantIndex && bufferedUs < this.maxBufferDurationToSwitchDownUs || idealVariantIndex < this.variantIndex && bufferedUs > this.minBufferDurationToSwitchUpUs) {
            return idealVariantIndex;
        }
        return this.variantIndex;
    }

    private int getVariantIndexForBandwdith(int bandwidth) {
        for (int i = 0; i < this.enabledVariants.length - 1; ++i) {
            if (this.enabledVariants[i].bandwidth > bandwidth) continue;
            return i;
        }
        return this.enabledVariants.length - 1;
    }

    private boolean shouldRerequestMediaPlaylist(int variantIndex) {
        HlsMediaPlaylist mediaPlaylist = this.mediaPlaylists[variantIndex];
        long timeSinceLastMediaPlaylistLoadMs = SystemClock.elapsedRealtime() - this.lastMediaPlaylistLoadTimesMs[variantIndex];
        return timeSinceLastMediaPlaylistLoadMs >= (long)(mediaPlaylist.targetDurationSecs * 1000 / 2);
    }

    private int getLiveStartChunkMediaSequence(int variantIndex) {
        HlsMediaPlaylist mediaPlaylist = this.mediaPlaylists[variantIndex];
        int chunkIndex = mediaPlaylist.segments.size() > 3 ? mediaPlaylist.segments.size() - 3 : 0;
        return chunkIndex + mediaPlaylist.mediaSequence;
    }

    private MediaPlaylistChunk newMediaPlaylistChunk(int variantIndex) {
        Uri mediaPlaylistUri = Util.getMergedUri(this.baseUri, this.enabledVariants[variantIndex].url);
        DataSpec dataSpec = new DataSpec(mediaPlaylistUri, 0L, -1L, null);
        Uri baseUri = Util.parseBaseUri(mediaPlaylistUri.toString());
        return new MediaPlaylistChunk(variantIndex, this.upstreamDataSource, dataSpec, baseUri);
    }

    private EncryptionKeyChunk newEncryptionKeyChunk(Uri keyUri, String iv) {
        DataSpec dataSpec = new DataSpec(keyUri, 0L, -1L, null);
        return new EncryptionKeyChunk(this.upstreamDataSource, dataSpec, iv);
    }

    void initEncryptedDataSource(Uri keyUri, String iv, byte[] secretKey) {
        String trimmedIv = iv.toLowerCase(Locale.getDefault()).startsWith("0x") ? iv.substring(2) : iv;
        byte[] ivData = new BigInteger(trimmedIv, 16).toByteArray();
        byte[] ivDataWithPadding = new byte[16];
        int offset = ivData.length > 16 ? ivData.length - 16 : 0;
        System.arraycopy(ivData, offset, ivDataWithPadding, ivDataWithPadding.length - ivData.length + offset, ivData.length - offset);
        this.encryptedDataSource = new Aes128DataSource(secretKey, ivDataWithPadding, this.upstreamDataSource);
        this.encryptionKeyUri = keyUri;
        this.encryptedDataSourceIv = iv;
        this.encryptedDataSourceSecretKey = secretKey;
    }

    private void clearEncryptedDataSource() {
        this.encryptionKeyUri = null;
        this.encryptedDataSource = null;
        this.encryptedDataSourceIv = null;
        this.encryptedDataSourceSecretKey = null;
    }

    void setMediaPlaylist(int variantIndex, HlsMediaPlaylist mediaPlaylist) {
        this.lastMediaPlaylistLoadTimesMs[variantIndex] = SystemClock.elapsedRealtime();
        this.mediaPlaylists[variantIndex] = mediaPlaylist;
        this.live |= mediaPlaylist.live;
        this.durationUs = mediaPlaylist.durationUs;
    }

    private static Variant[] filterVariants(HlsMasterPlaylist masterPlaylist, int[] variantIndices) {
        List<Variant> masterVariants = masterPlaylist.variants;
        ArrayList<Variant> enabledVariants = new ArrayList<Variant>();
        if (variantIndices != null) {
            for (int i = 0; i < variantIndices.length; ++i) {
                enabledVariants.add(masterVariants.get(variantIndices[i]));
            }
        } else {
            enabledVariants.addAll(masterVariants);
        }
        ArrayList<Variant> definiteVideoVariants = new ArrayList<Variant>();
        ArrayList<Variant> definiteAudioOnlyVariants = new ArrayList<Variant>();
        for (int i = 0; i < enabledVariants.size(); ++i) {
            Variant variant = (Variant)enabledVariants.get(i);
            if (variant.height > 0 || HlsChunkSource.variantHasExplicitCodecWithPrefix(variant, "avc")) {
                definiteVideoVariants.add(variant);
                continue;
            }
            if (!HlsChunkSource.variantHasExplicitCodecWithPrefix(variant, "mp4a")) continue;
            definiteAudioOnlyVariants.add(variant);
        }
        if (!definiteVideoVariants.isEmpty()) {
            enabledVariants = definiteVideoVariants;
        } else if (definiteAudioOnlyVariants.size() < enabledVariants.size()) {
            enabledVariants.removeAll(definiteAudioOnlyVariants);
        }
        Collections.sort(enabledVariants, new Variant.DecreasingBandwidthComparator());
        Variant[] enabledVariantsArray = new Variant[enabledVariants.size()];
        enabledVariants.toArray(enabledVariantsArray);
        return enabledVariantsArray;
    }

    private static boolean variantHasExplicitCodecWithPrefix(Variant variant, String prefix) {
        String[] codecs = variant.codecs;
        if (codecs == null) {
            return false;
        }
        for (int i = 0; i < codecs.length; ++i) {
            if (!codecs[i].startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private class EncryptionKeyChunk
    extends BitArrayChunk {
        private final String iv;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, String iv) {
            super(dataSource, dataSpec, HlsChunkSource.this.bitArray);
            this.iv = iv;
        }

        @Override
        protected void consume(BitArray data) throws IOException {
            byte[] secretKey = new byte[data.bytesLeft()];
            data.readBytes(secretKey, 0, secretKey.length);
            HlsChunkSource.this.initEncryptedDataSource(this.dataSpec.uri, this.iv, secretKey);
        }
    }

    private class MediaPlaylistChunk
    extends BitArrayChunk {
        private final int variantIndex;
        private final Uri playlistBaseUri;

        public MediaPlaylistChunk(int variantIndex, DataSource dataSource, DataSpec dataSpec, Uri playlistBaseUri) {
            super(dataSource, dataSpec, HlsChunkSource.this.bitArray);
            this.variantIndex = variantIndex;
            this.playlistBaseUri = playlistBaseUri;
        }

        @Override
        protected void consume(BitArray data) throws IOException {
            HlsPlaylist playlist = HlsChunkSource.this.playlistParser.parse(new ByteArrayInputStream(data.getData(), 0, data.bytesLeft()), null, null, this.playlistBaseUri);
            Assertions.checkState(playlist.type == 1);
            HlsMediaPlaylist mediaPlaylist = (HlsMediaPlaylist)playlist;
            HlsChunkSource.this.setMediaPlaylist(this.variantIndex, mediaPlaylist);
        }
    }
}

