/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.mp4;

import android.annotation.SuppressLint;
import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.parser.Extractor;
import com.google.android.exoplayer.parser.SegmentIndex;
import com.google.android.exoplayer.parser.mp4.Atom;
import com.google.android.exoplayer.parser.mp4.DefaultSampleValues;
import com.google.android.exoplayer.parser.mp4.ParsableByteArray;
import com.google.android.exoplayer.parser.mp4.Track;
import com.google.android.exoplayer.parser.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.parser.mp4.TrackFragment;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;

public final class FragmentedMp4Extractor
implements Extractor {
    public static final int WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    private static final int READ_TERMINATING_RESULTS = 39;
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
    private static final int[] AC3_CHANNEL_COUNTS = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
    private static final int[] AC3_BIT_RATES = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640};
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_ENCRYPTION_DATA = 2;
    private static final int STATE_READING_SAMPLE = 3;
    private static final int ATOM_HEADER_SIZE = 8;
    private static final int FULL_ATOM_HEADER_SIZE = 12;
    private static final Set<Integer> PARSED_ATOMS;
    private static final Set<Integer> CONTAINER_TYPES;
    private final int workaroundFlags;
    private final ParsableByteArray atomHeader;
    private final byte[] extendedTypeScratch;
    private final Stack<Atom.ContainerAtom> containerAtoms;
    private final TrackFragment fragmentRun;
    private int parserState;
    private int atomBytesRead;
    private int rootAtomBytesRead;
    private int atomType;
    private int atomSize;
    private ParsableByteArray atomData;
    private int pendingSeekTimeMs;
    private int sampleIndex;
    private int pendingSeekSyncSampleIndex;
    private int lastSyncSampleIndex;
    private final HashMap<UUID, byte[]> psshData;
    private SegmentIndex segmentIndex;
    private Track track;
    private DefaultSampleValues extendsDefaults;

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int workaroundFlags) {
        this.workaroundFlags = workaroundFlags;
        this.parserState = 0;
        this.atomHeader = new ParsableByteArray(8);
        this.extendedTypeScratch = new byte[16];
        this.containerAtoms = new Stack();
        this.fragmentRun = new TrackFragment();
        this.psshData = new HashMap();
    }

    public void setTrack(Track track) {
        this.extendsDefaults = new DefaultSampleValues(0, 0, 0, 0);
        this.track = track;
    }

    @Override
    public Map<UUID, byte[]> getPsshInfo() {
        return this.psshData.isEmpty() ? null : this.psshData;
    }

    @Override
    public SegmentIndex getIndex() {
        return this.segmentIndex;
    }

    @Override
    public boolean hasRelativeIndexOffsets() {
        return true;
    }

    @Override
    public MediaFormat getFormat() {
        return this.track == null ? null : this.track.mediaFormat;
    }

    @Override
    public int read(NonBlockingInputStream inputStream, SampleHolder out) throws ParserException {
        try {
            int results = 0;
            block7: while ((results & 0x27) == 0) {
                switch (this.parserState) {
                    case 0: {
                        results |= this.readAtomHeader(inputStream);
                        continue block7;
                    }
                    case 1: {
                        results |= this.readAtomPayload(inputStream);
                        continue block7;
                    }
                    case 2: {
                        results |= this.readEncryptionData(inputStream);
                        continue block7;
                    }
                }
                results |= this.readOrSkipSample(inputStream, out);
            }
            return results;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    @Override
    public boolean seekTo(long seekTimeUs, boolean allowNoop) {
        this.pendingSeekTimeMs = (int)(seekTimeUs / 1000L);
        if (allowNoop && this.fragmentRun != null && this.fragmentRun.length > 0 && (long)this.pendingSeekTimeMs >= this.fragmentRun.getSamplePresentationTime(0) && (long)this.pendingSeekTimeMs <= this.fragmentRun.getSamplePresentationTime(this.fragmentRun.length - 1)) {
            int sampleIndexFound = 0;
            int syncSampleIndexFound = 0;
            for (int i = 0; i < this.fragmentRun.length; ++i) {
                if (this.fragmentRun.getSamplePresentationTime(i) > (long)this.pendingSeekTimeMs) continue;
                if (this.fragmentRun.sampleIsSyncFrameTable[i]) {
                    syncSampleIndexFound = i;
                }
                sampleIndexFound = i;
            }
            if (syncSampleIndexFound == this.lastSyncSampleIndex && sampleIndexFound >= this.sampleIndex) {
                this.pendingSeekTimeMs = 0;
                return false;
            }
        }
        this.containerAtoms.clear();
        this.enterState(0);
        return true;
    }

    private void enterState(int state) {
        switch (state) {
            case 0: {
                this.atomBytesRead = 0;
                if (!this.containerAtoms.isEmpty()) break;
                this.rootAtomBytesRead = 0;
            }
        }
        this.parserState = state;
    }

    private int readAtomHeader(NonBlockingInputStream inputStream) {
        int remainingBytes = 8 - this.atomBytesRead;
        int bytesRead = inputStream.read(this.atomHeader.data, this.atomBytesRead, remainingBytes);
        if (bytesRead == -1) {
            return 2;
        }
        this.rootAtomBytesRead += bytesRead;
        this.atomBytesRead += bytesRead;
        if (this.atomBytesRead != 8) {
            return 1;
        }
        this.atomHeader.setPosition(0);
        this.atomSize = this.atomHeader.readInt();
        this.atomType = this.atomHeader.readInt();
        if (this.atomType == 1835295092) {
            if (this.fragmentRun.sampleEncryptionDataNeedsFill) {
                this.enterState(2);
            } else {
                this.enterState(3);
            }
            return 0;
        }
        Integer atomTypeInteger = this.atomType;
        if (PARSED_ATOMS.contains(atomTypeInteger)) {
            if (CONTAINER_TYPES.contains(atomTypeInteger)) {
                this.enterState(0);
                this.containerAtoms.add(new Atom.ContainerAtom(this.atomType, this.rootAtomBytesRead + this.atomSize - 8));
            } else {
                this.atomData = new ParsableByteArray(this.atomSize);
                System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
                this.enterState(1);
            }
        } else {
            this.atomData = null;
            this.enterState(1);
        }
        return 0;
    }

    private int readAtomPayload(NonBlockingInputStream inputStream) {
        int bytesRead = this.atomData != null ? inputStream.read(this.atomData.data, this.atomBytesRead, this.atomSize - this.atomBytesRead) : inputStream.skip(this.atomSize - this.atomBytesRead);
        if (bytesRead == -1) {
            return 2;
        }
        this.rootAtomBytesRead += bytesRead;
        this.atomBytesRead += bytesRead;
        if (this.atomBytesRead != this.atomSize) {
            return 1;
        }
        int results = 0;
        if (this.atomData != null) {
            results |= this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, this.atomData));
        }
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endByteOffset == this.rootAtomBytesRead) {
            results |= this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterState(0);
        return results;
    }

    private int onLeafAtomRead(Atom.LeafAtom leaf) {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(leaf);
        } else if (leaf.type == 1936286840) {
            this.segmentIndex = FragmentedMp4Extractor.parseSidx(leaf.data);
            return 16;
        }
        return 0;
    }

    private int onContainerAtomRead(Atom.ContainerAtom container) {
        if (container.type == 1836019574) {
            this.onMoovContainerAtomRead(container);
            return 8;
        }
        if (container.type == 0x6D6F6F66) {
            this.onMoofContainerAtomRead(container);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(container);
        }
        return 0;
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom moov) {
        ArrayList<Atom> moovChildren = moov.children;
        int moovChildrenSize = moovChildren.size();
        for (int i = 0; i < moovChildrenSize; ++i) {
            Atom child = (Atom)moovChildren.get(i);
            if (child.type != 1886614376) continue;
            ParsableByteArray psshAtom = ((Atom.LeafAtom)child).data;
            psshAtom.setPosition(12);
            UUID uuid = new UUID(psshAtom.readLong(), psshAtom.readLong());
            int dataSize = psshAtom.readInt();
            byte[] data = new byte[dataSize];
            psshAtom.readBytes(data, 0, dataSize);
            this.psshData.put(uuid, data);
        }
        Atom.ContainerAtom mvex = moov.getContainerAtomOfType(1836475768);
        this.extendsDefaults = FragmentedMp4Extractor.parseTrex(mvex.getLeafAtomOfType((int)1953654136).data);
        this.track = FragmentedMp4Extractor.parseTrak(moov.getContainerAtomOfType(1953653099));
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom moof) {
        this.fragmentRun.reset();
        FragmentedMp4Extractor.parseMoof(this.track, this.extendsDefaults, moof, this.fragmentRun, this.workaroundFlags, this.extendedTypeScratch);
        this.sampleIndex = 0;
        this.lastSyncSampleIndex = 0;
        this.pendingSeekSyncSampleIndex = 0;
        if (this.pendingSeekTimeMs != 0) {
            for (int i = 0; i < this.fragmentRun.length; ++i) {
                if (!this.fragmentRun.sampleIsSyncFrameTable[i] || this.fragmentRun.getSamplePresentationTime(i) > (long)this.pendingSeekTimeMs) continue;
                this.pendingSeekSyncSampleIndex = i;
            }
            this.pendingSeekTimeMs = 0;
        }
    }

    private static DefaultSampleValues parseTrex(ParsableByteArray trex) {
        trex.setPosition(16);
        int defaultSampleDescriptionIndex = trex.readUnsignedIntToInt() - 1;
        int defaultSampleDuration = trex.readUnsignedIntToInt();
        int defaultSampleSize = trex.readUnsignedIntToInt();
        int defaultSampleFlags = trex.readInt();
        return new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags);
    }

    private static Track parseTrak(Atom.ContainerAtom trak) {
        Atom.ContainerAtom mdia = trak.getContainerAtomOfType(1835297121);
        int trackType = FragmentedMp4Extractor.parseHdlr(mdia.getLeafAtomOfType((int)1751411826).data);
        Assertions.checkState(trackType == 1936684398 || trackType == 1986618469 || trackType == 1952807028);
        Pair<Integer, Long> header = FragmentedMp4Extractor.parseTkhd(trak.getLeafAtomOfType((int)1953196132).data);
        int id = (Integer)header.first;
        long timescale = FragmentedMp4Extractor.parseMdhd(mdia.getLeafAtomOfType((int)1835296868).data);
        Atom.ContainerAtom stbl = mdia.getContainerAtomOfType(1835626086).getContainerAtomOfType(1937007212);
        Pair<MediaFormat, TrackEncryptionBox[]> sampleDescriptions = FragmentedMp4Extractor.parseStsd(stbl.getLeafAtomOfType((int)1937011556).data);
        return new Track(id, trackType, timescale, (MediaFormat)sampleDescriptions.first, (TrackEncryptionBox[])sampleDescriptions.second);
    }

    private static Pair<Integer, Long> parseTkhd(ParsableByteArray tkhd) {
        long duration;
        tkhd.setPosition(8);
        int fullAtom = tkhd.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        tkhd.skip(version == 0 ? 8 : 16);
        int trackId = tkhd.readInt();
        tkhd.skip(4);
        boolean durationUnknown = true;
        int durationPosition = tkhd.getPosition();
        int durationByteCount = version == 0 ? 4 : 8;
        for (int i = 0; i < durationByteCount; ++i) {
            if (tkhd.data[durationPosition + i] == -1) continue;
            durationUnknown = false;
            break;
        }
        if (durationUnknown) {
            tkhd.skip(durationByteCount);
            duration = -1L;
        } else {
            duration = version == 0 ? tkhd.readUnsignedInt() : tkhd.readUnsignedLongToLong();
        }
        return Pair.create((Object)trackId, (Object)duration);
    }

    private static int parseHdlr(ParsableByteArray hdlr) {
        hdlr.setPosition(16);
        return hdlr.readInt();
    }

    private static long parseMdhd(ParsableByteArray mdhd) {
        mdhd.setPosition(8);
        int fullAtom = mdhd.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        mdhd.skip(version == 0 ? 8 : 16);
        return mdhd.readUnsignedInt();
    }

    private static Pair<MediaFormat, TrackEncryptionBox[]> parseStsd(ParsableByteArray stsd) {
        stsd.setPosition(12);
        int numberOfEntries = stsd.readInt();
        MediaFormat mediaFormat = null;
        TrackEncryptionBox[] trackEncryptionBoxes = new TrackEncryptionBox[numberOfEntries];
        for (int i = 0; i < numberOfEntries; ++i) {
            int childStartPosition = stsd.getPosition();
            int childAtomSize = stsd.readInt();
            int childAtomType = stsd.readInt();
            if (childAtomType == 1635148593 || childAtomType == 1635148595 || childAtomType == 1701733238) {
                Pair<MediaFormat, TrackEncryptionBox> avc = FragmentedMp4Extractor.parseAvcFromParent(stsd, childStartPosition, childAtomSize);
                mediaFormat = (MediaFormat)avc.first;
                trackEncryptionBoxes[i] = (TrackEncryptionBox)avc.second;
            } else if (childAtomType == 1836069985 || childAtomType == 1701733217 || childAtomType == 1633889587) {
                Pair<MediaFormat, TrackEncryptionBox> audioSampleEntry = FragmentedMp4Extractor.parseAudioSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize);
                mediaFormat = (MediaFormat)audioSampleEntry.first;
                trackEncryptionBoxes[i] = (TrackEncryptionBox)audioSampleEntry.second;
            } else if (childAtomType == 1414810956) {
                mediaFormat = MediaFormat.createTtmlFormat();
            }
            stsd.setPosition(childStartPosition + childAtomSize);
        }
        return Pair.create(mediaFormat, (Object)trackEncryptionBoxes);
    }

    private static Pair<MediaFormat, TrackEncryptionBox> parseAvcFromParent(ParsableByteArray parent, int position, int size) {
        parent.setPosition(position + 8);
        parent.skip(24);
        int width = parent.readUnsignedShort();
        int height = parent.readUnsignedShort();
        float pixelWidthHeightRatio = 1.0f;
        parent.skip(50);
        List<byte[]> initializationData = null;
        TrackEncryptionBox trackEncryptionBox = null;
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1635148611) {
                initializationData = FragmentedMp4Extractor.parseAvcCFromParent(parent, childStartPosition);
            } else if (childAtomType == 1936289382) {
                trackEncryptionBox = FragmentedMp4Extractor.parseSinfFromParent(parent, childStartPosition, childAtomSize);
            } else if (childAtomType == 1885434736) {
                pixelWidthHeightRatio = FragmentedMp4Extractor.parsePaspFromParent(parent, childStartPosition);
            }
            childPosition += childAtomSize;
        }
        MediaFormat format = MediaFormat.createVideoFormat("video/avc", -1, width, height, pixelWidthHeightRatio, initializationData);
        return Pair.create((Object)format, trackEncryptionBox);
    }

    private static Pair<MediaFormat, TrackEncryptionBox> parseAudioSampleEntry(ParsableByteArray parent, int atomType, int position, int size) {
        parent.setPosition(position + 8);
        parent.skip(16);
        int channelCount = parent.readUnsignedShort();
        int sampleSize = parent.readUnsignedShort();
        parent.skip(4);
        int sampleRate = parent.readUnsignedFixedPoint1616();
        int bitrate = -1;
        byte[] initializationData = null;
        TrackEncryptionBox trackEncryptionBox = null;
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (atomType == 1836069985 || atomType == 1701733217) {
                if (childAtomType == 1702061171) {
                    initializationData = FragmentedMp4Extractor.parseEsdsFromParent(parent, childStartPosition);
                    Pair<Integer, Integer> audioSpecificConfig = CodecSpecificDataUtil.parseAudioSpecificConfig(initializationData);
                    sampleRate = (Integer)audioSpecificConfig.first;
                    channelCount = (Integer)audioSpecificConfig.second;
                } else if (childAtomType == 1936289382) {
                    trackEncryptionBox = FragmentedMp4Extractor.parseSinfFromParent(parent, childStartPosition, childAtomSize);
                }
            } else if (atomType == 1633889587 && childAtomType == 1684103987) {
                Ac3Format ac3Format = FragmentedMp4Extractor.parseAc3SpecificBoxFromParent(parent, childStartPosition);
                if (ac3Format != null) {
                    sampleRate = ac3Format.sampleRate;
                    channelCount = ac3Format.channelCount;
                    bitrate = ac3Format.bitrate;
                }
                trackEncryptionBox = null;
            } else if (atomType == 1700998451 && childAtomType == 1684366131) {
                sampleRate = FragmentedMp4Extractor.parseEc3SpecificBoxFromParent(parent, childStartPosition);
                trackEncryptionBox = null;
            }
            childPosition += childAtomSize;
        }
        String mimeType = atomType == 1633889587 ? "audio/ac3" : (atomType == 1700998451 ? "audio/eac3" : "audio/mp4a-latm");
        MediaFormat format = MediaFormat.createAudioFormat(mimeType, sampleSize, channelCount, sampleRate, bitrate, initializationData == null ? null : Collections.singletonList(initializationData));
        return Pair.create((Object)format, trackEncryptionBox);
    }

    private static Ac3Format parseAc3SpecificBoxFromParent(ParsableByteArray parent, int position) {
        int sampleRate;
        parent.setPosition(position + 8);
        int fscod = (parent.readUnsignedByte() & 0xC0) >> 6;
        switch (fscod) {
            case 0: {
                sampleRate = 48000;
                break;
            }
            case 1: {
                sampleRate = 44100;
                break;
            }
            case 2: {
                sampleRate = 32000;
                break;
            }
            default: {
                return null;
            }
        }
        int nextByte = parent.readUnsignedByte();
        int channelCount = AC3_CHANNEL_COUNTS[(nextByte & 0x38) >> 3];
        if ((nextByte & 4) != 0) {
            ++channelCount;
        }
        int bitrate = AC3_BIT_RATES[((nextByte & 3) << 3) + (parent.readUnsignedByte() >> 5)];
        return new Ac3Format(channelCount, sampleRate, bitrate);
    }

    private static int parseEc3SpecificBoxFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8);
        return 0;
    }

    private static List<byte[]> parseAvcCFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        int nalUnitLength = (parent.readUnsignedByte() & 3) + 1;
        if (nalUnitLength != 4) {
            throw new IllegalStateException();
        }
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        int numSequenceParameterSets = parent.readUnsignedByte() & 0x1F;
        for (int j = 0; j < numSequenceParameterSets; ++j) {
            initializationData.add(FragmentedMp4Extractor.parseChildNalUnit(parent));
        }
        int numPictureParamterSets = parent.readUnsignedByte();
        for (int j = 0; j < numPictureParamterSets; ++j) {
            initializationData.add(FragmentedMp4Extractor.parseChildNalUnit(parent));
        }
        return initializationData;
    }

    private static byte[] parseChildNalUnit(ParsableByteArray atom) {
        int length = atom.readUnsignedShort();
        int offset = atom.getPosition();
        atom.skip(length);
        return CodecSpecificDataUtil.buildNalUnit(atom.data, offset, length);
    }

    private static TrackEncryptionBox parseSinfFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        TrackEncryptionBox trackEncryptionBox = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1718775137) {
                parent.readInt();
            } else if (childAtomType == 1935894637) {
                parent.skip(4);
                parent.readInt();
                parent.readInt();
            } else if (childAtomType == 1935894633) {
                trackEncryptionBox = FragmentedMp4Extractor.parseSchiFromParent(parent, childPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return trackEncryptionBox;
    }

    private static float parsePaspFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8);
        int hSpacing = parent.readUnsignedIntToInt();
        int vSpacing = parent.readUnsignedIntToInt();
        return (float)hSpacing / (float)vSpacing;
    }

    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1952804451) {
                parent.skip(4);
                int firstInt = parent.readInt();
                boolean defaultIsEncrypted = firstInt >> 8 == 1;
                int defaultInitVectorSize = firstInt & 0xFF;
                byte[] defaultKeyId = new byte[16];
                parent.readBytes(defaultKeyId, 0, defaultKeyId.length);
                return new TrackEncryptionBox(defaultIsEncrypted, defaultInitVectorSize, defaultKeyId);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static byte[] parseEsdsFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        parent.skip(1);
        int varIntByte = parent.readUnsignedByte();
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
        }
        parent.skip(2);
        int flags = parent.readUnsignedByte();
        if ((flags & 0x80) != 0) {
            parent.skip(2);
        }
        if ((flags & 0x40) != 0) {
            parent.skip(parent.readUnsignedShort());
        }
        if ((flags & 0x20) != 0) {
            parent.skip(2);
        }
        parent.skip(1);
        varIntByte = parent.readUnsignedByte();
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
        }
        parent.skip(13);
        parent.skip(1);
        varIntByte = parent.readUnsignedByte();
        int varInt = varIntByte & 0x7F;
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
            varInt <<= 8;
            varInt |= varIntByte & 0x7F;
        }
        byte[] initializationData = new byte[varInt];
        parent.readBytes(initializationData, 0, varInt);
        return initializationData;
    }

    private static void parseMoof(Track track, DefaultSampleValues extendsDefaults, Atom.ContainerAtom moof, TrackFragment out, int workaroundFlags, byte[] extendedTypeScratch) {
        FragmentedMp4Extractor.parseTraf(track, extendsDefaults, moof.getContainerAtomOfType(1953653094), out, workaroundFlags, extendedTypeScratch);
    }

    private static void parseTraf(Track track, DefaultSampleValues extendsDefaults, Atom.ContainerAtom traf, TrackFragment out, int workaroundFlags, byte[] extendedTypeScratch) {
        Atom.LeafAtom senc;
        Atom.LeafAtom tfdtAtom = traf.getLeafAtomOfType(0x74666474);
        long decodeTime = tfdtAtom == null ? 0L : FragmentedMp4Extractor.parseTfdt(traf.getLeafAtomOfType((int)0x74666474).data);
        Atom.LeafAtom tfhd = traf.getLeafAtomOfType(1952868452);
        DefaultSampleValues fragmentHeader = FragmentedMp4Extractor.parseTfhd(extendsDefaults, tfhd.data);
        out.sampleDescriptionIndex = fragmentHeader.sampleDescriptionIndex;
        Atom.LeafAtom trun = traf.getLeafAtomOfType(1953658222);
        FragmentedMp4Extractor.parseTrun(track, fragmentHeader, decodeTime, workaroundFlags, trun.data, out);
        Atom.LeafAtom saiz = traf.getLeafAtomOfType(1935763834);
        if (saiz != null) {
            TrackEncryptionBox trackEncryptionBox = track.sampleDescriptionEncryptionBoxes[fragmentHeader.sampleDescriptionIndex];
            FragmentedMp4Extractor.parseSaiz(trackEncryptionBox, saiz.data, out);
        }
        if ((senc = traf.getLeafAtomOfType(1936027235)) != null) {
            FragmentedMp4Extractor.parseSenc(senc.data, out);
        }
        int childrenSize = traf.children.size();
        for (int i = 0; i < childrenSize; ++i) {
            Atom atom = traf.children.get(i);
            if (atom.type != 1970628964) continue;
            FragmentedMp4Extractor.parseUuid(((Atom.LeafAtom)atom).data, out, extendedTypeScratch);
        }
    }

    private static void parseSaiz(TrackEncryptionBox encryptionBox, ParsableByteArray saiz, TrackFragment out) {
        int vectorSize = encryptionBox.initializationVectorSize;
        saiz.setPosition(8);
        int fullAtom = saiz.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        if ((flags & 1) == 1) {
            saiz.skip(8);
        }
        int defaultSampleInfoSize = saiz.readUnsignedByte();
        int sampleCount = saiz.readUnsignedIntToInt();
        if (sampleCount != out.length) {
            throw new IllegalStateException("Length mismatch: " + sampleCount + ", " + out.length);
        }
        int totalSize = 0;
        if (defaultSampleInfoSize == 0) {
            boolean[] sampleHasSubsampleEncryptionTable = out.sampleHasSubsampleEncryptionTable;
            for (int i = 0; i < sampleCount; ++i) {
                int sampleInfoSize = saiz.readUnsignedByte();
                totalSize += sampleInfoSize;
                sampleHasSubsampleEncryptionTable[i] = sampleInfoSize > vectorSize;
            }
        } else {
            boolean subsampleEncryption = defaultSampleInfoSize > vectorSize;
            totalSize += defaultSampleInfoSize * sampleCount;
            Arrays.fill(out.sampleHasSubsampleEncryptionTable, 0, sampleCount, subsampleEncryption);
        }
        out.initEncryptionData(totalSize);
    }

    private static DefaultSampleValues parseTfhd(DefaultSampleValues extendsDefaults, ParsableByteArray tfhd) {
        tfhd.setPosition(8);
        int fullAtom = tfhd.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        tfhd.skip(4);
        if ((flags & 1) != 0) {
            tfhd.skip(8);
        }
        int defaultSampleDescriptionIndex = (flags & 2) != 0 ? tfhd.readUnsignedIntToInt() - 1 : extendsDefaults.sampleDescriptionIndex;
        int defaultSampleDuration = (flags & 8) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.duration;
        int defaultSampleSize = (flags & 0x10) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.size;
        int defaultSampleFlags = (flags & 0x20) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.flags;
        return new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags);
    }

    private static long parseTfdt(ParsableByteArray tfdt) {
        tfdt.setPosition(8);
        int fullAtom = tfdt.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        return version == 1 ? tfdt.readUnsignedLongToLong() : tfdt.readUnsignedInt();
    }

    private static void parseTrun(Track track, DefaultSampleValues defaultSampleValues, long decodeTime, int workaroundFlags, ParsableByteArray trun, TrackFragment out) {
        trun.setPosition(8);
        int fullAtom = trun.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        int sampleCount = trun.readUnsignedIntToInt();
        if ((flags & 1) != 0) {
            trun.skip(4);
        }
        boolean firstSampleFlagsPresent = (flags & 4) != 0;
        int firstSampleFlags = defaultSampleValues.flags;
        if (firstSampleFlagsPresent) {
            firstSampleFlags = trun.readUnsignedIntToInt();
        }
        boolean sampleDurationsPresent = (flags & 0x100) != 0;
        boolean sampleSizesPresent = (flags & 0x200) != 0;
        boolean sampleFlagsPresent = (flags & 0x400) != 0;
        boolean sampleCompositionTimeOffsetsPresent = (flags & 0x800) != 0;
        out.initTables(sampleCount);
        int[] sampleSizeTable = out.sampleSizeTable;
        int[] sampleCompositionTimeOffsetTable = out.sampleCompositionTimeOffsetTable;
        long[] sampleDecodingTimeTable = out.sampleDecodingTimeTable;
        boolean[] sampleIsSyncFrameTable = out.sampleIsSyncFrameTable;
        long timescale = track.timescale;
        long cumulativeTime = decodeTime;
        boolean workaroundEveryVideoFrameIsSyncFrame = track.type == 1986618469 && (workaroundFlags & 1) == 1;
        for (int i = 0; i < sampleCount; ++i) {
            int sampleFlags;
            int sampleSize;
            int sampleDuration = sampleDurationsPresent ? trun.readUnsignedIntToInt() : defaultSampleValues.duration;
            int n = sampleSize = sampleSizesPresent ? trun.readUnsignedIntToInt() : defaultSampleValues.size;
            int n2 = i == 0 && firstSampleFlagsPresent ? firstSampleFlags : (sampleFlags = sampleFlagsPresent ? trun.readInt() : defaultSampleValues.flags);
            if (sampleCompositionTimeOffsetsPresent) {
                int sampleOffset = trun.readInt();
                sampleCompositionTimeOffsetTable[i] = (int)((long)(sampleOffset * 1000) / timescale);
            } else {
                sampleCompositionTimeOffsetTable[i] = 0;
            }
            sampleDecodingTimeTable[i] = cumulativeTime * 1000L / timescale;
            sampleSizeTable[i] = sampleSize;
            sampleIsSyncFrameTable[i] = (sampleFlags >> 16 & 1) == 0 && (!workaroundEveryVideoFrameIsSyncFrame || i == 0);
            cumulativeTime += (long)sampleDuration;
        }
    }

    private static void parseUuid(ParsableByteArray uuid, TrackFragment out, byte[] extendedTypeScratch) {
        uuid.setPosition(8);
        uuid.readBytes(extendedTypeScratch, 0, 16);
        if (!Arrays.equals(extendedTypeScratch, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        FragmentedMp4Extractor.parseSenc(uuid, 16, out);
    }

    private static void parseSenc(ParsableByteArray senc, TrackFragment out) {
        FragmentedMp4Extractor.parseSenc(senc, 0, out);
    }

    private static void parseSenc(ParsableByteArray senc, int offset, TrackFragment out) {
        senc.setPosition(8 + offset);
        int fullAtom = senc.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        if ((flags & 1) != 0) {
            throw new IllegalStateException("Overriding TrackEncryptionBox parameters is unsupported");
        }
        boolean subsampleEncryption = (flags & 2) != 0;
        int sampleCount = senc.readUnsignedIntToInt();
        if (sampleCount != out.length) {
            throw new IllegalStateException("Length mismatch: " + sampleCount + ", " + out.length);
        }
        Arrays.fill(out.sampleHasSubsampleEncryptionTable, 0, sampleCount, subsampleEncryption);
        out.initEncryptionData(senc.length() - senc.getPosition());
        out.fillEncryptionData(senc);
    }

    private static SegmentIndex parseSidx(ParsableByteArray atom) {
        long firstOffset;
        long earliestPresentationTime;
        atom.setPosition(8);
        int fullAtom = atom.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        atom.skip(4);
        long timescale = atom.readUnsignedInt();
        if (version == 0) {
            earliestPresentationTime = atom.readUnsignedInt();
            firstOffset = atom.readUnsignedInt();
        } else {
            earliestPresentationTime = atom.readUnsignedLongToLong();
            firstOffset = atom.readUnsignedLongToLong();
        }
        atom.skip(2);
        int referenceCount = atom.readUnsignedShort();
        int[] sizes = new int[referenceCount];
        long[] offsets = new long[referenceCount];
        long[] durationsUs = new long[referenceCount];
        long[] timesUs = new long[referenceCount];
        long offset = firstOffset;
        long time = earliestPresentationTime;
        long timeUs = Util.scaleLargeTimestamp(time, 1000000L, timescale);
        for (int i = 0; i < referenceCount; ++i) {
            int firstInt = atom.readInt();
            int type = Integer.MIN_VALUE & firstInt;
            if (type != 0) {
                throw new IllegalStateException("Unhandled indirect reference");
            }
            long referenceDuration = atom.readUnsignedInt();
            sizes[i] = Integer.MAX_VALUE & firstInt;
            offsets[i] = offset;
            timesUs[i] = timeUs;
            timeUs = Util.scaleLargeTimestamp(time += referenceDuration, 1000000L, timescale);
            durationsUs[i] = timeUs - timesUs[i];
            atom.skip(4);
            offset += (long)sizes[i];
        }
        return new SegmentIndex(atom.length(), sizes, offsets, durationsUs, timesUs);
    }

    private int readEncryptionData(NonBlockingInputStream inputStream) {
        boolean success = this.fragmentRun.fillEncryptionData(inputStream);
        if (!success) {
            return 1;
        }
        this.enterState(3);
        return 0;
    }

    private int readOrSkipSample(NonBlockingInputStream inputStream, SampleHolder out) {
        if (this.sampleIndex >= this.fragmentRun.length) {
            this.enterState(0);
            return 0;
        }
        int sampleSize = this.fragmentRun.sampleSizeTable[this.sampleIndex];
        if (inputStream.getAvailableByteCount() < (long)sampleSize) {
            return 1;
        }
        if (this.sampleIndex < this.pendingSeekSyncSampleIndex) {
            return this.skipSample(inputStream, sampleSize);
        }
        return this.readSample(inputStream, sampleSize, out);
    }

    private int skipSample(NonBlockingInputStream inputStream, int sampleSize) {
        if (this.fragmentRun.definesEncryptionData) {
            int subsampleCount;
            ParsableByteArray sampleEncryptionData = this.fragmentRun.sampleEncryptionData;
            TrackEncryptionBox encryptionBox = this.track.sampleDescriptionEncryptionBoxes[this.fragmentRun.sampleDescriptionIndex];
            int vectorSize = encryptionBox.initializationVectorSize;
            boolean subsampleEncryption = this.fragmentRun.sampleHasSubsampleEncryptionTable[this.sampleIndex];
            sampleEncryptionData.skip(vectorSize);
            int n = subsampleCount = subsampleEncryption ? sampleEncryptionData.readUnsignedShort() : 1;
            if (subsampleEncryption) {
                sampleEncryptionData.skip(6 * subsampleCount);
            }
        }
        inputStream.skip(sampleSize);
        ++this.sampleIndex;
        this.enterState(3);
        return 0;
    }

    @SuppressLint(value={"InlinedApi"})
    private int readSample(NonBlockingInputStream inputStream, int sampleSize, SampleHolder out) {
        ByteBuffer outputData;
        if (out == null) {
            return 32;
        }
        out.timeUs = this.fragmentRun.getSamplePresentationTime(this.sampleIndex) * 1000L;
        out.flags = 0;
        if (this.fragmentRun.sampleIsSyncFrameTable[this.sampleIndex]) {
            out.flags |= 1;
            this.lastSyncSampleIndex = this.sampleIndex;
        }
        if (out.data == null || out.data.capacity() < sampleSize) {
            out.replaceBuffer(sampleSize);
        }
        if (this.fragmentRun.definesEncryptionData) {
            this.readSampleEncryptionData(this.fragmentRun.sampleEncryptionData, out);
        }
        if ((outputData = out.data) == null) {
            inputStream.skip(sampleSize);
            out.size = 0;
        } else {
            inputStream.read(outputData, sampleSize);
            if (this.track.type == 1986618469) {
                int sampleOffset;
                int length;
                for (int position = sampleOffset = outputData.position() - sampleSize; position < sampleOffset + sampleSize; position += length + 4) {
                    outputData.position(position);
                    length = FragmentedMp4Extractor.readUnsignedIntToInt(outputData);
                    outputData.position(position);
                    outputData.put(NAL_START_CODE);
                }
                outputData.position(sampleOffset + sampleSize);
            }
            out.size = sampleSize;
        }
        ++this.sampleIndex;
        this.enterState(3);
        return 4;
    }

    @SuppressLint(value={"InlinedApi"})
    private void readSampleEncryptionData(ParsableByteArray sampleEncryptionData, SampleHolder out) {
        int[] encryptedDataSizes;
        TrackEncryptionBox encryptionBox = this.track.sampleDescriptionEncryptionBoxes[this.fragmentRun.sampleDescriptionIndex];
        byte[] keyId = encryptionBox.keyId;
        boolean isEncrypted = encryptionBox.isEncrypted;
        int vectorSize = encryptionBox.initializationVectorSize;
        boolean subsampleEncryption = this.fragmentRun.sampleHasSubsampleEncryptionTable[this.sampleIndex];
        byte[] vector = out.cryptoInfo.iv;
        if (vector == null || vector.length != 16) {
            vector = new byte[16];
        }
        sampleEncryptionData.readBytes(vector, 0, vectorSize);
        int subsampleCount = subsampleEncryption ? sampleEncryptionData.readUnsignedShort() : 1;
        int[] clearDataSizes = out.cryptoInfo.numBytesOfClearData;
        if (clearDataSizes == null || clearDataSizes.length < subsampleCount) {
            clearDataSizes = new int[subsampleCount];
        }
        if ((encryptedDataSizes = out.cryptoInfo.numBytesOfEncryptedData) == null || encryptedDataSizes.length < subsampleCount) {
            encryptedDataSizes = new int[subsampleCount];
        }
        if (subsampleEncryption) {
            for (int i = 0; i < subsampleCount; ++i) {
                clearDataSizes[i] = sampleEncryptionData.readUnsignedShort();
                encryptedDataSizes[i] = sampleEncryptionData.readUnsignedIntToInt();
            }
        } else {
            clearDataSizes[0] = 0;
            encryptedDataSizes[0] = this.fragmentRun.sampleSizeTable[this.sampleIndex];
        }
        out.cryptoInfo.set(subsampleCount, clearDataSizes, encryptedDataSizes, keyId, vector, isEncrypted ? 1 : 0);
        if (isEncrypted) {
            out.flags |= 2;
        }
    }

    private static int parseFullAtomVersion(int fullAtomInt) {
        return 0xFF & fullAtomInt >> 24;
    }

    private static int parseFullAtomFlags(int fullAtomInt) {
        return 0xFFFFFF & fullAtomInt;
    }

    private static int readUnsignedIntToInt(ByteBuffer data) {
        int result = 0xFF & data.get();
        for (int i = 1; i < 4; ++i) {
            result <<= 8;
            result |= 0xFF & data.get();
        }
        if (result < 0) {
            throw new IllegalArgumentException("Top bit not zero: " + result);
        }
        return result;
    }

    static {
        HashSet<Integer> parsedAtoms = new HashSet<Integer>();
        parsedAtoms.add(1635148593);
        parsedAtoms.add(1635148595);
        parsedAtoms.add(1702061171);
        parsedAtoms.add(1751411826);
        parsedAtoms.add(1835295092);
        parsedAtoms.add(1835296868);
        parsedAtoms.add(0x6D6F6F66);
        parsedAtoms.add(1836019574);
        parsedAtoms.add(1836069985);
        parsedAtoms.add(1936286840);
        parsedAtoms.add(1937011556);
        parsedAtoms.add(0x74666474);
        parsedAtoms.add(1952868452);
        parsedAtoms.add(1953196132);
        parsedAtoms.add(1953653094);
        parsedAtoms.add(1953653099);
        parsedAtoms.add(1953654136);
        parsedAtoms.add(1953658222);
        parsedAtoms.add(1836475768);
        parsedAtoms.add(1835297121);
        parsedAtoms.add(1835626086);
        parsedAtoms.add(1937007212);
        parsedAtoms.add(1886614376);
        parsedAtoms.add(1935763834);
        parsedAtoms.add(1970628964);
        parsedAtoms.add(1936027235);
        parsedAtoms.add(1885434736);
        PARSED_ATOMS = Collections.unmodifiableSet(parsedAtoms);
        HashSet<Integer> atomContainerTypes = new HashSet<Integer>();
        atomContainerTypes.add(1836019574);
        atomContainerTypes.add(1953653099);
        atomContainerTypes.add(1835297121);
        atomContainerTypes.add(1835626086);
        atomContainerTypes.add(1937007212);
        atomContainerTypes.add(1635148611);
        atomContainerTypes.add(0x6D6F6F66);
        atomContainerTypes.add(1953653094);
        atomContainerTypes.add(1836475768);
        CONTAINER_TYPES = Collections.unmodifiableSet(atomContainerTypes);
    }

    private static final class Ac3Format {
        public final int channelCount;
        public final int sampleRate;
        public final int bitrate;

        public Ac3Format(int channelCount, int sampleRate, int bitrate) {
            this.channelCount = channelCount;
            this.sampleRate = sampleRate;
            this.bitrate = bitrate;
        }
    }
}

