/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.net.Uri;
import android.os.SystemClock;
import android.util.Base64;
import android.util.SparseArray;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.Mp4MediaChunk;
import com.google.android.exoplayer.parser.Extractor;
import com.google.android.exoplayer.parser.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.parser.mp4.Track;
import com.google.android.exoplayer.parser.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SmoothStreamingChunkSource
implements ChunkSource {
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final int INITIALIZATION_VECTOR_SIZE = 8;
    private final ManifestFetcher<SmoothStreamingManifest> manifestFetcher;
    private final int streamElementIndex;
    private final TrackInfo trackInfo;
    private final DataSource dataSource;
    private final FormatEvaluator formatEvaluator;
    private final FormatEvaluator.Evaluation evaluation;
    private final long liveEdgeLatencyUs;
    private final int maxWidth;
    private final int maxHeight;
    private final SparseArray<FragmentedMp4Extractor> extractors;
    private final Map<UUID, byte[]> psshInfo;
    private final SmoothStreamingFormat[] formats;
    private SmoothStreamingManifest currentManifest;
    private int currentManifestChunkOffset;
    private boolean finishedCurrentManifest;
    private IOException fatalError;

    public SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, int streamElementIndex, int[] trackIndices, DataSource dataSource, FormatEvaluator formatEvaluator, long liveEdgeLatencyMs) {
        this(manifestFetcher, manifestFetcher.getManifest(), streamElementIndex, trackIndices, dataSource, formatEvaluator, liveEdgeLatencyMs);
    }

    public SmoothStreamingChunkSource(SmoothStreamingManifest manifest, int streamElementIndex, int[] trackIndices, DataSource dataSource, FormatEvaluator formatEvaluator) {
        this(null, manifest, streamElementIndex, trackIndices, dataSource, formatEvaluator, 0L);
    }

    private SmoothStreamingChunkSource(ManifestFetcher<SmoothStreamingManifest> manifestFetcher, SmoothStreamingManifest initialManifest, int streamElementIndex, int[] trackIndices, DataSource dataSource, FormatEvaluator formatEvaluator, long liveEdgeLatencyMs) {
        this.manifestFetcher = manifestFetcher;
        this.streamElementIndex = streamElementIndex;
        this.currentManifest = initialManifest;
        this.dataSource = dataSource;
        this.formatEvaluator = formatEvaluator;
        this.liveEdgeLatencyUs = liveEdgeLatencyMs * 1000L;
        SmoothStreamingManifest.StreamElement streamElement = this.getElement(initialManifest);
        this.trackInfo = new TrackInfo(streamElement.tracks[0].mimeType, initialManifest.durationUs);
        this.evaluation = new FormatEvaluator.Evaluation();
        TrackEncryptionBox[] trackEncryptionBoxes = null;
        SmoothStreamingManifest.ProtectionElement protectionElement = initialManifest.protectionElement;
        if (protectionElement != null) {
            byte[] keyId = SmoothStreamingChunkSource.getKeyId(protectionElement.data);
            trackEncryptionBoxes = new TrackEncryptionBox[]{new TrackEncryptionBox(true, 8, keyId)};
            this.psshInfo = Collections.singletonMap(protectionElement.uuid, protectionElement.data);
        } else {
            this.psshInfo = null;
        }
        int trackCount = trackIndices != null ? trackIndices.length : streamElement.tracks.length;
        this.formats = new SmoothStreamingFormat[trackCount];
        this.extractors = new SparseArray();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < trackCount; ++i) {
            int trackIndex = trackIndices != null ? trackIndices[i] : i;
            SmoothStreamingManifest.TrackElement trackElement = streamElement.tracks[trackIndex];
            this.formats[i] = new SmoothStreamingFormat(String.valueOf(trackIndex), trackElement.mimeType, trackElement.maxWidth, trackElement.maxHeight, trackElement.numChannels, trackElement.sampleRate, trackElement.bitrate, trackIndex);
            maxWidth = Math.max(maxWidth, trackElement.maxWidth);
            maxHeight = Math.max(maxHeight, trackElement.maxHeight);
            MediaFormat mediaFormat = SmoothStreamingChunkSource.getMediaFormat(streamElement, trackIndex);
            int trackType = streamElement.type == 1 ? 1986618469 : 1936684398;
            FragmentedMp4Extractor extractor = new FragmentedMp4Extractor(1);
            extractor.setTrack(new Track(trackIndex, trackType, streamElement.timescale, mediaFormat, trackEncryptionBoxes));
            this.extractors.put(trackIndex, (Object)extractor);
        }
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        Arrays.sort(this.formats, new Format.DecreasingBandwidthComparator());
    }

    @Override
    public final void getMaxVideoDimensions(MediaFormat out) {
        if (this.trackInfo.mimeType.startsWith("video")) {
            out.setMaxVideoDimensions(this.maxWidth, this.maxHeight);
        }
    }

    @Override
    public final TrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    @Override
    public void enable() {
        this.fatalError = null;
        if (this.manifestFetcher != null) {
            this.manifestFetcher.enable();
        }
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
        if (this.manifestFetcher != null) {
            this.manifestFetcher.disable();
        }
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
        if (this.manifestFetcher == null || !this.currentManifest.isLive || this.fatalError != null) {
            return;
        }
        SmoothStreamingManifest newManifest = this.manifestFetcher.getManifest();
        if (this.currentManifest != newManifest && newManifest != null) {
            SmoothStreamingManifest.StreamElement currentElement = this.getElement(this.currentManifest);
            SmoothStreamingManifest.StreamElement newElement = this.getElement(newManifest);
            if (newElement.chunkCount == 0) {
                this.currentManifestChunkOffset += currentElement.chunkCount;
            } else if (currentElement.chunkCount > 0) {
                this.currentManifestChunkOffset += currentElement.getChunkIndex(newElement.getStartTimeUs(0));
            }
            this.currentManifest = newManifest;
            this.finishedCurrentManifest = false;
        }
        if (this.finishedCurrentManifest && SystemClock.elapsedRealtime() > this.manifestFetcher.getManifestLoadTimestamp() + 5000L) {
            this.manifestFetcher.requestRefresh();
        }
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> queue, long seekPositionUs, long playbackPositionUs, ChunkOperationHolder out) {
        int chunkIndex;
        if (this.fatalError != null) {
            out.chunk = null;
            return;
        }
        this.evaluation.queueSize = queue.size();
        this.formatEvaluator.evaluate(queue, playbackPositionUs, this.formats, this.evaluation);
        SmoothStreamingFormat selectedFormat = (SmoothStreamingFormat)this.evaluation.format;
        out.queueSize = this.evaluation.queueSize;
        if (selectedFormat == null) {
            out.chunk = null;
            return;
        }
        if (out.queueSize == queue.size() && out.chunk != null && out.chunk.format.id.equals(this.evaluation.format.id)) {
            return;
        }
        out.chunk = null;
        SmoothStreamingManifest.StreamElement streamElement = this.getElement(this.currentManifest);
        if (streamElement.chunkCount == 0) {
            this.finishedCurrentManifest = true;
            return;
        }
        if (queue.isEmpty()) {
            if (this.currentManifest.isLive) {
                seekPositionUs = this.getLiveSeekPosition();
            }
            chunkIndex = streamElement.getChunkIndex(seekPositionUs);
        } else {
            chunkIndex = queue.get((int)(out.queueSize - 1)).nextChunkIndex - this.currentManifestChunkOffset;
        }
        if (this.currentManifest.isLive) {
            if (chunkIndex < 0) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
            if (chunkIndex >= streamElement.chunkCount) {
                this.finishedCurrentManifest = true;
                return;
            }
            if (chunkIndex == streamElement.chunkCount - 1) {
                this.finishedCurrentManifest = true;
            }
        } else if (chunkIndex == -1) {
            return;
        }
        boolean isLastChunk = !this.currentManifest.isLive && chunkIndex == streamElement.chunkCount - 1;
        long chunkStartTimeUs = streamElement.getStartTimeUs(chunkIndex);
        long nextChunkStartTimeUs = isLastChunk ? -1L : chunkStartTimeUs + streamElement.getChunkDurationUs(chunkIndex);
        int currentAbsoluteChunkIndex = chunkIndex + this.currentManifestChunkOffset;
        Uri uri = streamElement.buildRequestUri(selectedFormat.trackIndex, chunkIndex);
        MediaChunk mediaChunk = SmoothStreamingChunkSource.newMediaChunk(selectedFormat, uri, null, (Extractor)this.extractors.get(Integer.parseInt(selectedFormat.id)), this.psshInfo, this.dataSource, currentAbsoluteChunkIndex, isLastChunk, chunkStartTimeUs, nextChunkStartTimeUs, 0);
        out.chunk = mediaChunk;
    }

    @Override
    public IOException getError() {
        return this.fatalError != null ? this.fatalError : (this.manifestFetcher != null ? this.manifestFetcher.getError() : null);
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    private long getLiveSeekPosition() {
        long liveEdgeTimestampUs = Long.MIN_VALUE;
        for (int i = 0; i < this.currentManifest.streamElements.length; ++i) {
            SmoothStreamingManifest.StreamElement streamElement = this.currentManifest.streamElements[i];
            if (streamElement.chunkCount <= 0) continue;
            long elementLiveEdgeTimestampUs = streamElement.getStartTimeUs(streamElement.chunkCount - 1) + streamElement.getChunkDurationUs(streamElement.chunkCount - 1);
            liveEdgeTimestampUs = Math.max(liveEdgeTimestampUs, elementLiveEdgeTimestampUs);
        }
        return liveEdgeTimestampUs - this.liveEdgeLatencyUs;
    }

    private SmoothStreamingManifest.StreamElement getElement(SmoothStreamingManifest manifest) {
        return manifest.streamElements[this.streamElementIndex];
    }

    private static MediaFormat getMediaFormat(SmoothStreamingManifest.StreamElement streamElement, int trackIndex) {
        SmoothStreamingManifest.TrackElement trackElement = streamElement.tracks[trackIndex];
        String mimeType = trackElement.mimeType;
        if (streamElement.type == 1) {
            MediaFormat format = MediaFormat.createVideoFormat(mimeType, -1, trackElement.maxWidth, trackElement.maxHeight, Arrays.asList(trackElement.csd));
            format.setMaxVideoDimensions(streamElement.maxWidth, streamElement.maxHeight);
            return format;
        }
        if (streamElement.type == 0) {
            List<Object> csd = trackElement.csd != null ? Arrays.asList(trackElement.csd) : Collections.singletonList(CodecSpecificDataUtil.buildAudioSpecificConfig(trackElement.sampleRate, trackElement.numChannels));
            MediaFormat format = MediaFormat.createAudioFormat(mimeType, -1, trackElement.numChannels, trackElement.sampleRate, csd);
            return format;
        }
        if (streamElement.type == 2) {
            return MediaFormat.createFormatForMimeType(streamElement.tracks[trackIndex].mimeType);
        }
        return null;
    }

    private static MediaChunk newMediaChunk(Format formatInfo, Uri uri, String cacheKey, Extractor extractor, Map<UUID, byte[]> psshInfo, DataSource dataSource, int chunkIndex, boolean isLast, long chunkStartTimeUs, long nextChunkStartTimeUs, int trigger) {
        int nextChunkIndex = isLast ? -1 : chunkIndex + 1;
        long nextStartTimeUs = isLast ? -1L : nextChunkStartTimeUs;
        long offset = 0L;
        DataSpec dataSpec = new DataSpec(uri, offset, -1L, cacheKey);
        return new Mp4MediaChunk(dataSource, dataSpec, formatInfo, trigger, chunkStartTimeUs, nextStartTimeUs, nextChunkIndex, extractor, psshInfo, false, -chunkStartTimeUs);
    }

    private static byte[] getKeyId(byte[] initData) {
        StringBuilder initDataStringBuilder = new StringBuilder();
        for (int i = 0; i < initData.length; i += 2) {
            initDataStringBuilder.append((char)initData[i]);
        }
        String initDataString = initDataStringBuilder.toString();
        String keyIdString = initDataString.substring(initDataString.indexOf("<KID>") + 5, initDataString.indexOf("</KID>"));
        byte[] keyId = Base64.decode((String)keyIdString, (int)0);
        SmoothStreamingChunkSource.swap(keyId, 0, 3);
        SmoothStreamingChunkSource.swap(keyId, 1, 2);
        SmoothStreamingChunkSource.swap(keyId, 4, 5);
        SmoothStreamingChunkSource.swap(keyId, 6, 7);
        return keyId;
    }

    private static void swap(byte[] data, int firstPosition, int secondPosition) {
        byte temp = data[firstPosition];
        data[firstPosition] = data[secondPosition];
        data[secondPosition] = temp;
    }

    private static final class SmoothStreamingFormat
    extends Format {
        public final int trackIndex;

        public SmoothStreamingFormat(String id, String mimeType, int width, int height, int numChannels, int audioSamplingRate, int bitrate, int trackIndex) {
            super(id, mimeType, width, height, numChannels, audioSamplingRate, bitrate);
            this.trackIndex = trackIndex;
        }
    }
}

