/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.eia608;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.eia608.ClosedCaption;
import com.google.android.exoplayer.text.eia608.Eia608Parser;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Eia608TrackRenderer
extends TrackRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private static final int ALLOWED_CAPTIONS_TEXT_LINES_COUNT = 4;
    private final SampleSource source;
    private final Eia608Parser eia608Parser;
    private final TextRenderer textRenderer;
    private final Handler metadataHandler;
    private final MediaFormatHolder formatHolder;
    private final SampleHolder sampleHolder;
    private final StringBuilder closedCaptionStringBuilder;
    private final List<ClosedCaption> currentCaptions;
    private final Queue<Integer> newLineIndexes;
    private int trackIndex;
    private long currentPositionUs;
    private boolean inputStreamEnded;
    private long pendingCaptionsTimestamp;
    private List<ClosedCaption> pendingCaptions;

    public Eia608TrackRenderer(SampleSource source, TextRenderer textRenderer, Looper textRendererLooper) {
        this.source = Assertions.checkNotNull(source);
        this.textRenderer = Assertions.checkNotNull(textRenderer);
        this.metadataHandler = textRendererLooper == null ? null : new Handler(textRendererLooper, (Handler.Callback)this);
        this.eia608Parser = new Eia608Parser();
        this.formatHolder = new MediaFormatHolder();
        this.sampleHolder = new SampleHolder(1);
        this.closedCaptionStringBuilder = new StringBuilder();
        this.currentCaptions = new LinkedList<ClosedCaption>();
        this.newLineIndexes = new LinkedList<Integer>();
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        for (int i = 0; i < this.source.getTrackCount(); ++i) {
            if (!this.eia608Parser.canParse(this.source.getTrackInfo((int)i).mimeType)) continue;
            this.trackIndex = i;
            return 1;
        }
        return -1;
    }

    @Override
    protected void onEnabled(long positionUs, boolean joining) {
        this.source.enable(this.trackIndex, positionUs);
        this.seekToInternal(positionUs);
    }

    @Override
    protected void seekTo(long positionUs) throws ExoPlaybackException {
        this.source.seekToUs(positionUs);
        this.seekToInternal(positionUs);
    }

    private void seekToInternal(long positionUs) {
        this.currentPositionUs = positionUs;
        this.pendingCaptions = null;
        this.inputStreamEnded = false;
        this.currentCaptions.clear();
    }

    @Override
    protected void doSomeWork(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        this.currentPositionUs = positionUs;
        try {
            this.source.continueBuffering(positionUs);
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        if (!this.inputStreamEnded && this.pendingCaptions == null) {
            try {
                int result = this.source.readData(this.trackIndex, positionUs, this.formatHolder, this.sampleHolder, false);
                if (result == -3) {
                    this.pendingCaptionsTimestamp = this.sampleHolder.timeUs;
                    this.pendingCaptions = this.eia608Parser.parse(this.sampleHolder.data.array(), this.sampleHolder.size, this.sampleHolder.timeUs);
                    this.sampleHolder.data.clear();
                } else if (result == -1) {
                    this.inputStreamEnded = true;
                }
            }
            catch (IOException e) {
                throw new ExoPlaybackException(e);
            }
        }
        if (this.pendingCaptions != null && this.pendingCaptionsTimestamp <= this.currentPositionUs) {
            this.invokeRenderer(this.pendingCaptions);
            this.pendingCaptions = null;
        }
    }

    @Override
    protected void onDisabled() {
        this.pendingCaptions = null;
        this.source.disable(this.trackIndex);
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getCurrentPositionUs() {
        return this.currentPositionUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void invokeRenderer(List<ClosedCaption> metadata) {
        if (this.metadataHandler != null) {
            this.metadataHandler.obtainMessage(0, metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal((List)msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(List<ClosedCaption> metadata) {
        int i;
        this.currentCaptions.addAll(metadata);
        Collections.sort(this.currentCaptions);
        this.closedCaptionStringBuilder.setLength(0);
        int cutIndex = 0;
        this.newLineIndexes.clear();
        block3: for (i = 0; i < this.currentCaptions.size(); ++i) {
            ClosedCaption caption = this.currentCaptions.get(i);
            if (caption.type == 0) {
                int cc2 = caption.text.codePointAt(1);
                switch (cc2) {
                    case 44: {
                        this.closedCaptionStringBuilder.setLength(0);
                        cutIndex = i;
                        this.newLineIndexes.clear();
                        break;
                    }
                    default: {
                        if (cc2 >= 32 && cc2 < 64) break;
                        if (this.closedCaptionStringBuilder.length() <= 0 || this.closedCaptionStringBuilder.charAt(this.closedCaptionStringBuilder.length() - 1) == '\n') continue block3;
                        this.closedCaptionStringBuilder.append('\n');
                        this.newLineIndexes.add(i);
                        if (this.newLineIndexes.size() < 4) continue block3;
                        cutIndex = this.newLineIndexes.poll();
                        break;
                    }
                }
                continue;
            }
            this.closedCaptionStringBuilder.append(caption.text);
        }
        if (cutIndex > 0 && cutIndex < this.currentCaptions.size() - 1) {
            for (i = 0; i <= cutIndex; ++i) {
                this.currentCaptions.remove(0);
            }
        }
        this.textRenderer.onText(this.closedCaptionStringBuilder.toString());
    }
}

