/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.Looper;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayerImpl;
import com.google.android.exoplayer.TrackRenderer;

public interface ExoPlayer {
    public static final int STATE_IDLE = 1;
    public static final int STATE_PREPARING = 2;
    public static final int STATE_BUFFERING = 3;
    public static final int STATE_READY = 4;
    public static final int STATE_ENDED = 5;
    public static final long UNKNOWN_TIME = -1L;

    public Looper getPlaybackLooper();

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public int getPlaybackState();

    public void prepare(TrackRenderer ... var1);

    public void setRendererEnabled(int var1, boolean var2);

    public boolean getRendererEnabled(int var1);

    public void setPlayWhenReady(boolean var1);

    public boolean getPlayWhenReady();

    public boolean isPlayWhenReadyCommitted();

    public void seekTo(long var1);

    public void stop();

    public void release();

    public void sendMessage(ExoPlayerComponent var1, int var2, Object var3);

    public void blockingSendMessage(ExoPlayerComponent var1, int var2, Object var3);

    public long getDuration();

    public long getCurrentPosition();

    public long getBufferedPosition();

    public int getBufferedPercentage();

    public static interface ExoPlayerComponent {
        public void handleMessage(int var1, Object var2) throws ExoPlaybackException;
    }

    public static interface Listener {
        public void onPlayerStateChanged(boolean var1, int var2);

        public void onPlayWhenReadyCommitted();

        public void onPlayerError(ExoPlaybackException var1);
    }

    public static final class Factory {
        public static final int DEFAULT_MIN_BUFFER_MS = 500;
        public static final int DEFAULT_MIN_REBUFFER_MS = 5000;

        private Factory() {
        }

        public static ExoPlayer newInstance(int rendererCount, int minBufferMs, int minRebufferMs) {
            return new ExoPlayerImpl(rendererCount, minBufferMs, minRebufferMs);
        }

        public static ExoPlayer newInstance(int rendererCount) {
            return new ExoPlayerImpl(rendererCount, 500, 5000);
        }

        @Deprecated
        public static ExoPlayer newInstance(int rendererCount, int minRebufferMs) {
            return new ExoPlayerImpl(rendererCount, 500, minRebufferMs);
        }
    }
}

