/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaExtractor;
import android.net.Uri;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=16)
public final class FrameworkSampleSource
implements SampleSource {
    private static final int TRACK_STATE_DISABLED = 0;
    private static final int TRACK_STATE_ENABLED = 1;
    private static final int TRACK_STATE_FORMAT_SENT = 2;
    private final Context context;
    private final Uri uri;
    private final Map<String, String> headers;
    private final FileDescriptor fileDescriptor;
    private final long fileDescriptorOffset;
    private final long fileDescriptorLength;
    private MediaExtractor extractor;
    private TrackInfo[] trackInfos;
    private boolean prepared;
    private int remainingReleaseCount;
    private int[] trackStates;
    private boolean[] pendingDiscontinuities;
    private long seekPositionUs;

    public FrameworkSampleSource(Context context, Uri uri, Map<String, String> headers, int downstreamRendererCount) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.remainingReleaseCount = downstreamRendererCount;
        this.context = context;
        this.uri = uri;
        this.headers = headers;
        this.fileDescriptor = null;
        this.fileDescriptorOffset = 0L;
        this.fileDescriptorLength = 0L;
    }

    public FrameworkSampleSource(FileDescriptor fileDescriptor, long offset, long length, int downstreamRendererCount) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.remainingReleaseCount = downstreamRendererCount;
        this.fileDescriptor = fileDescriptor;
        this.fileDescriptorOffset = offset;
        this.fileDescriptorLength = length;
        this.context = null;
        this.uri = null;
        this.headers = null;
    }

    @Override
    public boolean prepare() throws IOException {
        if (!this.prepared) {
            this.extractor = new MediaExtractor();
            if (this.context != null) {
                this.extractor.setDataSource(this.context, this.uri, this.headers);
            } else {
                this.extractor.setDataSource(this.fileDescriptor, this.fileDescriptorOffset, this.fileDescriptorLength);
            }
            this.trackStates = new int[this.extractor.getTrackCount()];
            this.pendingDiscontinuities = new boolean[this.trackStates.length];
            this.trackInfos = new TrackInfo[this.trackStates.length];
            for (int i = 0; i < this.trackStates.length; ++i) {
                android.media.MediaFormat format = this.extractor.getTrackFormat(i);
                long durationUs = format.containsKey("durationUs") ? format.getLong("durationUs") : -1L;
                String mime = format.getString("mime");
                this.trackInfos[i] = new TrackInfo(mime, durationUs);
            }
            this.prepared = true;
        }
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackStates.length;
    }

    @Override
    public TrackInfo getTrackInfo(int track) {
        Assertions.checkState(this.prepared);
        return this.trackInfos[track];
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] == 0);
        this.trackStates[track] = 1;
        this.extractor.selectTrack(track);
        this.seekToUs(positionUs);
    }

    @Override
    public boolean continueBuffering(long positionUs) {
        return true;
    }

    @Override
    public int readData(int track, long positionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder, boolean onlyReadDiscontinuity) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] != 0);
        if (this.pendingDiscontinuities[track]) {
            this.pendingDiscontinuities[track] = false;
            return -5;
        }
        if (onlyReadDiscontinuity) {
            return -2;
        }
        if (this.trackStates[track] != 2) {
            formatHolder.format = MediaFormat.createFromFrameworkMediaFormatV16(this.extractor.getTrackFormat(track));
            formatHolder.drmInitData = Util.SDK_INT >= 18 ? this.getPsshInfoV18() : null;
            this.trackStates[track] = 2;
            return -4;
        }
        int extractorTrackIndex = this.extractor.getSampleTrackIndex();
        if (extractorTrackIndex == track) {
            if (sampleHolder.data != null) {
                int offset = sampleHolder.data.position();
                sampleHolder.size = this.extractor.readSampleData(sampleHolder.data, offset);
                sampleHolder.data.position(offset + sampleHolder.size);
            } else {
                sampleHolder.size = 0;
            }
            sampleHolder.timeUs = this.extractor.getSampleTime();
            sampleHolder.flags = this.extractor.getSampleFlags();
            if ((sampleHolder.flags & 2) != 0) {
                sampleHolder.cryptoInfo.setFromExtractorV16(this.extractor);
            }
            this.seekPositionUs = -1L;
            this.extractor.advance();
            return -3;
        }
        return extractorTrackIndex < 0 ? -1 : -2;
    }

    @TargetApi(value=18)
    private Map<UUID, byte[]> getPsshInfoV18() {
        Map psshInfo = this.extractor.getPsshInfo();
        return psshInfo == null || psshInfo.isEmpty() ? null : psshInfo;
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[track] != 0);
        this.extractor.unselectTrack(track);
        this.pendingDiscontinuities[track] = false;
        this.trackStates[track] = 0;
    }

    @Override
    public void seekToUs(long positionUs) {
        Assertions.checkState(this.prepared);
        if (this.seekPositionUs != positionUs) {
            this.seekPositionUs = positionUs;
            this.extractor.seekTo(positionUs, 0);
            for (int i = 0; i < this.trackStates.length; ++i) {
                if (this.trackStates[i] == 0) continue;
                this.pendingDiscontinuities[i] = true;
            }
        }
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        long bufferedDurationUs = this.extractor.getCachedDuration();
        if (bufferedDurationUs == -1L) {
            return -1L;
        }
        long sampleTime = this.extractor.getSampleTime();
        return sampleTime == -1L ? -3L : sampleTime + bufferedDurationUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0) {
            this.extractor.release();
            this.extractor = null;
        }
    }
}

