/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.SegmentBase;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ManifestParser;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MediaPresentationDescriptionParser
extends DefaultHandler
implements ManifestParser<MediaPresentationDescription> {
    private final XmlPullParserFactory xmlParserFactory;

    public MediaPresentationDescriptionParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public MediaPresentationDescription parse(InputStream inputStream, String inputEncoding, String contentId, Uri baseUrl) throws IOException, ParserException {
        try {
            XmlPullParser xpp = this.xmlParserFactory.newPullParser();
            xpp.setInput(inputStream, inputEncoding);
            int eventType = xpp.next();
            if (eventType != 2 || !"MPD".equals(xpp.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xpp, contentId, baseUrl);
        }
        catch (XmlPullParserException e) {
            throw new ParserException(e);
        }
        catch (ParseException e) {
            throw new ParserException(e);
        }
    }

    protected MediaPresentationDescription parseMediaPresentationDescription(XmlPullParser xpp, String contentId, Uri baseUrl) throws XmlPullParserException, IOException, ParseException {
        long availabilityStartTime = MediaPresentationDescriptionParser.parseDateTime(xpp, "availabilityStartTime", -1L);
        long durationMs = MediaPresentationDescriptionParser.parseDuration(xpp, "mediaPresentationDuration", -1L);
        long minBufferTimeMs = MediaPresentationDescriptionParser.parseDuration(xpp, "minBufferTime", -1L);
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = typeString != null ? typeString.equals("dynamic") : false;
        long minUpdateTimeMs = dynamic ? MediaPresentationDescriptionParser.parseDuration(xpp, "minimumUpdatePeriod", -1L) : -1L;
        long timeShiftBufferDepthMs = dynamic ? MediaPresentationDescriptionParser.parseDuration(xpp, "timeShiftBufferDepth", -1L) : -1L;
        UtcTimingElement utcTiming = null;
        ArrayList<Period> periods = new ArrayList<Period>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "UTCTiming")) {
                utcTiming = this.parseUtcTiming(xpp);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "Period")) continue;
            periods.add(this.parsePeriod(xpp, contentId, baseUrl, durationMs));
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "MPD"));
        return this.buildMediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, utcTiming, periods);
    }

    protected MediaPresentationDescription buildMediaPresentationDescription(long availabilityStartTime, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdateTimeMs, long timeShiftBufferDepthMs, UtcTimingElement utcTiming, List<Period> periods) {
        return new MediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, utcTiming, periods);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xpp) {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        String value = xpp.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(schemeIdUri, value);
    }

    protected UtcTimingElement buildUtcTimingElement(String schemeIdUri, String value) {
        return new UtcTimingElement(schemeIdUri, value);
    }

    protected Period parsePeriod(XmlPullParser xpp, String contentId, Uri baseUrl, long mpdDurationMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = MediaPresentationDescriptionParser.parseDuration(xpp, "start", 0L);
        long durationMs = MediaPresentationDescriptionParser.parseDuration(xpp, "duration", mpdDurationMs);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, contentId, baseUrl, startMs, durationMs, segmentBase));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, null);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, null, durationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, null, durationMs);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "Period"));
        return this.buildPeriod(id, startMs, durationMs, adaptationSets);
    }

    protected Period buildPeriod(String id, long startMs, long durationMs, List<AdaptationSet> adaptationSets) {
        return new Period(id, startMs, durationMs, adaptationSets);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xpp, String contentId, Uri baseUrl, long periodStartMs, long periodDurationMs, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        String language = xpp.getAttributeValue(null, "lang");
        int contentType = this.parseAdaptationSetTypeFromMimeType(mimeType);
        int id = -1;
        ArrayList<ContentProtection> contentProtections = null;
        ArrayList<Representation> representations = new ArrayList<Representation>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "ContentProtection")) {
                if (contentProtections == null) {
                    contentProtections = new ArrayList<ContentProtection>();
                }
                contentProtections.add(this.parseContentProtection(xpp));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "ContentComponent")) {
                id = Integer.parseInt(xpp.getAttributeValue(null, "id"));
                contentType = this.checkAdaptationSetTypeConsistency(contentType, this.parseAdaptationSetType(xpp.getAttributeValue(null, "contentType")));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Representation")) {
                Representation representation = this.parseRepresentation(xpp, contentId, baseUrl, periodStartMs, periodDurationMs, mimeType, language, segmentBase);
                contentType = this.checkAdaptationSetTypeConsistency(contentType, this.parseAdaptationSetTypeFromMimeType(representation.format.mimeType));
                representations.add(representation);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase, periodDurationMs);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase, periodDurationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp)) continue;
            this.parseAdaptationSetChild(xpp);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "AdaptationSet"));
        return this.buildAdaptationSet(id, contentType, representations, contentProtections);
    }

    protected AdaptationSet buildAdaptationSet(int id, int contentType, List<Representation> representations, List<ContentProtection> contentProtections) {
        return new AdaptationSet(id, contentType, representations, contentProtections);
    }

    protected int parseAdaptationSetType(String contentType) {
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 0 : ("text".equals(contentType) ? 2 : -1)));
    }

    protected int parseAdaptationSetTypeFromMimeType(String mimeType) {
        return TextUtils.isEmpty((CharSequence)mimeType) ? -1 : (MimeTypes.isAudio(mimeType) ? 1 : (MimeTypes.isVideo(mimeType) ? 0 : (MimeTypes.isText(mimeType) || MimeTypes.isTtml(mimeType) ? 2 : -1)));
    }

    private int checkAdaptationSetTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState(firstType == secondType);
        return firstType;
    }

    protected ContentProtection parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        return this.buildContentProtection(schemeIdUri);
    }

    protected ContentProtection buildContentProtection(String schemeIdUri) {
        return new ContentProtection(schemeIdUri, null, null);
    }

    protected void parseAdaptationSetChild(XmlPullParser xpp) throws XmlPullParserException, IOException {
    }

    protected Representation parseRepresentation(XmlPullParser xpp, String contentId, Uri baseUrl, long periodStartMs, long periodDurationMs, String mimeType, String language, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = MediaPresentationDescriptionParser.parseInt(xpp, "bandwidth");
        int audioSamplingRate = MediaPresentationDescriptionParser.parseInt(xpp, "audioSamplingRate");
        int width = MediaPresentationDescriptionParser.parseInt(xpp, "width");
        int height = MediaPresentationDescriptionParser.parseInt(xpp, "height");
        mimeType = MediaPresentationDescriptionParser.parseString(xpp, "mimeType", mimeType);
        String codecs = MediaPresentationDescriptionParser.parseString(xpp, "codecs", null);
        int numChannels = -1;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "AudioChannelConfiguration")) {
                numChannels = Integer.parseInt(xpp.getAttributeValue(null, "value"));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase, periodDurationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase, periodDurationMs);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "Representation"));
        Format format = this.buildFormat(id, mimeType, width, height, numChannels, audioSamplingRate, bandwidth, language, codecs);
        return this.buildRepresentation(periodStartMs, periodDurationMs, contentId, -1, format, segmentBase);
    }

    protected Format buildFormat(String id, String mimeType, int width, int height, int numChannels, int audioSamplingRate, int bandwidth, String language, String codecs) {
        return new Format(id, mimeType, width, height, numChannels, audioSamplingRate, bandwidth, language, codecs);
    }

    protected Representation buildRepresentation(long periodStartMs, long periodDurationMs, String contentId, int revisionId, Format format, SegmentBase segmentBase) {
        return Representation.newInstance(periodStartMs, periodDurationMs, contentId, revisionId, format, segmentBase);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, Uri baseUrl, SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : -1L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) continue;
            initialization = this.parseInitialization(xpp, baseUrl);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentBase"));
        return this.buildSingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, Uri baseUrl, long indexStart, long indexLength) {
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, Uri baseUrl, SegmentBase.SegmentList parent, long periodDurationMs) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentURL")) continue;
            if (segments == null) {
                segments = new ArrayList<RangedUri>();
            }
            segments.add(this.parseSegmentUrl(xpp, baseUrl));
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return this.buildSegmentList(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long periodDurationMs, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, List<RangedUri> segments) {
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, Uri baseUrl, SegmentBase.SegmentTemplate parent, long periodDurationMs) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTimeline")) continue;
            timeline = this.parseSegmentTimeline(xpp);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return this.buildSegmentTemplate(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long periodDurationMs, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate, Uri baseUrl) {
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long elapsedTime = 0L;
        do {
            xpp.next();
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "S")) continue;
            elapsedTime = MediaPresentationDescriptionParser.parseLong(xpp, "t", elapsedTime);
            long duration = MediaPresentationDescriptionParser.parseLong(xpp, "d");
            int count = 1 + MediaPresentationDescriptionParser.parseInt(xpp, "r", 0);
            for (int i = 0; i < count; ++i) {
                segmentTimeline.add(this.buildSegmentTimelineElement(elapsedTime, duration));
                elapsedTime += duration;
            }
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentTimeline"));
        return segmentTimeline;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long elapsedTime, long duration) {
        return new SegmentBase.SegmentTimelineElement(elapsedTime, duration);
    }

    protected UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    protected RangedUri parseInitialization(XmlPullParser xpp, Uri baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xpp, Uri baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xpp, Uri baseUrl, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
        }
        return this.buildRangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected RangedUri buildRangedUri(Uri baseUrl, String urlText, long rangeStart, long rangeLength) {
        return new RangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected static boolean isEndTag(XmlPullParser xpp, String name) throws XmlPullParserException {
        return xpp.getEventType() == 3 && name.equals(xpp.getName());
    }

    protected static boolean isStartTag(XmlPullParser xpp, String name) throws XmlPullParserException {
        return xpp.getEventType() == 2 && name.equals(xpp.getName());
    }

    protected static boolean isStartTag(XmlPullParser xpp) throws XmlPullParserException {
        return xpp.getEventType() == 2;
    }

    protected static long parseDuration(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDuration(value);
    }

    protected static long parseDateTime(XmlPullParser xpp, String name, long defaultValue) throws ParseException {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDateTime(value);
    }

    protected static Uri parseBaseUrl(XmlPullParser xpp, Uri parentBaseUrl) throws XmlPullParserException, IOException {
        xpp.next();
        String newBaseUrlText = xpp.getText();
        Uri newBaseUri = Uri.parse((String)newBaseUrlText);
        if (!newBaseUri.isAbsolute()) {
            newBaseUri = Uri.withAppendedPath((Uri)parentBaseUrl, (String)newBaseUrlText);
        }
        return newBaseUri;
    }

    protected static int parseInt(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseInt(xpp, name, -1);
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseLong(xpp, name, -1L);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }
}

