/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.os.SystemClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.hls.HlsChunk;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.TsExtractor;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.LinkedList;

public class HlsSampleSource
implements SampleSource,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final int NO_RESET_PENDING = -1;
    private final HlsChunkSource chunkSource;
    private final LinkedList<TsExtractor> extractors;
    private final boolean frameAccurateSeeking;
    private final int minLoadableRetryCount;
    private int remainingReleaseCount;
    private boolean prepared;
    private int trackCount;
    private int enabledTrackCount;
    private boolean[] trackEnabledStates;
    private boolean[] pendingDiscontinuities;
    private TrackInfo[] trackInfos;
    private MediaFormat[] downstreamMediaFormats;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private TsChunk previousTsLoadable;
    private HlsChunk currentLoadable;
    private boolean loadingFinished;
    private Loader loader;
    private IOException currentLoadableException;
    private boolean currentLoadableExceptionFatal;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;

    public HlsSampleSource(HlsChunkSource chunkSource, boolean frameAccurateSeeking, int downstreamRendererCount) {
        this(chunkSource, frameAccurateSeeking, downstreamRendererCount, 3);
    }

    public HlsSampleSource(HlsChunkSource chunkSource, boolean frameAccurateSeeking, int downstreamRendererCount, int minLoadableRetryCount) {
        this.chunkSource = chunkSource;
        this.frameAccurateSeeking = frameAccurateSeeking;
        this.remainingReleaseCount = downstreamRendererCount;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.extractors = new LinkedList();
    }

    @Override
    public boolean prepare() throws IOException {
        TsExtractor extractor;
        if (this.prepared) {
            return true;
        }
        if (this.loader == null) {
            this.loader = new Loader("Loader:HLS");
        }
        this.continueBufferingInternal();
        if (!this.extractors.isEmpty() && (extractor = this.extractors.getFirst()).isPrepared()) {
            this.trackCount = extractor.getTrackCount();
            this.trackEnabledStates = new boolean[this.trackCount];
            this.pendingDiscontinuities = new boolean[this.trackCount];
            this.downstreamMediaFormats = new MediaFormat[this.trackCount];
            this.trackInfos = new TrackInfo[this.trackCount];
            for (int i = 0; i < this.trackCount; ++i) {
                MediaFormat format = extractor.getFormat(i);
                this.trackInfos[i] = new TrackInfo(format.mimeType, this.chunkSource.getDurationUs());
            }
            this.prepared = true;
        }
        if (!this.prepared) {
            this.maybeThrowLoadableException();
        }
        return this.prepared;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackCount;
    }

    @Override
    public TrackInfo getTrackInfo(int track) {
        Assertions.checkState(this.prepared);
        return this.trackInfos[track];
    }

    @Override
    public void enable(int track, long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(!this.trackEnabledStates[track]);
        ++this.enabledTrackCount;
        this.trackEnabledStates[track] = true;
        this.downstreamMediaFormats[track] = null;
        if (this.enabledTrackCount == 1) {
            this.seekToUs(positionUs);
        }
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[track]);
        --this.enabledTrackCount;
        this.trackEnabledStates[track] = false;
        this.pendingDiscontinuities[track] = false;
        if (this.enabledTrackCount == 0) {
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.clearState();
            }
        }
    }

    @Override
    public boolean continueBuffering(long playbackPositionUs) throws IOException {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        this.downstreamPositionUs = playbackPositionUs;
        if (!this.extractors.isEmpty()) {
            this.discardSamplesForDisabledTracks(this.extractors.getFirst(), this.downstreamPositionUs);
        }
        return this.continueBufferingInternal();
    }

    private boolean continueBufferingInternal() throws IOException {
        boolean haveSamples;
        this.maybeStartLoading();
        if (this.isPendingReset() || this.extractors.isEmpty()) {
            return false;
        }
        boolean bl = haveSamples = this.prepared && this.haveSamplesForEnabledTracks(this.getCurrentExtractor());
        if (!haveSamples) {
            this.maybeThrowLoadableException();
        }
        return haveSamples;
    }

    @Override
    public int readData(int track, long playbackPositionUs, MediaFormatHolder formatHolder, SampleHolder sampleHolder, boolean onlyReadDiscontinuity) throws IOException {
        Assertions.checkState(this.prepared);
        this.downstreamPositionUs = playbackPositionUs;
        if (this.pendingDiscontinuities[track]) {
            this.pendingDiscontinuities[track] = false;
            return -5;
        }
        if (onlyReadDiscontinuity || this.isPendingReset() || this.extractors.isEmpty()) {
            this.maybeThrowLoadableException();
            return -2;
        }
        TsExtractor extractor = this.getCurrentExtractor();
        if (this.extractors.size() > 1) {
            extractor.configureSpliceTo(this.extractors.get(1));
        }
        int extractorIndex = 0;
        while (this.extractors.size() > extractorIndex + 1 && !extractor.hasSamples(track)) {
            extractor = this.extractors.get(++extractorIndex);
        }
        if (!extractor.isPrepared()) {
            this.maybeThrowLoadableException();
            return -2;
        }
        MediaFormat mediaFormat = extractor.getFormat(track);
        if (mediaFormat != null && !mediaFormat.equals(this.downstreamMediaFormats[track], true)) {
            this.chunkSource.getMaxVideoDimensions(mediaFormat);
            formatHolder.format = mediaFormat;
            this.downstreamMediaFormats[track] = mediaFormat;
            return -4;
        }
        if (extractor.getSample(track, sampleHolder)) {
            sampleHolder.decodeOnly = this.frameAccurateSeeking && sampleHolder.timeUs < this.lastSeekPositionUs;
            return -3;
        }
        if (this.loadingFinished) {
            return -1;
        }
        this.maybeThrowLoadableException();
        return -2;
    }

    @Override
    public void seekToUs(long positionUs) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        this.lastSeekPositionUs = positionUs;
        if (this.pendingResetPositionUs == positionUs || this.downstreamPositionUs == positionUs) {
            this.downstreamPositionUs = positionUs;
            return;
        }
        this.downstreamPositionUs = positionUs;
        for (int i = 0; i < this.pendingDiscontinuities.length; ++i) {
            this.pendingDiscontinuities[i] = true;
        }
        this.restartFrom(positionUs);
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.loadingFinished) {
            return -3L;
        }
        long largestSampleTimestamp = this.extractors.getLast().getLargestSampleTimestamp();
        return largestSampleTimestamp == Long.MIN_VALUE ? this.downstreamPositionUs : largestSampleTimestamp;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        block8: {
            try {
                this.currentLoadable.consume();
                if (!this.isTsChunk(this.currentLoadable)) break block8;
            }
            catch (IOException e) {
                block9: {
                    try {
                        this.currentLoadableException = e;
                        ++this.currentLoadableExceptionCount;
                        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
                        this.currentLoadableExceptionFatal = true;
                        if (!this.isTsChunk(this.currentLoadable)) break block9;
                    }
                    catch (Throwable throwable) {
                        if (this.isTsChunk(this.currentLoadable)) {
                            TsChunk tsChunk = (TsChunk)loadable;
                            this.loadingFinished = tsChunk.isLastChunk;
                        }
                        if (!this.currentLoadableExceptionFatal) {
                            this.clearCurrentLoadable();
                        }
                        this.maybeStartLoading();
                        throw throwable;
                    }
                    TsChunk tsChunk = (TsChunk)loadable;
                    this.loadingFinished = tsChunk.isLastChunk;
                }
                if (!this.currentLoadableExceptionFatal) {
                    this.clearCurrentLoadable();
                }
                this.maybeStartLoading();
            }
            TsChunk tsChunk = (TsChunk)loadable;
            this.loadingFinished = tsChunk.isLastChunk;
        }
        if (!this.currentLoadableExceptionFatal) {
            this.clearCurrentLoadable();
        }
        this.maybeStartLoading();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        if (this.enabledTrackCount > 0) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.clearState();
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException e) {
        this.currentLoadableException = e;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.maybeStartLoading();
    }

    private TsExtractor getCurrentExtractor() {
        TsExtractor extractor = this.extractors.getFirst();
        while (this.extractors.size() > 1 && !this.haveSamplesForEnabledTracks(extractor)) {
            this.extractors.removeFirst().release();
            extractor = this.extractors.getFirst();
        }
        return extractor;
    }

    private void discardSamplesForDisabledTracks(TsExtractor extractor, long timeUs) {
        if (!extractor.isPrepared()) {
            return;
        }
        for (int i = 0; i < this.trackEnabledStates.length; ++i) {
            if (this.trackEnabledStates[i]) continue;
            extractor.discardUntil(i, timeUs);
        }
    }

    private boolean haveSamplesForEnabledTracks(TsExtractor extractor) {
        if (!extractor.isPrepared()) {
            return false;
        }
        for (int i = 0; i < this.trackEnabledStates.length; ++i) {
            if (!this.trackEnabledStates[i] || !extractor.hasSamples(i)) continue;
            return true;
        }
        return false;
    }

    private void maybeThrowLoadableException() throws IOException {
        if (this.currentLoadableException != null && (this.currentLoadableExceptionFatal || this.currentLoadableExceptionCount > this.minLoadableRetryCount)) {
            throw this.currentLoadableException;
        }
    }

    private void restartFrom(long positionUs) {
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearState();
            this.maybeStartLoading();
        }
    }

    private void clearState() {
        for (int i = 0; i < this.extractors.size(); ++i) {
            this.extractors.get(i).release();
        }
        this.extractors.clear();
        this.clearCurrentLoadable();
        this.previousTsLoadable = null;
    }

    private void clearCurrentLoadable() {
        this.currentLoadable = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
        this.currentLoadableExceptionFatal = false;
    }

    private void maybeStartLoading() {
        boolean isBackedOff;
        if (this.currentLoadableExceptionFatal || this.loadingFinished || this.loader.isLoading()) {
            return;
        }
        boolean bl = isBackedOff = this.currentLoadableException != null;
        if (isBackedOff) {
            long elapsedMillis = SystemClock.elapsedRealtime() - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.currentLoadableException = null;
                this.loader.startLoading(this.currentLoadable, this);
            }
            return;
        }
        HlsChunk nextLoadable = this.chunkSource.getChunkOperation(this.previousTsLoadable, this.pendingResetPositionUs, this.downstreamPositionUs);
        if (nextLoadable == null) {
            return;
        }
        this.currentLoadable = nextLoadable;
        if (this.isTsChunk(this.currentLoadable)) {
            this.previousTsLoadable = (TsChunk)this.currentLoadable;
            if (this.isPendingReset()) {
                this.pendingResetPositionUs = -1L;
            }
            if (this.extractors.isEmpty() || this.extractors.getLast() != this.previousTsLoadable.extractor) {
                this.extractors.addLast(this.previousTsLoadable.extractor);
            }
        }
        this.loader.startLoading(this.currentLoadable, this);
    }

    private boolean isTsChunk(HlsChunk chunk) {
        return chunk instanceof TsChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -1L;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    protected final int usToMs(long timeUs) {
        return (int)(timeUs / 1000L);
    }
}

