/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.google.android.exoplayer.text.CaptionStyleCompat;
import com.google.android.exoplayer.util.Util;

public class SubtitleView
extends View {
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final RectF lineBounds = new RectF();
    private final StringBuilder textBuilder = new StringBuilder();
    private final float cornerRadius;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private TextPaint textPaint;
    private Paint paint;
    private int foregroundColor;
    private int backgroundColor;
    private int edgeColor;
    private int edgeType;
    private boolean hasMeasurements;
    private int lastMeasuredWidth;
    private StaticLayout layout;
    private float spacingMult;
    private float spacingAdd;
    private int innerPaddingX;

    public SubtitleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SubtitleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int[] viewAttr = new int[]{16843087, 16842901, 16843287, 16843288};
        TypedArray a = context.obtainStyledAttributes(attrs, viewAttr, defStyleAttr, 0);
        CharSequence text = a.getText(0);
        int textSize = a.getDimensionPixelSize(1, 15);
        this.spacingAdd = a.getDimensionPixelSize(2, 0);
        this.spacingMult = a.getFloat(3, 1.0f);
        a.recycle();
        Resources resources = this.getContext().getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int twoDpInPx = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.cornerRadius = twoDpInPx;
        this.outlineWidth = twoDpInPx;
        this.shadowRadius = twoDpInPx;
        this.shadowOffset = twoDpInPx;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.innerPaddingX = 0;
        this.setText(text);
        this.setTextSize(textSize);
        this.setStyle(CaptionStyleCompat.DEFAULT);
    }

    public SubtitleView(Context context) {
        this(context, null);
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.invalidate();
    }

    public void setText(CharSequence text) {
        this.textBuilder.setLength(0);
        this.textBuilder.append(text);
        this.hasMeasurements = false;
        this.requestLayout();
    }

    public void setTextSize(float size) {
        if (this.textPaint.getTextSize() != size) {
            this.textPaint.setTextSize(size);
            this.innerPaddingX = (int)(size * 0.125f + 0.5f);
            this.hasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setStyle(CaptionStyleCompat style) {
        this.foregroundColor = style.foregroundColor;
        this.backgroundColor = style.backgroundColor;
        this.edgeType = style.edgeType;
        this.edgeColor = style.edgeColor;
        this.setTypeface(style.typeface);
        super.setBackgroundColor(style.windowColor);
        this.hasMeasurements = false;
        this.requestLayout();
    }

    private void setTypeface(Typeface typeface) {
        if (this.textPaint.getTypeface() != typeface) {
            this.textPaint.setTypeface(typeface);
            this.hasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.computeMeasurements(widthSpec)) {
            StaticLayout layout = this.layout;
            int paddingX = this.getPaddingLeft() + this.getPaddingRight() + this.innerPaddingX * 2;
            int height = layout.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
            int width = 0;
            int lineCount = layout.getLineCount();
            for (int i = 0; i < lineCount; ++i) {
                width = Math.max((int)Math.ceil(layout.getLineWidth(i)), width);
            }
            this.setMeasuredDimension(width += paddingX, height);
        } else if (Util.SDK_INT >= 11) {
            this.setTooSmallMeasureDimensionV11();
        } else {
            this.setMeasuredDimension(0, 0);
        }
    }

    @TargetApi(value=11)
    private void setTooSmallMeasureDimensionV11() {
        this.setMeasuredDimension(0x1000000, 0x1000000);
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        this.computeMeasurements(width);
    }

    private boolean computeMeasurements(int maxWidth) {
        if (this.hasMeasurements && maxWidth == this.lastMeasuredWidth) {
            return true;
        }
        int paddingX = this.getPaddingLeft() + this.getPaddingRight() + this.innerPaddingX * 2;
        if ((maxWidth -= paddingX) <= 0) {
            return false;
        }
        this.hasMeasurements = true;
        this.lastMeasuredWidth = maxWidth;
        this.layout = new StaticLayout((CharSequence)this.textBuilder, this.textPaint, maxWidth, null, this.spacingMult, this.spacingAdd, true);
        return true;
    }

    protected void onDraw(Canvas c) {
        StaticLayout layout = this.layout;
        if (layout == null) {
            return;
        }
        int saveCount = c.save();
        int innerPaddingX = this.innerPaddingX;
        c.translate((float)(this.getPaddingLeft() + innerPaddingX), (float)this.getPaddingTop());
        int lineCount = layout.getLineCount();
        TextPaint textPaint = this.textPaint;
        Paint paint = this.paint;
        RectF bounds = this.lineBounds;
        if (Color.alpha((int)this.backgroundColor) > 0) {
            float cornerRadius = this.cornerRadius;
            float previousBottom = layout.getLineTop(0);
            paint.setColor(this.backgroundColor);
            paint.setStyle(Paint.Style.FILL);
            for (int i = 0; i < lineCount; ++i) {
                bounds.left = layout.getLineLeft(i) - (float)innerPaddingX;
                bounds.right = layout.getLineRight(i) + (float)innerPaddingX;
                bounds.top = previousBottom;
                previousBottom = bounds.bottom = (float)layout.getLineBottom(i);
                c.drawRoundRect(bounds, cornerRadius, cornerRadius, paint);
            }
        }
        if (this.edgeType == 1) {
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.outlineWidth);
            textPaint.setColor(this.edgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            layout.draw(c);
        } else if (this.edgeType == 2) {
            textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean raised = this.edgeType == 3;
            int colorUp = raised ? -1 : this.edgeColor;
            int colorDown = raised ? this.edgeColor : -1;
            float offset = this.shadowRadius / 2.0f;
            textPaint.setColor(this.foregroundColor);
            textPaint.setStyle(Paint.Style.FILL);
            textPaint.setShadowLayer(this.shadowRadius, -offset, -offset, colorUp);
            layout.draw(c);
            textPaint.setShadowLayer(this.shadowRadius, offset, offset, colorDown);
        }
        textPaint.setColor(this.foregroundColor);
        textPaint.setStyle(Paint.Style.FILL);
        layout.draw(c);
        textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        c.restoreToCount(saveCount);
    }
}

