/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.eia608;

import com.google.android.exoplayer.text.eia608.ClosedCaption;
import com.google.android.exoplayer.util.BitArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Eia608Parser {
    private static final int PAYLOAD_TYPE_CC = 4;
    private static final int COUNTRY_CODE = 181;
    private static final int PROVIDER_CODE = 49;
    private static final int USER_ID = 1195456820;
    private static final int USER_DATA_TYPE_CODE = 3;
    private static final int[] BASIC_CHARACTER_SET = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 225, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 233, 93, 237, 243, 250, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 231, 247, 209, 241, 9632};
    private static final int[] SPECIAL_CHARACTER_SET = new int[]{174, 176, 189, 191, 8482, 162, 163, 9834, 224, 32, 232, 226, 234, 238, 244, 251};

    public boolean canParse(String mimeType) {
        return mimeType.equals("application/eia-608");
    }

    public List<ClosedCaption> parse(byte[] data, int size, long timeUs) throws IOException {
        if (size <= 0) {
            return null;
        }
        BitArray seiBuffer = new BitArray(data, size);
        seiBuffer.skipBits(3);
        int ccCount = seiBuffer.readBits(5);
        seiBuffer.skipBytes(1);
        ArrayList<ClosedCaption> captions = new ArrayList<ClosedCaption>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < ccCount; ++i) {
            seiBuffer.skipBits(5);
            boolean ccValid = seiBuffer.readBit();
            if (!ccValid) {
                seiBuffer.skipBits(18);
                continue;
            }
            int ccType = seiBuffer.readBits(2);
            if (ccType != 0) {
                seiBuffer.skipBits(16);
                continue;
            }
            seiBuffer.skipBits(1);
            byte ccData1 = (byte)seiBuffer.readBits(7);
            seiBuffer.skipBits(1);
            byte ccData2 = (byte)seiBuffer.readBits(7);
            if (ccData1 == 0 && ccData2 == 0) continue;
            if (ccData1 == 17 && (ccData2 & 0x70) == 48) {
                stringBuilder.append(Eia608Parser.getSpecialChar(ccData2));
                continue;
            }
            if (ccData1 < 32) {
                if (stringBuilder.length() > 0) {
                    captions.add(new ClosedCaption(1, stringBuilder.toString(), timeUs));
                    stringBuilder.setLength(0);
                }
                captions.add(new ClosedCaption(0, new String(new char[]{(char)ccData1, (char)ccData2}), timeUs));
                continue;
            }
            stringBuilder.append(Eia608Parser.getChar(ccData1));
            if (ccData2 == 0) continue;
            stringBuilder.append(Eia608Parser.getChar(ccData2));
        }
        if (stringBuilder.length() > 0) {
            captions.add(new ClosedCaption(1, stringBuilder.toString(), timeUs));
        }
        return Collections.unmodifiableList(captions);
    }

    private static char getChar(byte ccData) {
        int index = (ccData & 0x7F) - 32;
        return (char)BASIC_CHARACTER_SET[index];
    }

    private static char getSpecialChar(byte ccData) {
        int index = ccData & 0xF;
        return (char)SPECIAL_CHARACTER_SET[index];
    }

    public static int parseHeader(BitArray seiBuffer) {
        int b = 0;
        int payloadType = 0;
        do {
            b = seiBuffer.readUnsignedByte();
            payloadType += b;
        } while (b == 255);
        if (payloadType != 4) {
            return 0;
        }
        int payloadSize = 0;
        do {
            b = seiBuffer.readUnsignedByte();
            payloadSize += b;
        } while (b == 255);
        if (payloadSize <= 0) {
            return 0;
        }
        int countryCode = seiBuffer.readUnsignedByte();
        if (countryCode != 181) {
            return 0;
        }
        int providerCode = seiBuffer.readBits(16);
        if (providerCode != 49) {
            return 0;
        }
        int userIdentifier = seiBuffer.readBits(32);
        if (userIdentifier != 1195456820) {
            return 0;
        }
        int userDataTypeCode = seiBuffer.readUnsignedByte();
        if (userDataTypeCode != 3) {
            return 0;
        }
        return payloadSize;
    }
}

