/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ActionBar {

public ActionBar() { throw new RuntimeException("Stub!"); }

public abstract void setCustomView(android.view.View view);

public abstract void setCustomView(android.view.View view, android.app.ActionBar.LayoutParams layoutParams);

public abstract void setCustomView(int resId);

public abstract void setIcon(int resId);

public abstract void setIcon(android.graphics.drawable.Drawable icon);

public abstract void setLogo(int resId);

public abstract void setLogo(android.graphics.drawable.Drawable logo);

@Deprecated
public abstract void setListNavigationCallbacks(android.widget.SpinnerAdapter adapter, android.app.ActionBar.OnNavigationListener callback);

@Deprecated
public abstract void setSelectedNavigationItem(int position);

@Deprecated
public abstract int getSelectedNavigationIndex();

@Deprecated
public abstract int getNavigationItemCount();

public abstract void setTitle(java.lang.CharSequence title);

public abstract void setTitle(int resId);

public abstract void setSubtitle(java.lang.CharSequence subtitle);

public abstract void setSubtitle(int resId);

public abstract void setDisplayOptions(int options);

public abstract void setDisplayOptions(int options, int mask);

public abstract void setDisplayUseLogoEnabled(boolean useLogo);

public abstract void setDisplayShowHomeEnabled(boolean showHome);

public abstract void setDisplayHomeAsUpEnabled(boolean showHomeAsUp);

public abstract void setDisplayShowTitleEnabled(boolean showTitle);

public abstract void setDisplayShowCustomEnabled(boolean showCustom);

public abstract void setBackgroundDrawable(@android.annotation.Nullable android.graphics.drawable.Drawable d);

public void setStackedBackgroundDrawable(android.graphics.drawable.Drawable d) { throw new RuntimeException("Stub!"); }

public void setSplitBackgroundDrawable(android.graphics.drawable.Drawable d) { throw new RuntimeException("Stub!"); }

public abstract android.view.View getCustomView();

public abstract java.lang.CharSequence getTitle();

public abstract java.lang.CharSequence getSubtitle();

@Deprecated
public abstract int getNavigationMode();

@Deprecated
public abstract void setNavigationMode(int mode);

public abstract int getDisplayOptions();

@Deprecated
public abstract android.app.ActionBar.Tab newTab();

@Deprecated
public abstract void addTab(android.app.ActionBar.Tab tab);

@Deprecated
public abstract void addTab(android.app.ActionBar.Tab tab, boolean setSelected);

@Deprecated
public abstract void addTab(android.app.ActionBar.Tab tab, int position);

@Deprecated
public abstract void addTab(android.app.ActionBar.Tab tab, int position, boolean setSelected);

@Deprecated
public abstract void removeTab(android.app.ActionBar.Tab tab);

@Deprecated
public abstract void removeTabAt(int position);

@Deprecated
public abstract void removeAllTabs();

@Deprecated
public abstract void selectTab(android.app.ActionBar.Tab tab);

@Deprecated
public abstract android.app.ActionBar.Tab getSelectedTab();

@Deprecated
public abstract android.app.ActionBar.Tab getTabAt(int index);

@Deprecated
public abstract int getTabCount();

public abstract int getHeight();

public abstract void show();

public abstract void hide();

public abstract boolean isShowing();

public abstract void addOnMenuVisibilityListener(android.app.ActionBar.OnMenuVisibilityListener listener);

public abstract void removeOnMenuVisibilityListener(android.app.ActionBar.OnMenuVisibilityListener listener);

public void setHomeButtonEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public android.content.Context getThemedContext() { throw new RuntimeException("Stub!"); }

public void setHomeAsUpIndicator(android.graphics.drawable.Drawable indicator) { throw new RuntimeException("Stub!"); }

public void setHomeAsUpIndicator(int resId) { throw new RuntimeException("Stub!"); }

public void setHomeActionContentDescription(java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

public void setHomeActionContentDescription(int resId) { throw new RuntimeException("Stub!"); }

public void setHideOnContentScrollEnabled(boolean hideOnContentScroll) { throw new RuntimeException("Stub!"); }

public boolean isHideOnContentScrollEnabled() { throw new RuntimeException("Stub!"); }

public int getHideOffset() { throw new RuntimeException("Stub!"); }

public void setHideOffset(int offset) { throw new RuntimeException("Stub!"); }

public void setElevation(float elevation) { throw new RuntimeException("Stub!"); }

public float getElevation() { throw new RuntimeException("Stub!"); }

public static final int DISPLAY_HOME_AS_UP = 4; // 0x4

public static final int DISPLAY_SHOW_CUSTOM = 16; // 0x10

public static final int DISPLAY_SHOW_HOME = 2; // 0x2

public static final int DISPLAY_SHOW_TITLE = 8; // 0x8

public static final int DISPLAY_USE_LOGO = 1; // 0x1

@Deprecated public static final int NAVIGATION_MODE_LIST = 1; // 0x1

@Deprecated public static final int NAVIGATION_MODE_STANDARD = 0; // 0x0

@Deprecated public static final int NAVIGATION_MODE_TABS = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class LayoutParams extends android.view.ViewGroup.MarginLayoutParams {

public LayoutParams(@android.annotation.NonNull android.content.Context c, android.util.AttributeSet attrs) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int width, int height) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int width, int height, int gravity) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(int gravity) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(android.app.ActionBar.LayoutParams source) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

public LayoutParams(android.view.ViewGroup.LayoutParams source) { super((android.view.ViewGroup.MarginLayoutParams)null); throw new RuntimeException("Stub!"); }

@android.view.ViewDebug.ExportedProperty(category="layout", mapping={@android.view.ViewDebug.IntToString(from=0xffffffff, to="NONE"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.NO_GRAVITY, to="NONE"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.TOP, to="TOP"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.BOTTOM, to="BOTTOM"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.LEFT, to="LEFT"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.RIGHT, to="RIGHT"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.START, to="START"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.END, to="END"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.CENTER_VERTICAL, to="CENTER_VERTICAL"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.FILL_VERTICAL, to="FILL_VERTICAL"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.CENTER_HORIZONTAL, to="CENTER_HORIZONTAL"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.FILL_HORIZONTAL, to="FILL_HORIZONTAL"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.CENTER, to="CENTER"), @android.view.ViewDebug.IntToString(from=android.view.Gravity.FILL, to="FILL")}) public int gravity = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMenuVisibilityListener {

public void onMenuVisibilityChanged(boolean isVisible);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface OnNavigationListener {

@Deprecated
public boolean onNavigationItemSelected(int itemPosition, long itemId);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public abstract static class Tab {

@Deprecated
public Tab() { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract int getPosition();

@Deprecated
public abstract android.graphics.drawable.Drawable getIcon();

@Deprecated
public abstract java.lang.CharSequence getText();

@Deprecated
public abstract android.app.ActionBar.Tab setIcon(android.graphics.drawable.Drawable icon);

@Deprecated
public abstract android.app.ActionBar.Tab setIcon(int resId);

@Deprecated
public abstract android.app.ActionBar.Tab setText(java.lang.CharSequence text);

@Deprecated
public abstract android.app.ActionBar.Tab setText(int resId);

@Deprecated
public abstract android.app.ActionBar.Tab setCustomView(android.view.View view);

@Deprecated
public abstract android.app.ActionBar.Tab setCustomView(int layoutResId);

@Deprecated
public abstract android.view.View getCustomView();

@Deprecated
public abstract android.app.ActionBar.Tab setTag(java.lang.Object obj);

@Deprecated
public abstract java.lang.Object getTag();

@Deprecated
public abstract android.app.ActionBar.Tab setTabListener(android.app.ActionBar.TabListener listener);

@Deprecated
public abstract void select();

@Deprecated
public abstract android.app.ActionBar.Tab setContentDescription(int resId);

@Deprecated
public abstract android.app.ActionBar.Tab setContentDescription(java.lang.CharSequence contentDesc);

@Deprecated
public abstract java.lang.CharSequence getContentDescription();

@Deprecated public static final int INVALID_POSITION = -1; // 0xffffffff
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface TabListener {

@Deprecated
public void onTabSelected(android.app.ActionBar.Tab tab, android.app.FragmentTransaction ft);

@Deprecated
public void onTabUnselected(android.app.ActionBar.Tab tab, android.app.FragmentTransaction ft);

@Deprecated
public void onTabReselected(android.app.ActionBar.Tab tab, android.app.FragmentTransaction ft);
}

}

