/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.usb;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UsbConstants {

public UsbConstants() { throw new RuntimeException("Stub!"); }

public static final int USB_CLASS_APP_SPEC = 254; // 0xfe

public static final int USB_CLASS_AUDIO = 1; // 0x1

public static final int USB_CLASS_CDC_DATA = 10; // 0xa

public static final int USB_CLASS_COMM = 2; // 0x2

public static final int USB_CLASS_CONTENT_SEC = 13; // 0xd

public static final int USB_CLASS_CSCID = 11; // 0xb

public static final int USB_CLASS_HID = 3; // 0x3

public static final int USB_CLASS_HUB = 9; // 0x9

public static final int USB_CLASS_MASS_STORAGE = 8; // 0x8

public static final int USB_CLASS_MISC = 239; // 0xef

public static final int USB_CLASS_PER_INTERFACE = 0; // 0x0

public static final int USB_CLASS_PHYSICA = 5; // 0x5

public static final int USB_CLASS_PRINTER = 7; // 0x7

public static final int USB_CLASS_STILL_IMAGE = 6; // 0x6

public static final int USB_CLASS_VENDOR_SPEC = 255; // 0xff

public static final int USB_CLASS_VIDEO = 14; // 0xe

public static final int USB_CLASS_WIRELESS_CONTROLLER = 224; // 0xe0

public static final int USB_DIR_IN = 128; // 0x80

public static final int USB_DIR_OUT = 0; // 0x0

public static final int USB_ENDPOINT_DIR_MASK = 128; // 0x80

public static final int USB_ENDPOINT_NUMBER_MASK = 15; // 0xf

public static final int USB_ENDPOINT_XFERTYPE_MASK = 3; // 0x3

public static final int USB_ENDPOINT_XFER_BULK = 2; // 0x2

public static final int USB_ENDPOINT_XFER_CONTROL = 0; // 0x0

public static final int USB_ENDPOINT_XFER_INT = 3; // 0x3

public static final int USB_ENDPOINT_XFER_ISOC = 1; // 0x1

public static final int USB_INTERFACE_SUBCLASS_BOOT = 1; // 0x1

public static final int USB_SUBCLASS_VENDOR_SPEC = 255; // 0xff

public static final int USB_TYPE_CLASS = 32; // 0x20

public static final int USB_TYPE_MASK = 96; // 0x60

public static final int USB_TYPE_RESERVED = 96; // 0x60

public static final int USB_TYPE_STANDARD = 0; // 0x0

public static final int USB_TYPE_VENDOR = 64; // 0x40
}

