/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaRoute2Info implements android.os.Parcelable {

MediaRoute2Info() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.CharSequence getName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFeatures() { throw new RuntimeException("Stub!"); }

public boolean isSystemRoute() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri getIconUri() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getDescription() { throw new RuntimeException("Stub!"); }

public int getConnectionState() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getClientPackageName() { throw new RuntimeException("Stub!"); }

public int getVolumeHandling() { throw new RuntimeException("Stub!"); }

public int getVolumeMax() { throw new RuntimeException("Stub!"); }

public int getVolume() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONNECTION_STATE_CONNECTED = 2; // 0x2

public static final int CONNECTION_STATE_CONNECTING = 1; // 0x1

public static final int CONNECTION_STATE_DISCONNECTED = 0; // 0x0

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.MediaRoute2Info> CREATOR;
static { CREATOR = null; }

public static final java.lang.String FEATURE_LIVE_AUDIO = "android.media.route.feature.LIVE_AUDIO";

public static final java.lang.String FEATURE_LIVE_VIDEO = "android.media.route.feature.LIVE_VIDEO";

public static final java.lang.String FEATURE_REMOTE_AUDIO_PLAYBACK = "android.media.route.feature.REMOTE_AUDIO_PLAYBACK";

public static final java.lang.String FEATURE_REMOTE_PLAYBACK = "android.media.route.feature.REMOTE_PLAYBACK";

public static final java.lang.String FEATURE_REMOTE_VIDEO_PLAYBACK = "android.media.route.feature.REMOTE_VIDEO_PLAYBACK";

public static final int PLAYBACK_VOLUME_FIXED = 0; // 0x0

public static final int PLAYBACK_VOLUME_VARIABLE = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.String id, @android.annotation.NonNull java.lang.CharSequence name) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.media.MediaRoute2Info routeInfo) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder addFeature(@android.annotation.NonNull java.lang.String feature) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder addFeatures(@android.annotation.NonNull java.util.Collection<java.lang.String> features) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder clearFeatures() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setIconUri(@android.annotation.Nullable android.net.Uri iconUri) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setDescription(@android.annotation.Nullable java.lang.CharSequence description) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setConnectionState(int connectionState) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setClientPackageName(@android.annotation.Nullable java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolumeHandling(int volumeHandling) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolumeMax(int volumeMax) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setVolume(int volume) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info.Builder setExtras(@android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaRoute2Info build() { throw new RuntimeException("Stub!"); }
}

}

