/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SmsManager {

private SmsManager() { throw new RuntimeException("Stub!"); }

public void sendTextMessage(java.lang.String destinationAddress, java.lang.String scAddress, java.lang.String text, android.app.PendingIntent sentIntent, android.app.PendingIntent deliveryIntent) { throw new RuntimeException("Stub!"); }

public void sendTextMessage(@android.annotation.NonNull java.lang.String destinationAddress, @android.annotation.Nullable java.lang.String scAddress, @android.annotation.NonNull java.lang.String text, @android.annotation.Nullable android.app.PendingIntent sentIntent, @android.annotation.Nullable android.app.PendingIntent deliveryIntent, long messageId) { throw new RuntimeException("Stub!"); }

public void sendTextMessageWithoutPersisting(java.lang.String destinationAddress, java.lang.String scAddress, java.lang.String text, android.app.PendingIntent sentIntent, android.app.PendingIntent deliveryIntent) { throw new RuntimeException("Stub!"); }

public void injectSmsPdu(byte[] pdu, java.lang.String format, android.app.PendingIntent receivedIntent) { throw new RuntimeException("Stub!"); }

public java.util.ArrayList<java.lang.String> divideMessage(java.lang.String text) { throw new RuntimeException("Stub!"); }

public void sendMultipartTextMessage(java.lang.String destinationAddress, java.lang.String scAddress, java.util.ArrayList<java.lang.String> parts, java.util.ArrayList<android.app.PendingIntent> sentIntents, java.util.ArrayList<android.app.PendingIntent> deliveryIntents) { throw new RuntimeException("Stub!"); }

public void sendMultipartTextMessage(@android.annotation.NonNull java.lang.String destinationAddress, @android.annotation.Nullable java.lang.String scAddress, @android.annotation.NonNull java.util.List<java.lang.String> parts, @android.annotation.Nullable java.util.List<android.app.PendingIntent> sentIntents, @android.annotation.Nullable java.util.List<android.app.PendingIntent> deliveryIntents, long messageId) { throw new RuntimeException("Stub!"); }

public void sendMultipartTextMessage(@android.annotation.NonNull java.lang.String destinationAddress, @android.annotation.Nullable java.lang.String scAddress, @android.annotation.NonNull java.util.List<java.lang.String> parts, @android.annotation.Nullable java.util.List<android.app.PendingIntent> sentIntents, @android.annotation.Nullable java.util.List<android.app.PendingIntent> deliveryIntents, @android.annotation.NonNull java.lang.String packageName, @android.annotation.Nullable java.lang.String attributionTag) { throw new RuntimeException("Stub!"); }

public void sendDataMessage(java.lang.String destinationAddress, java.lang.String scAddress, short destinationPort, byte[] data, android.app.PendingIntent sentIntent, android.app.PendingIntent deliveryIntent) { throw new RuntimeException("Stub!"); }

public static android.telephony.SmsManager getDefault() { throw new RuntimeException("Stub!"); }

public static android.telephony.SmsManager getSmsManagerForSubscriptionId(int subId) { throw new RuntimeException("Stub!"); }

public int getSubscriptionId() { throw new RuntimeException("Stub!"); }

public static int getDefaultSmsSubscriptionId() { throw new RuntimeException("Stub!"); }

public void sendMultimediaMessage(android.content.Context context, android.net.Uri contentUri, java.lang.String locationUrl, android.os.Bundle configOverrides, android.app.PendingIntent sentIntent) { throw new RuntimeException("Stub!"); }

public void downloadMultimediaMessage(android.content.Context context, java.lang.String locationUrl, android.net.Uri contentUri, android.os.Bundle configOverrides, android.app.PendingIntent downloadedIntent) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getCarrierConfigValues() { throw new RuntimeException("Stub!"); }

public java.lang.String createAppSpecificSmsToken(android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

public void getSmsMessagesForFinancialApp(android.os.Bundle params, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.telephony.SmsManager.FinancialSmsCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String createAppSpecificSmsTokenWithPackageInfo(@android.annotation.Nullable java.lang.String prefixes, @android.annotation.NonNull android.app.PendingIntent intent) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getSmscAddress() { throw new RuntimeException("Stub!"); }

public boolean setSmscAddress(@android.annotation.NonNull java.lang.String smsc) { throw new RuntimeException("Stub!"); }

public static final java.lang.String EXTRA_MMS_DATA = "android.telephony.extra.MMS_DATA";

public static final java.lang.String EXTRA_MMS_HTTP_STATUS = "android.telephony.extra.MMS_HTTP_STATUS";

public static final java.lang.String MMS_CONFIG_ALIAS_ENABLED = "aliasEnabled";

public static final java.lang.String MMS_CONFIG_ALIAS_MAX_CHARS = "aliasMaxChars";

public static final java.lang.String MMS_CONFIG_ALIAS_MIN_CHARS = "aliasMinChars";

public static final java.lang.String MMS_CONFIG_ALLOW_ATTACH_AUDIO = "allowAttachAudio";

public static final java.lang.String MMS_CONFIG_APPEND_TRANSACTION_ID = "enabledTransID";

public static final java.lang.String MMS_CONFIG_EMAIL_GATEWAY_NUMBER = "emailGatewayNumber";

public static final java.lang.String MMS_CONFIG_GROUP_MMS_ENABLED = "enableGroupMms";

public static final java.lang.String MMS_CONFIG_HTTP_PARAMS = "httpParams";

public static final java.lang.String MMS_CONFIG_HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";

public static final java.lang.String MMS_CONFIG_MAX_IMAGE_HEIGHT = "maxImageHeight";

public static final java.lang.String MMS_CONFIG_MAX_IMAGE_WIDTH = "maxImageWidth";

public static final java.lang.String MMS_CONFIG_MAX_MESSAGE_SIZE = "maxMessageSize";

public static final java.lang.String MMS_CONFIG_MESSAGE_TEXT_MAX_SIZE = "maxMessageTextSize";

public static final java.lang.String MMS_CONFIG_MMS_DELIVERY_REPORT_ENABLED = "enableMMSDeliveryReports";

public static final java.lang.String MMS_CONFIG_MMS_ENABLED = "enabledMMS";

public static final java.lang.String MMS_CONFIG_MMS_READ_REPORT_ENABLED = "enableMMSReadReports";

public static final java.lang.String MMS_CONFIG_MULTIPART_SMS_ENABLED = "enableMultipartSMS";

public static final java.lang.String MMS_CONFIG_NAI_SUFFIX = "naiSuffix";

public static final java.lang.String MMS_CONFIG_NOTIFY_WAP_MMSC_ENABLED = "enabledNotifyWapMMSC";

public static final java.lang.String MMS_CONFIG_RECIPIENT_LIMIT = "recipientLimit";

public static final java.lang.String MMS_CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES = "sendMultipartSmsAsSeparateMessages";

public static final java.lang.String MMS_CONFIG_SHOW_CELL_BROADCAST_APP_LINKS = "config_cellBroadcastAppLinks";

public static final java.lang.String MMS_CONFIG_SMS_DELIVERY_REPORT_ENABLED = "enableSMSDeliveryReports";

public static final java.lang.String MMS_CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD = "smsToMmsTextLengthThreshold";

public static final java.lang.String MMS_CONFIG_SMS_TO_MMS_TEXT_THRESHOLD = "smsToMmsTextThreshold";

public static final java.lang.String MMS_CONFIG_SUBJECT_MAX_LENGTH = "maxSubjectLength";

public static final java.lang.String MMS_CONFIG_SUPPORT_HTTP_CHARSET_HEADER = "supportHttpCharsetHeader";

public static final java.lang.String MMS_CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION = "supportMmsContentDisposition";

public static final java.lang.String MMS_CONFIG_UA_PROF_TAG_NAME = "uaProfTagName";

public static final java.lang.String MMS_CONFIG_UA_PROF_URL = "uaProfUrl";

public static final java.lang.String MMS_CONFIG_USER_AGENT = "userAgent";

public static final int MMS_ERROR_CONFIGURATION_ERROR = 7; // 0x7

public static final int MMS_ERROR_HTTP_FAILURE = 4; // 0x4

public static final int MMS_ERROR_INVALID_APN = 2; // 0x2

public static final int MMS_ERROR_IO_ERROR = 5; // 0x5

public static final int MMS_ERROR_NO_DATA_NETWORK = 8; // 0x8

public static final int MMS_ERROR_RETRY = 6; // 0x6

public static final int MMS_ERROR_UNABLE_CONNECT_MMS = 3; // 0x3

public static final int MMS_ERROR_UNSPECIFIED = 1; // 0x1

public static final int RESULT_BLUETOOTH_DISCONNECTED = 27; // 0x1b

public static final int RESULT_CANCELLED = 23; // 0x17

public static final int RESULT_ENCODING_ERROR = 18; // 0x12

public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 6; // 0x6

public static final int RESULT_ERROR_GENERIC_FAILURE = 1; // 0x1

public static final int RESULT_ERROR_LIMIT_EXCEEDED = 5; // 0x5

public static final int RESULT_ERROR_NONE = 0; // 0x0

public static final int RESULT_ERROR_NO_SERVICE = 4; // 0x4

public static final int RESULT_ERROR_NULL_PDU = 3; // 0x3

public static final int RESULT_ERROR_RADIO_OFF = 2; // 0x2

public static final int RESULT_ERROR_SHORT_CODE_NEVER_ALLOWED = 8; // 0x8

public static final int RESULT_ERROR_SHORT_CODE_NOT_ALLOWED = 7; // 0x7

public static final int RESULT_INTERNAL_ERROR = 21; // 0x15

public static final int RESULT_INVALID_ARGUMENTS = 11; // 0xb

public static final int RESULT_INVALID_BLUETOOTH_ADDRESS = 26; // 0x1a

public static final int RESULT_INVALID_SMSC_ADDRESS = 19; // 0x13

public static final int RESULT_INVALID_SMS_FORMAT = 14; // 0xe

public static final int RESULT_INVALID_STATE = 12; // 0xc

public static final int RESULT_MODEM_ERROR = 16; // 0x10

public static final int RESULT_NETWORK_ERROR = 17; // 0x11

public static final int RESULT_NETWORK_REJECT = 10; // 0xa

public static final int RESULT_NO_BLUETOOTH_SERVICE = 25; // 0x19

public static final int RESULT_NO_DEFAULT_SMS_APP = 32; // 0x20

public static final int RESULT_NO_MEMORY = 13; // 0xd

public static final int RESULT_NO_RESOURCES = 22; // 0x16

public static final int RESULT_OPERATION_NOT_ALLOWED = 20; // 0x14

public static final int RESULT_RADIO_NOT_AVAILABLE = 9; // 0x9

public static final int RESULT_RECEIVE_DISPATCH_FAILURE = 500; // 0x1f4

public static final int RESULT_RECEIVE_INJECTED_NULL_PDU = 501; // 0x1f5

public static final int RESULT_RECEIVE_NULL_MESSAGE_FROM_RIL = 503; // 0x1f7

public static final int RESULT_RECEIVE_RUNTIME_EXCEPTION = 502; // 0x1f6

public static final int RESULT_RECEIVE_SQL_EXCEPTION = 505; // 0x1f9

public static final int RESULT_RECEIVE_URI_EXCEPTION = 506; // 0x1fa

public static final int RESULT_RECEIVE_WHILE_ENCRYPTED = 504; // 0x1f8

public static final int RESULT_REMOTE_EXCEPTION = 31; // 0x1f

public static final int RESULT_REQUEST_NOT_SUPPORTED = 24; // 0x18

public static final int RESULT_RIL_CANCELLED = 119; // 0x77

public static final int RESULT_RIL_ENCODING_ERR = 109; // 0x6d

public static final int RESULT_RIL_INTERNAL_ERR = 113; // 0x71

public static final int RESULT_RIL_INVALID_ARGUMENTS = 104; // 0x68

public static final int RESULT_RIL_INVALID_MODEM_STATE = 115; // 0x73

public static final int RESULT_RIL_INVALID_SMSC_ADDRESS = 110; // 0x6e

public static final int RESULT_RIL_INVALID_SMS_FORMAT = 107; // 0x6b

public static final int RESULT_RIL_INVALID_STATE = 103; // 0x67

public static final int RESULT_RIL_MODEM_ERR = 111; // 0x6f

public static final int RESULT_RIL_NETWORK_ERR = 112; // 0x70

public static final int RESULT_RIL_NETWORK_NOT_READY = 116; // 0x74

public static final int RESULT_RIL_NETWORK_REJECT = 102; // 0x66

public static final int RESULT_RIL_NO_MEMORY = 105; // 0x69

public static final int RESULT_RIL_NO_RESOURCES = 118; // 0x76

public static final int RESULT_RIL_OPERATION_NOT_ALLOWED = 117; // 0x75

public static final int RESULT_RIL_RADIO_NOT_AVAILABLE = 100; // 0x64

public static final int RESULT_RIL_REQUEST_NOT_SUPPORTED = 114; // 0x72

public static final int RESULT_RIL_REQUEST_RATE_LIMITED = 106; // 0x6a

public static final int RESULT_RIL_SIM_ABSENT = 120; // 0x78

public static final int RESULT_RIL_SMS_SEND_FAIL_RETRY = 101; // 0x65

public static final int RESULT_RIL_SYSTEM_ERR = 108; // 0x6c

public static final int RESULT_SMS_BLOCKED_DURING_EMERGENCY = 29; // 0x1d

public static final int RESULT_SMS_SEND_RETRY_FAILED = 30; // 0x1e

public static final int RESULT_SYSTEM_ERROR = 15; // 0xf

public static final int RESULT_UNEXPECTED_EVENT_STOP_SENDING = 28; // 0x1c

public static final int STATUS_ON_ICC_FREE = 0; // 0x0

public static final int STATUS_ON_ICC_READ = 1; // 0x1

public static final int STATUS_ON_ICC_SENT = 5; // 0x5

public static final int STATUS_ON_ICC_UNREAD = 3; // 0x3

public static final int STATUS_ON_ICC_UNSENT = 7; // 0x7
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class FinancialSmsCallback {

public FinancialSmsCallback() { throw new RuntimeException("Stub!"); }

public abstract void onFinancialSmsMessages(android.database.CursorWindow msgs);
}

}

