/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.text;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface InputType {

public static final int TYPE_CLASS_DATETIME = 4; // 0x4

public static final int TYPE_CLASS_NUMBER = 2; // 0x2

public static final int TYPE_CLASS_PHONE = 3; // 0x3

public static final int TYPE_CLASS_TEXT = 1; // 0x1

public static final int TYPE_DATETIME_VARIATION_DATE = 16; // 0x10

public static final int TYPE_DATETIME_VARIATION_NORMAL = 0; // 0x0

public static final int TYPE_DATETIME_VARIATION_TIME = 32; // 0x20

public static final int TYPE_MASK_CLASS = 15; // 0xf

public static final int TYPE_MASK_FLAGS = 16773120; // 0xfff000

public static final int TYPE_MASK_VARIATION = 4080; // 0xff0

public static final int TYPE_NULL = 0; // 0x0

public static final int TYPE_NUMBER_FLAG_DECIMAL = 8192; // 0x2000

public static final int TYPE_NUMBER_FLAG_SIGNED = 4096; // 0x1000

public static final int TYPE_NUMBER_VARIATION_NORMAL = 0; // 0x0

public static final int TYPE_NUMBER_VARIATION_PASSWORD = 16; // 0x10

public static final int TYPE_TEXT_FLAG_AUTO_COMPLETE = 65536; // 0x10000

public static final int TYPE_TEXT_FLAG_AUTO_CORRECT = 32768; // 0x8000

public static final int TYPE_TEXT_FLAG_CAP_CHARACTERS = 4096; // 0x1000

public static final int TYPE_TEXT_FLAG_CAP_SENTENCES = 16384; // 0x4000

public static final int TYPE_TEXT_FLAG_CAP_WORDS = 8192; // 0x2000

public static final int TYPE_TEXT_FLAG_IME_MULTI_LINE = 262144; // 0x40000

public static final int TYPE_TEXT_FLAG_MULTI_LINE = 131072; // 0x20000

public static final int TYPE_TEXT_FLAG_NO_SUGGESTIONS = 524288; // 0x80000

public static final int TYPE_TEXT_VARIATION_EMAIL_ADDRESS = 32; // 0x20

public static final int TYPE_TEXT_VARIATION_EMAIL_SUBJECT = 48; // 0x30

public static final int TYPE_TEXT_VARIATION_FILTER = 176; // 0xb0

public static final int TYPE_TEXT_VARIATION_LONG_MESSAGE = 80; // 0x50

public static final int TYPE_TEXT_VARIATION_NORMAL = 0; // 0x0

public static final int TYPE_TEXT_VARIATION_PASSWORD = 128; // 0x80

public static final int TYPE_TEXT_VARIATION_PERSON_NAME = 96; // 0x60

public static final int TYPE_TEXT_VARIATION_PHONETIC = 192; // 0xc0

public static final int TYPE_TEXT_VARIATION_POSTAL_ADDRESS = 112; // 0x70

public static final int TYPE_TEXT_VARIATION_SHORT_MESSAGE = 64; // 0x40

public static final int TYPE_TEXT_VARIATION_URI = 16; // 0x10

public static final int TYPE_TEXT_VARIATION_VISIBLE_PASSWORD = 144; // 0x90

public static final int TYPE_TEXT_VARIATION_WEB_EDIT_TEXT = 160; // 0xa0

public static final int TYPE_TEXT_VARIATION_WEB_EMAIL_ADDRESS = 208; // 0xd0

public static final int TYPE_TEXT_VARIATION_WEB_PASSWORD = 224; // 0xe0
}

