/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface WindowInsetsController {

public void show(int types);

public void hide(int types);

public void controlWindowInsetsAnimation(int types, long durationMillis, @android.annotation.Nullable android.view.animation.Interpolator interpolator, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal, @android.annotation.NonNull android.view.WindowInsetsAnimationControlListener listener);

public void setSystemBarsAppearance(int appearance, int mask);

public int getSystemBarsAppearance();

public void setSystemBarsBehavior(int behavior);

public int getSystemBarsBehavior();

public void addOnControllableInsetsChangedListener(@android.annotation.NonNull android.view.WindowInsetsController.OnControllableInsetsChangedListener listener);

public void removeOnControllableInsetsChangedListener(@android.annotation.NonNull android.view.WindowInsetsController.OnControllableInsetsChangedListener listener);

public static final int APPEARANCE_LIGHT_NAVIGATION_BARS = 16; // 0x10

public static final int APPEARANCE_LIGHT_STATUS_BARS = 8; // 0x8

public static final int BEHAVIOR_SHOW_BARS_BY_SWIPE = 1; // 0x1

public static final int BEHAVIOR_SHOW_BARS_BY_TOUCH = 0; // 0x0

public static final int BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnControllableInsetsChangedListener {

public void onControllableInsetsChanged(@android.annotation.NonNull android.view.WindowInsetsController controller, int typeMask);
}

}

