/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.inputmethod;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface InputConnection {

public java.lang.CharSequence getTextBeforeCursor(int n, int flags);

public java.lang.CharSequence getTextAfterCursor(int n, int flags);

public java.lang.CharSequence getSelectedText(int flags);

public int getCursorCapsMode(int reqModes);

public android.view.inputmethod.ExtractedText getExtractedText(android.view.inputmethod.ExtractedTextRequest request, int flags);

public boolean deleteSurroundingText(int beforeLength, int afterLength);

public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength);

public boolean setComposingText(java.lang.CharSequence text, int newCursorPosition);

public boolean setComposingRegion(int start, int end);

public boolean finishComposingText();

public boolean commitText(java.lang.CharSequence text, int newCursorPosition);

public boolean commitCompletion(android.view.inputmethod.CompletionInfo text);

public boolean commitCorrection(android.view.inputmethod.CorrectionInfo correctionInfo);

public boolean setSelection(int start, int end);

public boolean performEditorAction(int editorAction);

public boolean performContextMenuAction(int id);

public boolean beginBatchEdit();

public boolean endBatchEdit();

public boolean sendKeyEvent(android.view.KeyEvent event);

public boolean clearMetaKeyStates(int states);

public boolean reportFullscreenMode(boolean enabled);

public boolean performPrivateCommand(java.lang.String action, android.os.Bundle data);

public boolean requestCursorUpdates(int cursorUpdateMode);

public android.os.Handler getHandler();

public void closeConnection();

public boolean commitContent(@android.annotation.NonNull android.view.inputmethod.InputContentInfo inputContentInfo, int flags, @android.annotation.Nullable android.os.Bundle opts);

public static final int CURSOR_UPDATE_IMMEDIATE = 1; // 0x1

public static final int CURSOR_UPDATE_MONITOR = 2; // 0x2

public static final int GET_EXTRACTED_TEXT_MONITOR = 1; // 0x1

public static final int GET_TEXT_WITH_STYLES = 1; // 0x1

public static final int INPUT_CONTENT_GRANT_READ_URI_PERMISSION = 1; // 0x1
}

