/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;

public class VideoSurfaceView
extends SurfaceView {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_PERCENT = 0.01f;
    private float videoAspectRatio;

    public VideoSurfaceView(Context context) {
        super(context);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setVideoWidthHeightRatio(float widthHeightRatio) {
        if (this.videoAspectRatio != widthHeightRatio) {
            this.videoAspectRatio = widthHeightRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.videoAspectRatio != 0.0f) {
            float viewAspectRatio = (float)width / (float)height;
            float aspectDeformation = this.videoAspectRatio / viewAspectRatio - 1.0f;
            if (aspectDeformation > 0.01f) {
                height = (int)((float)width / this.videoAspectRatio);
            } else if (aspectDeformation < -0.01f) {
                width = (int)((float)height * this.videoAspectRatio);
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

