/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.util.Log;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.ttml.TtmlNode;
import com.google.android.exoplayer.text.ttml.TtmlSubtitle;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class TtmlParser
implements SubtitleParser {
    private static final String TAG = "TtmlParser";
    private static final String ATTR_BEGIN = "begin";
    private static final String ATTR_DURATION = "dur";
    private static final String ATTR_END = "end";
    private static final Pattern CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
    private static final Pattern OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    private static final int DEFAULT_FRAMERATE = 30;
    private static final int DEFAULT_SUBFRAMERATE = 1;
    private static final int DEFAULT_TICKRATE = 1;
    private final XmlPullParserFactory xmlParserFactory;
    private final boolean strictParsing;

    public TtmlParser() {
        this(true);
    }

    public TtmlParser(boolean strictParsing) {
        this.strictParsing = strictParsing;
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public Subtitle parse(InputStream inputStream, String inputEncoding, long startTimeUs) throws IOException {
        try {
            XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
            xmlParser.setInput(inputStream, inputEncoding);
            TtmlSubtitle ttmlSubtitle = null;
            LinkedList<TtmlNode> nodeStack = new LinkedList<TtmlNode>();
            int unsupportedNodeDepth = 0;
            int eventType = xmlParser.getEventType();
            while (eventType != 1) {
                TtmlNode parent = (TtmlNode)nodeStack.peekLast();
                if (unsupportedNodeDepth == 0) {
                    String name = xmlParser.getName();
                    if (eventType == 2) {
                        if (!TtmlParser.isSupportedTag(name)) {
                            Log.i((String)TAG, (String)("Ignoring unsupported tag: " + xmlParser.getName()));
                            ++unsupportedNodeDepth;
                        } else {
                            try {
                                TtmlNode node = this.parseNode(xmlParser, parent);
                                nodeStack.addLast(node);
                                if (parent != null) {
                                    parent.addChild(node);
                                }
                            }
                            catch (ParserException e) {
                                if (this.strictParsing) {
                                    throw e;
                                }
                                Log.e((String)TAG, (String)"Suppressing parser error", (Throwable)e);
                                ++unsupportedNodeDepth;
                            }
                        }
                    } else if (eventType == 4) {
                        parent.addChild(TtmlNode.buildTextNode(xmlParser.getText()));
                    } else if (eventType == 3) {
                        if (xmlParser.getName().equals("tt")) {
                            ttmlSubtitle = new TtmlSubtitle((TtmlNode)nodeStack.getLast(), startTimeUs);
                        }
                        nodeStack.removeLast();
                    }
                } else if (eventType == 2) {
                    ++unsupportedNodeDepth;
                } else if (eventType == 3) {
                    --unsupportedNodeDepth;
                }
                xmlParser.next();
                eventType = xmlParser.getEventType();
            }
            return ttmlSubtitle;
        }
        catch (XmlPullParserException xppe) {
            throw new ParserException("Unable to parse source", xppe);
        }
    }

    @Override
    public boolean canParse(String mimeType) {
        return "application/ttml+xml".equals(mimeType);
    }

    private TtmlNode parseNode(XmlPullParser parser, TtmlNode parent) throws ParserException {
        long duration = 0L;
        long startTime = -1L;
        long endTime = -1L;
        int attributeCount = parser.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attr = parser.getAttributeName(i).replaceFirst("^.*:", "");
            String value = parser.getAttributeValue(i);
            if (attr.equals(ATTR_BEGIN)) {
                startTime = TtmlParser.parseTimeExpression(value, 30, 1, 1);
                continue;
            }
            if (attr.equals(ATTR_END)) {
                endTime = TtmlParser.parseTimeExpression(value, 30, 1, 1);
                continue;
            }
            if (!attr.equals(ATTR_DURATION)) continue;
            duration = TtmlParser.parseTimeExpression(value, 30, 1, 1);
        }
        if (parent != null && parent.startTimeUs != -1L) {
            if (startTime != -1L) {
                startTime += parent.startTimeUs;
            }
            if (endTime != -1L) {
                endTime += parent.startTimeUs;
            }
        }
        if (endTime == -1L) {
            if (duration > 0L) {
                endTime = startTime + duration;
            } else if (parent != null && parent.endTimeUs != -1L) {
                endTime = parent.endTimeUs;
            }
        }
        return TtmlNode.buildNode(parser.getName(), startTime, endTime);
    }

    private static boolean isSupportedTag(String tag) {
        return tag.equals("tt") || tag.equals("head") || tag.equals("body") || tag.equals("div") || tag.equals("p") || tag.equals("span") || tag.equals("br") || tag.equals("style") || tag.equals("styling") || tag.equals("layout") || tag.equals("region") || tag.equals("metadata") || tag.equals("smpte:image") || tag.equals("smpte:data") || tag.equals("smpte:information");
    }

    private static long parseTimeExpression(String time, int frameRate, int subframeRate, int tickRate) throws ParserException {
        Matcher matcher = CLOCK_TIME.matcher(time);
        if (matcher.matches()) {
            String hours = matcher.group(1);
            double durationSeconds = Long.parseLong(hours) * 3600L;
            String minutes = matcher.group(2);
            durationSeconds += (double)(Long.parseLong(minutes) * 60L);
            String seconds = matcher.group(3);
            durationSeconds += (double)Long.parseLong(seconds);
            String fraction = matcher.group(4);
            durationSeconds += fraction != null ? Double.parseDouble(fraction) : 0.0;
            String frames = matcher.group(5);
            durationSeconds += frames != null ? (double)Long.parseLong(frames) / (double)frameRate : 0.0;
            String subframes = matcher.group(6);
            return (long)((durationSeconds += subframes != null ? (double)Long.parseLong(subframes) / (double)subframeRate / (double)frameRate : 0.0) * 1000000.0);
        }
        matcher = OFFSET_TIME.matcher(time);
        if (matcher.matches()) {
            String timeValue = matcher.group(1);
            double offsetSeconds = Double.parseDouble(timeValue);
            String unit = matcher.group(2);
            if (unit.equals("h")) {
                offsetSeconds *= 3600.0;
            } else if (unit.equals("m")) {
                offsetSeconds *= 60.0;
            } else if (!unit.equals("s")) {
                if (unit.equals("ms")) {
                    offsetSeconds /= 1000.0;
                } else if (unit.equals("f")) {
                    offsetSeconds /= (double)frameRate;
                } else if (unit.equals("t")) {
                    offsetSeconds /= (double)tickRate;
                }
            }
            return (long)(offsetSeconds * 1000000.0);
        }
        throw new ParserException("Malformed time expression: " + time);
    }
}

