/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSource;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    public static final int SDK_INT = Build.VERSION.SDK_INT;
    private static final Pattern XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?([Zz]|((\\+|\\-)(\\d\\d):(\\d\\d)))?");
    private static final Pattern XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");

    private Util() {
    }

    public static boolean isUrlLocalFile(URL url) {
        return url.getProtocol().equals("file");
    }

    public static boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static ExecutorService newSingleThreadExecutor(final String threadName) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName);
            }
        });
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(final String threadName) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName);
            }
        });
    }

    public static void closeQuietly(DataSource dataSource) {
        try {
            dataSource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toLowerInvariant(String text) {
        return text == null ? null : text.toLowerCase(Locale.US);
    }

    public static Uri parseBaseUri(String uriString) {
        return Uri.parse((String)uriString.substring(0, uriString.lastIndexOf(47)));
    }

    public static Uri getMergedUri(Uri baseUri, String stringUri) {
        if (stringUri == null) {
            return baseUri;
        }
        if (baseUri == null) {
            return Uri.parse((String)stringUri);
        }
        if (stringUri.startsWith("/")) {
            stringUri = stringUri.substring(1);
            return new Uri.Builder().scheme(baseUri.getScheme()).authority(baseUri.getAuthority()).appendEncodedPath(stringUri).build();
        }
        Uri uri = Uri.parse((String)stringUri);
        if (uri.isAbsolute()) {
            return uri;
        }
        return Uri.withAppendedPath((Uri)baseUri, (String)stringUri);
    }

    public static int binarySearchFloor(long[] a, long key, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(a, key);
        index = index < 0 ? -(index + 2) : (inclusive ? index : index - 1);
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static int binarySearchCeil(long[] a, long key, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(a, key);
        index = index < 0 ? ~index : (inclusive ? index : index + 1);
        return stayInBounds ? Math.min(a.length - 1, index) : index;
    }

    public static <T> int binarySearchFloor(List<? extends Comparable<? super T>> list, T key, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, key);
        index = index < 0 ? -(index + 2) : (inclusive ? index : index - 1);
        return stayInBounds ? Math.max(0, index) : index;
    }

    public static <T> int binarySearchCeil(List<? extends Comparable<? super T>> list, T key, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, key);
        index = index < 0 ? ~index : (inclusive ? index : index + 1);
        return stayInBounds ? Math.min(list.size() - 1, index) : index;
    }

    public static long parseXsDuration(String value) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(value);
        if (matcher.matches()) {
            boolean negated = !TextUtils.isEmpty((CharSequence)matcher.group(1));
            String years = matcher.group(3);
            double durationSeconds = years != null ? Double.parseDouble(years) * 3.1556908E7 : 0.0;
            String months = matcher.group(5);
            durationSeconds += months != null ? Double.parseDouble(months) * 2629739.0 : 0.0;
            String days = matcher.group(7);
            durationSeconds += days != null ? Double.parseDouble(days) * 86400.0 : 0.0;
            String hours = matcher.group(10);
            durationSeconds += hours != null ? Double.parseDouble(hours) * 3600.0 : 0.0;
            String minutes = matcher.group(12);
            durationSeconds += minutes != null ? Double.parseDouble(minutes) * 60.0 : 0.0;
            String seconds = matcher.group(14);
            long durationMillis = (long)((durationSeconds += seconds != null ? Double.parseDouble(seconds) : 0.0) * 1000.0);
            return negated ? -durationMillis : durationMillis;
        }
        return (long)(Double.parseDouble(value) * 3600.0 * 1000.0);
    }

    public static long parseXsDateTime(String value) throws ParseException {
        int timezoneShift;
        Matcher matcher = XS_DATE_TIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new ParseException("Invalid date/time format: " + value, 0);
        }
        if (matcher.group(9) == null) {
            timezoneShift = 0;
        } else if (matcher.group(9).equalsIgnoreCase("Z")) {
            timezoneShift = 0;
        } else {
            timezoneShift = Integer.parseInt(matcher.group(12)) * 60 + Integer.parseInt(matcher.group(13));
            if (matcher.group(11).equals("-")) {
                timezoneShift *= -1;
            }
        }
        GregorianCalendar dateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        dateTime.clear();
        dateTime.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
        if (!TextUtils.isEmpty((CharSequence)matcher.group(8))) {
            BigDecimal bd = new BigDecimal("0." + matcher.group(8));
            dateTime.set(14, bd.movePointRight(3).intValue());
        }
        long time = dateTime.getTimeInMillis();
        if (timezoneShift != 0) {
            time -= (long)(timezoneShift * 60000);
        }
        return time;
    }

    public static long scaleLargeTimestamp(long timestamp, long multiplier, long divisor) {
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            return timestamp / divisionFactor;
        }
        if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            return timestamp * multiplicationFactor;
        }
        double multiplicationFactor = (double)multiplier / (double)divisor;
        return (long)((double)timestamp * multiplicationFactor);
    }

    public static long[] scaleLargeTimestamps(List<Long> timestamps, long multiplier, long divisor) {
        long[] scaledTimestamps = new long[timestamps.size()];
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = divisor / multiplier;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) / divisionFactor;
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = multiplier / divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = timestamps.get(i) * multiplicationFactor;
            }
        } else {
            double multiplicationFactor = (double)multiplier / (double)divisor;
            for (int i = 0; i < scaledTimestamps.length; ++i) {
                scaledTimestamps[i] = (long)((double)timestamps.get(i).longValue() * multiplicationFactor);
            }
        }
        return scaledTimestamps;
    }

    public static int[] toArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int length = list.size();
        int[] intArray = new int[length];
        for (int i = 0; i < length; ++i) {
            intArray[i] = list.get(i);
        }
        return intArray;
    }
}

